<?php

namespace EnumType;

/**
 * This class stands for TrailerTypeEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TrailerTypeEnum
 * @subpackage Enumerations
 */
class TrailerTypeEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Van'
     * @return string 'Van'
     */
    const VALUE_VAN = 'Van';
    /**
     * Constant for value 'Tarp'
     * @return string 'Tarp'
     */
    const VALUE_TARP = 'Tarp';
    /**
     * Constant for value 'Rollers'
     * @return string 'Rollers'
     */
    const VALUE_ROLLERS = 'Rollers';
    /**
     * Constant for value 'Bars'
     * @return string 'Bars'
     */
    const VALUE_BARS = 'Bars';
    /**
     * Constant for value 'Any'
     * @return string 'Any'
     */
    const VALUE_ANY = 'Any';
    /**
     * Constant for value 'Sea'
     * @return string 'Sea'
     */
    const VALUE_SEA = 'Sea';
    /**
     * Constant for value 'Double'
     * @return string 'Double'
     */
    const VALUE_DOUBLE = 'Double';
    /**
     * Constant for value 'Minitir'
     * @return string 'Minitir'
     */
    const VALUE_MINITIR = 'Minitir';
    /**
     * Constant for value 'PrendaColgada'
     * @return string 'PrendaColgada'
     */
    const VALUE_PRENDA_COLGADA = 'PrendaColgada';
    /**
     * Constant for value 'RoadTrain'
     * @return string 'RoadTrain'
     */
    const VALUE_ROAD_TRAIN = 'RoadTrain';
    /**
     * Constant for value 'GigatrailerTT'
     * @return string 'GigatrailerTT'
     */
    const VALUE_GIGATRAILER_TT = 'GigatrailerTT';
    /**
     * Constant for value 'GigatrailerAir'
     * @return string 'GigatrailerAir'
     */
    const VALUE_GIGATRAILER_AIR = 'GigatrailerAir';
    /**
     * Constant for value 'BoxTT'
     * @return string 'BoxTT'
     */
    const VALUE_BOX_TT = 'BoxTT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_VAN
     * @uses self::VALUE_TARP
     * @uses self::VALUE_ROLLERS
     * @uses self::VALUE_BARS
     * @uses self::VALUE_ANY
     * @uses self::VALUE_SEA
     * @uses self::VALUE_DOUBLE
     * @uses self::VALUE_MINITIR
     * @uses self::VALUE_PRENDA_COLGADA
     * @uses self::VALUE_ROAD_TRAIN
     * @uses self::VALUE_GIGATRAILER_TT
     * @uses self::VALUE_GIGATRAILER_AIR
     * @uses self::VALUE_BOX_TT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_VAN,
            self::VALUE_TARP,
            self::VALUE_ROLLERS,
            self::VALUE_BARS,
            self::VALUE_ANY,
            self::VALUE_SEA,
            self::VALUE_DOUBLE,
            self::VALUE_MINITIR,
            self::VALUE_PRENDA_COLGADA,
            self::VALUE_ROAD_TRAIN,
            self::VALUE_GIGATRAILER_TT,
            self::VALUE_GIGATRAILER_AIR,
            self::VALUE_BOX_TT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
