<?php

namespace EnumType;

/**
 * This class stands for NotificationStatusEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NotificationStatusEnum
 * @subpackage Enumerations
 */
class NotificationStatusEnum
{
    /**
     * Constant for value 'Send'
     * @return string 'Send'
     */
    const VALUE_SEND = 'Send';
    /**
     * Constant for value 'Recieved'
     * @return string 'Recieved'
     */
    const VALUE_RECIEVED = 'Recieved';
    /**
     * Constant for value 'Read'
     * @return string 'Read'
     */
    const VALUE_READ = 'Read';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SEND
     * @uses self::VALUE_RECIEVED
     * @uses self::VALUE_READ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SEND,
            self::VALUE_RECIEVED,
            self::VALUE_READ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
