<?php

namespace EnumType;

/**
 * This class stands for NotificationEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NotificationEnum
 * @subpackage Enumerations
 */
class NotificationEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Driver'
     * @return string 'Driver'
     */
    const VALUE_DRIVER = 'Driver';
    /**
     * Constant for value 'ControlTower'
     * @return string 'ControlTower'
     */
    const VALUE_CONTROL_TOWER = 'ControlTower';
    /**
     * Constant for value 'Carrier'
     * @return string 'Carrier'
     */
    const VALUE_CARRIER = 'Carrier';
    /**
     * Constant for value 'Warehouse'
     * @return string 'Warehouse'
     */
    const VALUE_WAREHOUSE = 'Warehouse';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_DRIVER
     * @uses self::VALUE_CONTROL_TOWER
     * @uses self::VALUE_CARRIER
     * @uses self::VALUE_WAREHOUSE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_DRIVER,
            self::VALUE_CONTROL_TOWER,
            self::VALUE_CARRIER,
            self::VALUE_WAREHOUSE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
