<?php

namespace EnumType;

/**
 * This class stands for DistributionCenterStateEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DistributionCenterStateEnum
 * @subpackage Enumerations
 */
class DistributionCenterStateEnum
{
    /**
     * Constant for value 'InProcess'
     * @return string 'InProcess'
     */
    const VALUE_IN_PROCESS = 'InProcess';
    /**
     * Constant for value 'OnArrival'
     * @return string 'OnArrival'
     */
    const VALUE_ON_ARRIVAL = 'OnArrival';
    /**
     * Constant for value 'Finished'
     * @return string 'Finished'
     */
    const VALUE_FINISHED = 'Finished';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'OnLoad'
     * @return string 'OnLoad'
     */
    const VALUE_ON_LOAD = 'OnLoad';
    /**
     * Constant for value 'OnUnload'
     * @return string 'OnUnload'
     */
    const VALUE_ON_UNLOAD = 'OnUnload';
    /**
     * Constant for value 'OnLoadUnload'
     * @return string 'OnLoadUnload'
     */
    const VALUE_ON_LOAD_UNLOAD = 'OnLoadUnload';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_IN_PROCESS
     * @uses self::VALUE_ON_ARRIVAL
     * @uses self::VALUE_FINISHED
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_ON_LOAD
     * @uses self::VALUE_ON_UNLOAD
     * @uses self::VALUE_ON_LOAD_UNLOAD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IN_PROCESS,
            self::VALUE_ON_ARRIVAL,
            self::VALUE_FINISHED,
            self::VALUE_PENDING,
            self::VALUE_ON_LOAD,
            self::VALUE_ON_UNLOAD,
            self::VALUE_ON_LOAD_UNLOAD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
