<?php

namespace EnumType;

/**
 * This class stands for DelayEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DelayEnum
 * @subpackage Enumerations
 */
class DelayEnum
{
    /**
     * Constant for value 'OnTime'
     * @return string 'OnTime'
     */
    const VALUE_ON_TIME = 'OnTime';
    /**
     * Constant for value 'Delay'
     * @return string 'Delay'
     */
    const VALUE_DELAY = 'Delay';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ON_TIME
     * @uses self::VALUE_DELAY
     * @uses self::VALUE_PENDING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ON_TIME,
            self::VALUE_DELAY,
            self::VALUE_PENDING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
