<?php

namespace EnumType;

/**
 * This class stands for ChainEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ChainEnum
 * @subpackage Enumerations
 */
class ChainEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Inditex'
     * @return string 'Inditex'
     */
    const VALUE_INDITEX = 'Inditex';
    /**
     * Constant for value 'PullBear'
     * @return string 'PullBear'
     */
    const VALUE_PULL_BEAR = 'PullBear';
    /**
     * Constant for value 'Bershka'
     * @return string 'Bershka'
     */
    const VALUE_BERSHKA = 'Bershka';
    /**
     * Constant for value 'Oysho'
     * @return string 'Oysho'
     */
    const VALUE_OYSHO = 'Oysho';
    /**
     * Constant for value 'Uterque'
     * @return string 'Uterque'
     */
    const VALUE_UTERQUE = 'Uterque';
    /**
     * Constant for value 'Zara'
     * @return string 'Zara'
     */
    const VALUE_ZARA = 'Zara';
    /**
     * Constant for value 'ZaraHome'
     * @return string 'ZaraHome'
     */
    const VALUE_ZARA_HOME = 'ZaraHome';
    /**
     * Constant for value 'MassimoDutti'
     * @return string 'MassimoDutti'
     */
    const VALUE_MASSIMO_DUTTI = 'MassimoDutti';
    /**
     * Constant for value 'Stradivarius'
     * @return string 'Stradivarius'
     */
    const VALUE_STRADIVARIUS = 'Stradivarius';
    /**
     * Constant for value 'Cadenas'
     * @return string 'Cadenas'
     */
    const VALUE_CADENAS = 'Cadenas';
    /**
     * Constant for value 'Tempe'
     * @return string 'Tempe'
     */
    const VALUE_TEMPE = 'Tempe';
    /**
     * Constant for value 'Obras'
     * @return string 'Obras'
     */
    const VALUE_OBRAS = 'Obras';
    /**
     * Constant for value 'Lefties'
     * @return string 'Lefties'
     */
    const VALUE_LEFTIES = 'Lefties';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_INDITEX
     * @uses self::VALUE_PULL_BEAR
     * @uses self::VALUE_BERSHKA
     * @uses self::VALUE_OYSHO
     * @uses self::VALUE_UTERQUE
     * @uses self::VALUE_ZARA
     * @uses self::VALUE_ZARA_HOME
     * @uses self::VALUE_MASSIMO_DUTTI
     * @uses self::VALUE_STRADIVARIUS
     * @uses self::VALUE_CADENAS
     * @uses self::VALUE_TEMPE
     * @uses self::VALUE_OBRAS
     * @uses self::VALUE_LEFTIES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_INDITEX,
            self::VALUE_PULL_BEAR,
            self::VALUE_BERSHKA,
            self::VALUE_OYSHO,
            self::VALUE_UTERQUE,
            self::VALUE_ZARA,
            self::VALUE_ZARA_HOME,
            self::VALUE_MASSIMO_DUTTI,
            self::VALUE_STRADIVARIUS,
            self::VALUE_CADENAS,
            self::VALUE_TEMPE,
            self::VALUE_OBRAS,
            self::VALUE_LEFTIES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
