<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PositionTrace StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PositionTrace
 * @subpackage Structs
 */
class PositionTrace extends AbstractStructBase
{
    /**
     * The Bearing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Bearing;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The FuelLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FuelLevel;
    /**
     * The Ignition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Ignition;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Latitude;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Longitude;
    /**
     * The Speed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Speed;
    /**
     * The Town
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Town;
    /**
     * The TrailerPlate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrailerPlate;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Weight;
    /**
     * Constructor method for PositionTrace
     * @uses PositionTrace::setBearing()
     * @uses PositionTrace::setDate()
     * @uses PositionTrace::setFuelLevel()
     * @uses PositionTrace::setIgnition()
     * @uses PositionTrace::setLatitude()
     * @uses PositionTrace::setLongitude()
     * @uses PositionTrace::setSpeed()
     * @uses PositionTrace::setTown()
     * @uses PositionTrace::setTrailerPlate()
     * @uses PositionTrace::setWeight()
     * @param int $bearing
     * @param string $date
     * @param int $fuelLevel
     * @param bool $ignition
     * @param float $latitude
     * @param float $longitude
     * @param int $speed
     * @param string $town
     * @param string $trailerPlate
     * @param int $weight
     */
    public function __construct($bearing = null, $date = null, $fuelLevel = null, $ignition = null, $latitude = null, $longitude = null, $speed = null, $town = null, $trailerPlate = null, $weight = null)
    {
        $this
            ->setBearing($bearing)
            ->setDate($date)
            ->setFuelLevel($fuelLevel)
            ->setIgnition($ignition)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setSpeed($speed)
            ->setTown($town)
            ->setTrailerPlate($trailerPlate)
            ->setWeight($weight);
    }
    /**
     * Get Bearing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBearing()
    {
        return isset($this->Bearing) ? $this->Bearing : null;
    }
    /**
     * Set Bearing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bearing
     * @return \StructType\PositionTrace
     */
    public function setBearing($bearing = null)
    {
        // validation for constraint: int
        if (!is_null($bearing) && !is_numeric($bearing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bearing)), __LINE__);
        }
        if (is_null($bearing) || (is_array($bearing) && empty($bearing))) {
            unset($this->Bearing);
        } else {
            $this->Bearing = $bearing;
        }
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\PositionTrace
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get FuelLevel value
     * @return int|null
     */
    public function getFuelLevel()
    {
        return $this->FuelLevel;
    }
    /**
     * Set FuelLevel value
     * @param int $fuelLevel
     * @return \StructType\PositionTrace
     */
    public function setFuelLevel($fuelLevel = null)
    {
        // validation for constraint: int
        if (!is_null($fuelLevel) && !is_numeric($fuelLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fuelLevel)), __LINE__);
        }
        $this->FuelLevel = $fuelLevel;
        return $this;
    }
    /**
     * Get Ignition value
     * @return bool|null
     */
    public function getIgnition()
    {
        return $this->Ignition;
    }
    /**
     * Set Ignition value
     * @param bool $ignition
     * @return \StructType\PositionTrace
     */
    public function setIgnition($ignition = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignition) && !is_bool($ignition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ignition)), __LINE__);
        }
        $this->Ignition = $ignition;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\PositionTrace
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \StructType\PositionTrace
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Speed value
     * @return int|null
     */
    public function getSpeed()
    {
        return $this->Speed;
    }
    /**
     * Set Speed value
     * @param int $speed
     * @return \StructType\PositionTrace
     */
    public function setSpeed($speed = null)
    {
        // validation for constraint: int
        if (!is_null($speed) && !is_numeric($speed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($speed)), __LINE__);
        }
        $this->Speed = $speed;
        return $this;
    }
    /**
     * Get Town value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTown()
    {
        return isset($this->Town) ? $this->Town : null;
    }
    /**
     * Set Town value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $town
     * @return \StructType\PositionTrace
     */
    public function setTown($town = null)
    {
        // validation for constraint: string
        if (!is_null($town) && !is_string($town)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($town)), __LINE__);
        }
        if (is_null($town) || (is_array($town) && empty($town))) {
            unset($this->Town);
        } else {
            $this->Town = $town;
        }
        return $this;
    }
    /**
     * Get TrailerPlate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrailerPlate()
    {
        return isset($this->TrailerPlate) ? $this->TrailerPlate : null;
    }
    /**
     * Set TrailerPlate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trailerPlate
     * @return \StructType\PositionTrace
     */
    public function setTrailerPlate($trailerPlate = null)
    {
        // validation for constraint: string
        if (!is_null($trailerPlate) && !is_string($trailerPlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trailerPlate)), __LINE__);
        }
        if (is_null($trailerPlate) || (is_array($trailerPlate) && empty($trailerPlate))) {
            unset($this->TrailerPlate);
        } else {
            $this->TrailerPlate = $trailerPlate;
        }
        return $this;
    }
    /**
     * Get Weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param int $weight
     * @return \StructType\PositionTrace
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !is_numeric($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PositionTrace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
