<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DtoTrackIncidenceWs StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DtoTrackIncidenceWs
 * @subpackage Structs
 */
class DtoTrackIncidenceWs extends AbstractStructBase
{
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateTime;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IncidenceTypeId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IncidenceTypeId;
    /**
     * The Observation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observation;
    /**
     * The SendNotifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SendNotifications;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The TrackTransportId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TrackTransportId;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $User;
    /**
     * The UserCreated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserCreated;
    /**
     * The WarehousesNotificated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarehousesNotificated;
    /**
     * Constructor method for DtoTrackIncidenceWs
     * @uses DtoTrackIncidenceWs::setDateTime()
     * @uses DtoTrackIncidenceWs::setId()
     * @uses DtoTrackIncidenceWs::setIncidenceTypeId()
     * @uses DtoTrackIncidenceWs::setObservation()
     * @uses DtoTrackIncidenceWs::setSendNotifications()
     * @uses DtoTrackIncidenceWs::setStatus()
     * @uses DtoTrackIncidenceWs::setTrackTransportId()
     * @uses DtoTrackIncidenceWs::setUser()
     * @uses DtoTrackIncidenceWs::setUserCreated()
     * @uses DtoTrackIncidenceWs::setWarehousesNotificated()
     * @param string $dateTime
     * @param int $id
     * @param int $incidenceTypeId
     * @param string $observation
     * @param string $sendNotifications
     * @param string $status
     * @param int $trackTransportId
     * @param string $user
     * @param string $userCreated
     * @param string $warehousesNotificated
     */
    public function __construct($dateTime = null, $id = null, $incidenceTypeId = null, $observation = null, $sendNotifications = null, $status = null, $trackTransportId = null, $user = null, $userCreated = null, $warehousesNotificated = null)
    {
        $this
            ->setDateTime($dateTime)
            ->setId($id)
            ->setIncidenceTypeId($incidenceTypeId)
            ->setObservation($observation)
            ->setSendNotifications($sendNotifications)
            ->setStatus($status)
            ->setTrackTransportId($trackTransportId)
            ->setUser($user)
            ->setUserCreated($userCreated)
            ->setWarehousesNotificated($warehousesNotificated);
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\DtoTrackIncidenceWs
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\DtoTrackIncidenceWs
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IncidenceTypeId value
     * @return int|null
     */
    public function getIncidenceTypeId()
    {
        return $this->IncidenceTypeId;
    }
    /**
     * Set IncidenceTypeId value
     * @param int $incidenceTypeId
     * @return \StructType\DtoTrackIncidenceWs
     */
    public function setIncidenceTypeId($incidenceTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($incidenceTypeId) && !is_numeric($incidenceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($incidenceTypeId)), __LINE__);
        }
        $this->IncidenceTypeId = $incidenceTypeId;
        return $this;
    }
    /**
     * Get Observation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservation()
    {
        return isset($this->Observation) ? $this->Observation : null;
    }
    /**
     * Set Observation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observation
     * @return \StructType\DtoTrackIncidenceWs
     */
    public function setObservation($observation = null)
    {
        // validation for constraint: string
        if (!is_null($observation) && !is_string($observation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($observation)), __LINE__);
        }
        if (is_null($observation) || (is_array($observation) && empty($observation))) {
            unset($this->Observation);
        } else {
            $this->Observation = $observation;
        }
        return $this;
    }
    /**
     * Get SendNotifications value
     * @return string|null
     */
    public function getSendNotifications()
    {
        return $this->SendNotifications;
    }
    /**
     * Set SendNotifications value
     * @uses \EnumType\NotificationEnum::valueIsValid()
     * @uses \EnumType\NotificationEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sendNotifications
     * @return \StructType\DtoTrackIncidenceWs
     */
    public function setSendNotifications($sendNotifications = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NotificationEnum::valueIsValid($sendNotifications)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sendNotifications, implode(', ', \EnumType\NotificationEnum::getValidValues())), __LINE__);
        }
        $this->SendNotifications = $sendNotifications;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\TrackIncidenceStatusEnum::valueIsValid()
     * @uses \EnumType\TrackIncidenceStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\DtoTrackIncidenceWs
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TrackIncidenceStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\TrackIncidenceStatusEnum::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TrackTransportId value
     * @return int|null
     */
    public function getTrackTransportId()
    {
        return $this->TrackTransportId;
    }
    /**
     * Set TrackTransportId value
     * @param int $trackTransportId
     * @return \StructType\DtoTrackIncidenceWs
     */
    public function setTrackTransportId($trackTransportId = null)
    {
        // validation for constraint: int
        if (!is_null($trackTransportId) && !is_numeric($trackTransportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($trackTransportId)), __LINE__);
        }
        $this->TrackTransportId = $trackTransportId;
        return $this;
    }
    /**
     * Get User value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUser()
    {
        return isset($this->User) ? $this->User : null;
    }
    /**
     * Set User value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $user
     * @return \StructType\DtoTrackIncidenceWs
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($user)), __LINE__);
        }
        if (is_null($user) || (is_array($user) && empty($user))) {
            unset($this->User);
        } else {
            $this->User = $user;
        }
        return $this;
    }
    /**
     * Get UserCreated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserCreated()
    {
        return isset($this->UserCreated) ? $this->UserCreated : null;
    }
    /**
     * Set UserCreated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userCreated
     * @return \StructType\DtoTrackIncidenceWs
     */
    public function setUserCreated($userCreated = null)
    {
        // validation for constraint: string
        if (!is_null($userCreated) && !is_string($userCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userCreated)), __LINE__);
        }
        if (is_null($userCreated) || (is_array($userCreated) && empty($userCreated))) {
            unset($this->UserCreated);
        } else {
            $this->UserCreated = $userCreated;
        }
        return $this;
    }
    /**
     * Get WarehousesNotificated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehousesNotificated()
    {
        return isset($this->WarehousesNotificated) ? $this->WarehousesNotificated : null;
    }
    /**
     * Set WarehousesNotificated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehousesNotificated
     * @return \StructType\DtoTrackIncidenceWs
     */
    public function setWarehousesNotificated($warehousesNotificated = null)
    {
        // validation for constraint: string
        if (!is_null($warehousesNotificated) && !is_string($warehousesNotificated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehousesNotificated)), __LINE__);
        }
        if (is_null($warehousesNotificated) || (is_array($warehousesNotificated) && empty($warehousesNotificated))) {
            unset($this->WarehousesNotificated);
        } else {
            $this->WarehousesNotificated = $warehousesNotificated;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoTrackIncidenceWs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
