<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DtoTrackActivityWs StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DtoTrackActivityWs
 * @subpackage Structs
 */
class DtoTrackActivityWs extends AbstractStructBase
{
    /**
     * The CarrierEnd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CarrierEnd;
    /**
     * The CarrierReal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CarrierReal;
    /**
     * The CarrierScheduled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CarrierScheduled;
    /**
     * The CarrierStart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CarrierStart;
    /**
     * The Dock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Dock;
    /**
     * The Driver
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Driver;
    /**
     * The EstimatedDatetimeArrival
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstimatedDatetimeArrival;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Latitude;
    /**
     * The Logitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Logitude;
    /**
     * The OffSet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OffSet;
    /**
     * The RealTimeEnd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RealTimeEnd;
    /**
     * The RealTimeStart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RealTimeStart;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The TimeOffset
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $TimeOffset;
    /**
     * The TrackActivityContents
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDtoTrackActivityContentWs
     */
    public $TrackActivityContents;
    /**
     * The TrackTransportId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TrackTransportId;
    /**
     * The TrailerPlate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrailerPlate;
    /**
     * The TruckPlate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TruckPlate;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The WarehouseArrive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarehouseArrive;
    /**
     * The WarehouseEnd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarehouseEnd;
    /**
     * The WarehouseId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $WarehouseId;
    /**
     * The WarehouseName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarehouseName;
    /**
     * The WarehouseScheduledDepart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $WarehouseScheduledDepart;
    /**
     * The WarehouseScheduledStart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $WarehouseScheduledStart;
    /**
     * The WarehouseStart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarehouseStart;
    /**
     * Constructor method for DtoTrackActivityWs
     * @uses DtoTrackActivityWs::setCarrierEnd()
     * @uses DtoTrackActivityWs::setCarrierReal()
     * @uses DtoTrackActivityWs::setCarrierScheduled()
     * @uses DtoTrackActivityWs::setCarrierStart()
     * @uses DtoTrackActivityWs::setDock()
     * @uses DtoTrackActivityWs::setDriver()
     * @uses DtoTrackActivityWs::setEstimatedDatetimeArrival()
     * @uses DtoTrackActivityWs::setId()
     * @uses DtoTrackActivityWs::setLatitude()
     * @uses DtoTrackActivityWs::setLogitude()
     * @uses DtoTrackActivityWs::setOffSet()
     * @uses DtoTrackActivityWs::setRealTimeEnd()
     * @uses DtoTrackActivityWs::setRealTimeStart()
     * @uses DtoTrackActivityWs::setState()
     * @uses DtoTrackActivityWs::setTimeOffset()
     * @uses DtoTrackActivityWs::setTrackActivityContents()
     * @uses DtoTrackActivityWs::setTrackTransportId()
     * @uses DtoTrackActivityWs::setTrailerPlate()
     * @uses DtoTrackActivityWs::setTruckPlate()
     * @uses DtoTrackActivityWs::setType()
     * @uses DtoTrackActivityWs::setWarehouseArrive()
     * @uses DtoTrackActivityWs::setWarehouseEnd()
     * @uses DtoTrackActivityWs::setWarehouseId()
     * @uses DtoTrackActivityWs::setWarehouseName()
     * @uses DtoTrackActivityWs::setWarehouseScheduledDepart()
     * @uses DtoTrackActivityWs::setWarehouseScheduledStart()
     * @uses DtoTrackActivityWs::setWarehouseStart()
     * @param string $carrierEnd
     * @param string $carrierReal
     * @param string $carrierScheduled
     * @param string $carrierStart
     * @param string $dock
     * @param string $driver
     * @param string $estimatedDatetimeArrival
     * @param int $id
     * @param float $latitude
     * @param float $logitude
     * @param int $offSet
     * @param string $realTimeEnd
     * @param string $realTimeStart
     * @param string $state
     * @param string $timeOffset
     * @param \ArrayType\ArrayOfDtoTrackActivityContentWs $trackActivityContents
     * @param int $trackTransportId
     * @param string $trailerPlate
     * @param string $truckPlate
     * @param string $type
     * @param string $warehouseArrive
     * @param string $warehouseEnd
     * @param int $warehouseId
     * @param string $warehouseName
     * @param string $warehouseScheduledDepart
     * @param string $warehouseScheduledStart
     * @param string $warehouseStart
     */
    public function __construct($carrierEnd = null, $carrierReal = null, $carrierScheduled = null, $carrierStart = null, $dock = null, $driver = null, $estimatedDatetimeArrival = null, $id = null, $latitude = null, $logitude = null, $offSet = null, $realTimeEnd = null, $realTimeStart = null, $state = null, $timeOffset = null, \ArrayType\ArrayOfDtoTrackActivityContentWs $trackActivityContents = null, $trackTransportId = null, $trailerPlate = null, $truckPlate = null, $type = null, $warehouseArrive = null, $warehouseEnd = null, $warehouseId = null, $warehouseName = null, $warehouseScheduledDepart = null, $warehouseScheduledStart = null, $warehouseStart = null)
    {
        $this
            ->setCarrierEnd($carrierEnd)
            ->setCarrierReal($carrierReal)
            ->setCarrierScheduled($carrierScheduled)
            ->setCarrierStart($carrierStart)
            ->setDock($dock)
            ->setDriver($driver)
            ->setEstimatedDatetimeArrival($estimatedDatetimeArrival)
            ->setId($id)
            ->setLatitude($latitude)
            ->setLogitude($logitude)
            ->setOffSet($offSet)
            ->setRealTimeEnd($realTimeEnd)
            ->setRealTimeStart($realTimeStart)
            ->setState($state)
            ->setTimeOffset($timeOffset)
            ->setTrackActivityContents($trackActivityContents)
            ->setTrackTransportId($trackTransportId)
            ->setTrailerPlate($trailerPlate)
            ->setTruckPlate($truckPlate)
            ->setType($type)
            ->setWarehouseArrive($warehouseArrive)
            ->setWarehouseEnd($warehouseEnd)
            ->setWarehouseId($warehouseId)
            ->setWarehouseName($warehouseName)
            ->setWarehouseScheduledDepart($warehouseScheduledDepart)
            ->setWarehouseScheduledStart($warehouseScheduledStart)
            ->setWarehouseStart($warehouseStart);
    }
    /**
     * Get CarrierEnd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrierEnd()
    {
        return isset($this->CarrierEnd) ? $this->CarrierEnd : null;
    }
    /**
     * Set CarrierEnd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrierEnd
     * @return \StructType\DtoTrackActivityWs
     */
    public function setCarrierEnd($carrierEnd = null)
    {
        // validation for constraint: string
        if (!is_null($carrierEnd) && !is_string($carrierEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierEnd)), __LINE__);
        }
        if (is_null($carrierEnd) || (is_array($carrierEnd) && empty($carrierEnd))) {
            unset($this->CarrierEnd);
        } else {
            $this->CarrierEnd = $carrierEnd;
        }
        return $this;
    }
    /**
     * Get CarrierReal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrierReal()
    {
        return isset($this->CarrierReal) ? $this->CarrierReal : null;
    }
    /**
     * Set CarrierReal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrierReal
     * @return \StructType\DtoTrackActivityWs
     */
    public function setCarrierReal($carrierReal = null)
    {
        // validation for constraint: string
        if (!is_null($carrierReal) && !is_string($carrierReal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierReal)), __LINE__);
        }
        if (is_null($carrierReal) || (is_array($carrierReal) && empty($carrierReal))) {
            unset($this->CarrierReal);
        } else {
            $this->CarrierReal = $carrierReal;
        }
        return $this;
    }
    /**
     * Get CarrierScheduled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrierScheduled()
    {
        return isset($this->CarrierScheduled) ? $this->CarrierScheduled : null;
    }
    /**
     * Set CarrierScheduled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrierScheduled
     * @return \StructType\DtoTrackActivityWs
     */
    public function setCarrierScheduled($carrierScheduled = null)
    {
        // validation for constraint: string
        if (!is_null($carrierScheduled) && !is_string($carrierScheduled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierScheduled)), __LINE__);
        }
        if (is_null($carrierScheduled) || (is_array($carrierScheduled) && empty($carrierScheduled))) {
            unset($this->CarrierScheduled);
        } else {
            $this->CarrierScheduled = $carrierScheduled;
        }
        return $this;
    }
    /**
     * Get CarrierStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrierStart()
    {
        return isset($this->CarrierStart) ? $this->CarrierStart : null;
    }
    /**
     * Set CarrierStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrierStart
     * @return \StructType\DtoTrackActivityWs
     */
    public function setCarrierStart($carrierStart = null)
    {
        // validation for constraint: string
        if (!is_null($carrierStart) && !is_string($carrierStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierStart)), __LINE__);
        }
        if (is_null($carrierStart) || (is_array($carrierStart) && empty($carrierStart))) {
            unset($this->CarrierStart);
        } else {
            $this->CarrierStart = $carrierStart;
        }
        return $this;
    }
    /**
     * Get Dock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDock()
    {
        return isset($this->Dock) ? $this->Dock : null;
    }
    /**
     * Set Dock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dock
     * @return \StructType\DtoTrackActivityWs
     */
    public function setDock($dock = null)
    {
        // validation for constraint: string
        if (!is_null($dock) && !is_string($dock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dock)), __LINE__);
        }
        if (is_null($dock) || (is_array($dock) && empty($dock))) {
            unset($this->Dock);
        } else {
            $this->Dock = $dock;
        }
        return $this;
    }
    /**
     * Get Driver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDriver()
    {
        return isset($this->Driver) ? $this->Driver : null;
    }
    /**
     * Set Driver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $driver
     * @return \StructType\DtoTrackActivityWs
     */
    public function setDriver($driver = null)
    {
        // validation for constraint: string
        if (!is_null($driver) && !is_string($driver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driver)), __LINE__);
        }
        if (is_null($driver) || (is_array($driver) && empty($driver))) {
            unset($this->Driver);
        } else {
            $this->Driver = $driver;
        }
        return $this;
    }
    /**
     * Get EstimatedDatetimeArrival value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstimatedDatetimeArrival()
    {
        return isset($this->EstimatedDatetimeArrival) ? $this->EstimatedDatetimeArrival : null;
    }
    /**
     * Set EstimatedDatetimeArrival value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estimatedDatetimeArrival
     * @return \StructType\DtoTrackActivityWs
     */
    public function setEstimatedDatetimeArrival($estimatedDatetimeArrival = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDatetimeArrival) && !is_string($estimatedDatetimeArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedDatetimeArrival)), __LINE__);
        }
        if (is_null($estimatedDatetimeArrival) || (is_array($estimatedDatetimeArrival) && empty($estimatedDatetimeArrival))) {
            unset($this->EstimatedDatetimeArrival);
        } else {
            $this->EstimatedDatetimeArrival = $estimatedDatetimeArrival;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\DtoTrackActivityWs
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \StructType\DtoTrackActivityWs
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get Logitude value
     * @return float|null
     */
    public function getLogitude()
    {
        return $this->Logitude;
    }
    /**
     * Set Logitude value
     * @param float $logitude
     * @return \StructType\DtoTrackActivityWs
     */
    public function setLogitude($logitude = null)
    {
        $this->Logitude = $logitude;
        return $this;
    }
    /**
     * Get OffSet value
     * @return int|null
     */
    public function getOffSet()
    {
        return $this->OffSet;
    }
    /**
     * Set OffSet value
     * @param int $offSet
     * @return \StructType\DtoTrackActivityWs
     */
    public function setOffSet($offSet = null)
    {
        // validation for constraint: int
        if (!is_null($offSet) && !is_numeric($offSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offSet)), __LINE__);
        }
        $this->OffSet = $offSet;
        return $this;
    }
    /**
     * Get RealTimeEnd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRealTimeEnd()
    {
        return isset($this->RealTimeEnd) ? $this->RealTimeEnd : null;
    }
    /**
     * Set RealTimeEnd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $realTimeEnd
     * @return \StructType\DtoTrackActivityWs
     */
    public function setRealTimeEnd($realTimeEnd = null)
    {
        // validation for constraint: string
        if (!is_null($realTimeEnd) && !is_string($realTimeEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($realTimeEnd)), __LINE__);
        }
        if (is_null($realTimeEnd) || (is_array($realTimeEnd) && empty($realTimeEnd))) {
            unset($this->RealTimeEnd);
        } else {
            $this->RealTimeEnd = $realTimeEnd;
        }
        return $this;
    }
    /**
     * Get RealTimeStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRealTimeStart()
    {
        return isset($this->RealTimeStart) ? $this->RealTimeStart : null;
    }
    /**
     * Set RealTimeStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $realTimeStart
     * @return \StructType\DtoTrackActivityWs
     */
    public function setRealTimeStart($realTimeStart = null)
    {
        // validation for constraint: string
        if (!is_null($realTimeStart) && !is_string($realTimeStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($realTimeStart)), __LINE__);
        }
        if (is_null($realTimeStart) || (is_array($realTimeStart) && empty($realTimeStart))) {
            unset($this->RealTimeStart);
        } else {
            $this->RealTimeStart = $realTimeStart;
        }
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @uses \EnumType\DistributionCenterStateEnum::valueIsValid()
     * @uses \EnumType\DistributionCenterStateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\DtoTrackActivityWs
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DistributionCenterStateEnum::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \EnumType\DistributionCenterStateEnum::getValidValues())), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get TimeOffset value
     * @return string|null
     */
    public function getTimeOffset()
    {
        return $this->TimeOffset;
    }
    /**
     * Set TimeOffset value
     * @param string $timeOffset
     * @return \StructType\DtoTrackActivityWs
     */
    public function setTimeOffset($timeOffset = null)
    {
        // validation for constraint: maxInclusive
        if ($timeOffset > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 0, "%s" given', $timeOffset), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($timeOffset < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 0, "%s" given', $timeOffset), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($timeOffset) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $timeOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?", "%s" given', var_export($timeOffset, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($timeOffset) && !is_string($timeOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeOffset)), __LINE__);
        }
        $this->TimeOffset = $timeOffset;
        return $this;
    }
    /**
     * Get TrackActivityContents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDtoTrackActivityContentWs|null
     */
    public function getTrackActivityContents()
    {
        return isset($this->TrackActivityContents) ? $this->TrackActivityContents : null;
    }
    /**
     * Set TrackActivityContents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDtoTrackActivityContentWs $trackActivityContents
     * @return \StructType\DtoTrackActivityWs
     */
    public function setTrackActivityContents(\ArrayType\ArrayOfDtoTrackActivityContentWs $trackActivityContents = null)
    {
        if (is_null($trackActivityContents) || (is_array($trackActivityContents) && empty($trackActivityContents))) {
            unset($this->TrackActivityContents);
        } else {
            $this->TrackActivityContents = $trackActivityContents;
        }
        return $this;
    }
    /**
     * Get TrackTransportId value
     * @return int|null
     */
    public function getTrackTransportId()
    {
        return $this->TrackTransportId;
    }
    /**
     * Set TrackTransportId value
     * @param int $trackTransportId
     * @return \StructType\DtoTrackActivityWs
     */
    public function setTrackTransportId($trackTransportId = null)
    {
        // validation for constraint: int
        if (!is_null($trackTransportId) && !is_numeric($trackTransportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($trackTransportId)), __LINE__);
        }
        $this->TrackTransportId = $trackTransportId;
        return $this;
    }
    /**
     * Get TrailerPlate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrailerPlate()
    {
        return isset($this->TrailerPlate) ? $this->TrailerPlate : null;
    }
    /**
     * Set TrailerPlate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trailerPlate
     * @return \StructType\DtoTrackActivityWs
     */
    public function setTrailerPlate($trailerPlate = null)
    {
        // validation for constraint: string
        if (!is_null($trailerPlate) && !is_string($trailerPlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trailerPlate)), __LINE__);
        }
        if (is_null($trailerPlate) || (is_array($trailerPlate) && empty($trailerPlate))) {
            unset($this->TrailerPlate);
        } else {
            $this->TrailerPlate = $trailerPlate;
        }
        return $this;
    }
    /**
     * Get TruckPlate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTruckPlate()
    {
        return isset($this->TruckPlate) ? $this->TruckPlate : null;
    }
    /**
     * Set TruckPlate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $truckPlate
     * @return \StructType\DtoTrackActivityWs
     */
    public function setTruckPlate($truckPlate = null)
    {
        // validation for constraint: string
        if (!is_null($truckPlate) && !is_string($truckPlate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($truckPlate)), __LINE__);
        }
        if (is_null($truckPlate) || (is_array($truckPlate) && empty($truckPlate))) {
            unset($this->TruckPlate);
        } else {
            $this->TruckPlate = $truckPlate;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ActivityTypeEnum::valueIsValid()
     * @uses \EnumType\ActivityTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\DtoTrackActivityWs
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActivityTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ActivityTypeEnum::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get WarehouseArrive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehouseArrive()
    {
        return isset($this->WarehouseArrive) ? $this->WarehouseArrive : null;
    }
    /**
     * Set WarehouseArrive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehouseArrive
     * @return \StructType\DtoTrackActivityWs
     */
    public function setWarehouseArrive($warehouseArrive = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseArrive) && !is_string($warehouseArrive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouseArrive)), __LINE__);
        }
        if (is_null($warehouseArrive) || (is_array($warehouseArrive) && empty($warehouseArrive))) {
            unset($this->WarehouseArrive);
        } else {
            $this->WarehouseArrive = $warehouseArrive;
        }
        return $this;
    }
    /**
     * Get WarehouseEnd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehouseEnd()
    {
        return isset($this->WarehouseEnd) ? $this->WarehouseEnd : null;
    }
    /**
     * Set WarehouseEnd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehouseEnd
     * @return \StructType\DtoTrackActivityWs
     */
    public function setWarehouseEnd($warehouseEnd = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseEnd) && !is_string($warehouseEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouseEnd)), __LINE__);
        }
        if (is_null($warehouseEnd) || (is_array($warehouseEnd) && empty($warehouseEnd))) {
            unset($this->WarehouseEnd);
        } else {
            $this->WarehouseEnd = $warehouseEnd;
        }
        return $this;
    }
    /**
     * Get WarehouseId value
     * @return int|null
     */
    public function getWarehouseId()
    {
        return $this->WarehouseId;
    }
    /**
     * Set WarehouseId value
     * @param int $warehouseId
     * @return \StructType\DtoTrackActivityWs
     */
    public function setWarehouseId($warehouseId = null)
    {
        // validation for constraint: int
        if (!is_null($warehouseId) && !is_numeric($warehouseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($warehouseId)), __LINE__);
        }
        $this->WarehouseId = $warehouseId;
        return $this;
    }
    /**
     * Get WarehouseName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehouseName()
    {
        return isset($this->WarehouseName) ? $this->WarehouseName : null;
    }
    /**
     * Set WarehouseName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehouseName
     * @return \StructType\DtoTrackActivityWs
     */
    public function setWarehouseName($warehouseName = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseName) && !is_string($warehouseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouseName)), __LINE__);
        }
        if (is_null($warehouseName) || (is_array($warehouseName) && empty($warehouseName))) {
            unset($this->WarehouseName);
        } else {
            $this->WarehouseName = $warehouseName;
        }
        return $this;
    }
    /**
     * Get WarehouseScheduledDepart value
     * @return string|null
     */
    public function getWarehouseScheduledDepart()
    {
        return $this->WarehouseScheduledDepart;
    }
    /**
     * Set WarehouseScheduledDepart value
     * @param string $warehouseScheduledDepart
     * @return \StructType\DtoTrackActivityWs
     */
    public function setWarehouseScheduledDepart($warehouseScheduledDepart = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseScheduledDepart) && !is_string($warehouseScheduledDepart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouseScheduledDepart)), __LINE__);
        }
        $this->WarehouseScheduledDepart = $warehouseScheduledDepart;
        return $this;
    }
    /**
     * Get WarehouseScheduledStart value
     * @return string|null
     */
    public function getWarehouseScheduledStart()
    {
        return $this->WarehouseScheduledStart;
    }
    /**
     * Set WarehouseScheduledStart value
     * @param string $warehouseScheduledStart
     * @return \StructType\DtoTrackActivityWs
     */
    public function setWarehouseScheduledStart($warehouseScheduledStart = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseScheduledStart) && !is_string($warehouseScheduledStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouseScheduledStart)), __LINE__);
        }
        $this->WarehouseScheduledStart = $warehouseScheduledStart;
        return $this;
    }
    /**
     * Get WarehouseStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehouseStart()
    {
        return isset($this->WarehouseStart) ? $this->WarehouseStart : null;
    }
    /**
     * Set WarehouseStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehouseStart
     * @return \StructType\DtoTrackActivityWs
     */
    public function setWarehouseStart($warehouseStart = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseStart) && !is_string($warehouseStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouseStart)), __LINE__);
        }
        if (is_null($warehouseStart) || (is_array($warehouseStart) && empty($warehouseStart))) {
            unset($this->WarehouseStart);
        } else {
            $this->WarehouseStart = $warehouseStart;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoTrackActivityWs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
