<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DtoRouteWs StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DtoRouteWs
 * @subpackage Structs
 */
class DtoRouteWs extends AbstractStructBase
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The Billing
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Billing;
    /**
     * The CalculateGasoil
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CalculateGasoil;
    /**
     * The CarrierName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CarrierName;
    /**
     * The Chain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Chain;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The GasoilAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $GasoilAmount;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Observation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observation;
    /**
     * The Rotation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Rotation;
    /**
     * The RouteActivities
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDtoRouteActivityWs
     */
    public $RouteActivities;
    /**
     * The RouteDestination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RouteDestination;
    /**
     * The RouteOrigin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RouteOrigin;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ServiceType;
    /**
     * The TrailerType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TrailerType;
    /**
     * The Transit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Transit;
    /**
     * Constructor method for DtoRouteWs
     * @uses DtoRouteWs::setActive()
     * @uses DtoRouteWs::setAmount()
     * @uses DtoRouteWs::setBilling()
     * @uses DtoRouteWs::setCalculateGasoil()
     * @uses DtoRouteWs::setCarrierName()
     * @uses DtoRouteWs::setChain()
     * @uses DtoRouteWs::setDescription()
     * @uses DtoRouteWs::setGasoilAmount()
     * @uses DtoRouteWs::setId()
     * @uses DtoRouteWs::setName()
     * @uses DtoRouteWs::setObservation()
     * @uses DtoRouteWs::setRotation()
     * @uses DtoRouteWs::setRouteActivities()
     * @uses DtoRouteWs::setRouteDestination()
     * @uses DtoRouteWs::setRouteOrigin()
     * @uses DtoRouteWs::setServiceType()
     * @uses DtoRouteWs::setTrailerType()
     * @uses DtoRouteWs::setTransit()
     * @param bool $active
     * @param float $amount
     * @param string $billing
     * @param bool $calculateGasoil
     * @param string $carrierName
     * @param string $chain
     * @param string $description
     * @param float $gasoilAmount
     * @param int $id
     * @param string $name
     * @param string $observation
     * @param int $rotation
     * @param \ArrayType\ArrayOfDtoRouteActivityWs $routeActivities
     * @param string $routeDestination
     * @param string $routeOrigin
     * @param string $serviceType
     * @param string $trailerType
     * @param float $transit
     */
    public function __construct($active = null, $amount = null, $billing = null, $calculateGasoil = null, $carrierName = null, $chain = null, $description = null, $gasoilAmount = null, $id = null, $name = null, $observation = null, $rotation = null, \ArrayType\ArrayOfDtoRouteActivityWs $routeActivities = null, $routeDestination = null, $routeOrigin = null, $serviceType = null, $trailerType = null, $transit = null)
    {
        $this
            ->setActive($active)
            ->setAmount($amount)
            ->setBilling($billing)
            ->setCalculateGasoil($calculateGasoil)
            ->setCarrierName($carrierName)
            ->setChain($chain)
            ->setDescription($description)
            ->setGasoilAmount($gasoilAmount)
            ->setId($id)
            ->setName($name)
            ->setObservation($observation)
            ->setRotation($rotation)
            ->setRouteActivities($routeActivities)
            ->setRouteDestination($routeDestination)
            ->setRouteOrigin($routeOrigin)
            ->setServiceType($serviceType)
            ->setTrailerType($trailerType)
            ->setTransit($transit);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\DtoRouteWs
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\DtoRouteWs
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Billing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBilling()
    {
        return isset($this->Billing) ? $this->Billing : null;
    }
    /**
     * Set Billing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billing
     * @return \StructType\DtoRouteWs
     */
    public function setBilling($billing = null)
    {
        // validation for constraint: string
        if (!is_null($billing) && !is_string($billing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billing)), __LINE__);
        }
        if (is_null($billing) || (is_array($billing) && empty($billing))) {
            unset($this->Billing);
        } else {
            $this->Billing = $billing;
        }
        return $this;
    }
    /**
     * Get CalculateGasoil value
     * @return bool|null
     */
    public function getCalculateGasoil()
    {
        return $this->CalculateGasoil;
    }
    /**
     * Set CalculateGasoil value
     * @param bool $calculateGasoil
     * @return \StructType\DtoRouteWs
     */
    public function setCalculateGasoil($calculateGasoil = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculateGasoil) && !is_bool($calculateGasoil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($calculateGasoil)), __LINE__);
        }
        $this->CalculateGasoil = $calculateGasoil;
        return $this;
    }
    /**
     * Get CarrierName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarrierName()
    {
        return isset($this->CarrierName) ? $this->CarrierName : null;
    }
    /**
     * Set CarrierName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carrierName
     * @return \StructType\DtoRouteWs
     */
    public function setCarrierName($carrierName = null)
    {
        // validation for constraint: string
        if (!is_null($carrierName) && !is_string($carrierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrierName)), __LINE__);
        }
        if (is_null($carrierName) || (is_array($carrierName) && empty($carrierName))) {
            unset($this->CarrierName);
        } else {
            $this->CarrierName = $carrierName;
        }
        return $this;
    }
    /**
     * Get Chain value
     * @return string|null
     */
    public function getChain()
    {
        return $this->Chain;
    }
    /**
     * Set Chain value
     * @uses \EnumType\ChainEnum::valueIsValid()
     * @uses \EnumType\ChainEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chain
     * @return \StructType\DtoRouteWs
     */
    public function setChain($chain = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ChainEnum::valueIsValid($chain)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $chain, implode(', ', \EnumType\ChainEnum::getValidValues())), __LINE__);
        }
        $this->Chain = $chain;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\DtoRouteWs
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get GasoilAmount value
     * @return float|null
     */
    public function getGasoilAmount()
    {
        return $this->GasoilAmount;
    }
    /**
     * Set GasoilAmount value
     * @param float $gasoilAmount
     * @return \StructType\DtoRouteWs
     */
    public function setGasoilAmount($gasoilAmount = null)
    {
        $this->GasoilAmount = $gasoilAmount;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\DtoRouteWs
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\DtoRouteWs
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Observation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservation()
    {
        return isset($this->Observation) ? $this->Observation : null;
    }
    /**
     * Set Observation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observation
     * @return \StructType\DtoRouteWs
     */
    public function setObservation($observation = null)
    {
        // validation for constraint: string
        if (!is_null($observation) && !is_string($observation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($observation)), __LINE__);
        }
        if (is_null($observation) || (is_array($observation) && empty($observation))) {
            unset($this->Observation);
        } else {
            $this->Observation = $observation;
        }
        return $this;
    }
    /**
     * Get Rotation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRotation()
    {
        return isset($this->Rotation) ? $this->Rotation : null;
    }
    /**
     * Set Rotation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rotation
     * @return \StructType\DtoRouteWs
     */
    public function setRotation($rotation = null)
    {
        // validation for constraint: int
        if (!is_null($rotation) && !is_numeric($rotation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rotation)), __LINE__);
        }
        if (is_null($rotation) || (is_array($rotation) && empty($rotation))) {
            unset($this->Rotation);
        } else {
            $this->Rotation = $rotation;
        }
        return $this;
    }
    /**
     * Get RouteActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDtoRouteActivityWs|null
     */
    public function getRouteActivities()
    {
        return isset($this->RouteActivities) ? $this->RouteActivities : null;
    }
    /**
     * Set RouteActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDtoRouteActivityWs $routeActivities
     * @return \StructType\DtoRouteWs
     */
    public function setRouteActivities(\ArrayType\ArrayOfDtoRouteActivityWs $routeActivities = null)
    {
        if (is_null($routeActivities) || (is_array($routeActivities) && empty($routeActivities))) {
            unset($this->RouteActivities);
        } else {
            $this->RouteActivities = $routeActivities;
        }
        return $this;
    }
    /**
     * Get RouteDestination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRouteDestination()
    {
        return isset($this->RouteDestination) ? $this->RouteDestination : null;
    }
    /**
     * Set RouteDestination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routeDestination
     * @return \StructType\DtoRouteWs
     */
    public function setRouteDestination($routeDestination = null)
    {
        // validation for constraint: string
        if (!is_null($routeDestination) && !is_string($routeDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeDestination)), __LINE__);
        }
        if (is_null($routeDestination) || (is_array($routeDestination) && empty($routeDestination))) {
            unset($this->RouteDestination);
        } else {
            $this->RouteDestination = $routeDestination;
        }
        return $this;
    }
    /**
     * Get RouteOrigin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRouteOrigin()
    {
        return isset($this->RouteOrigin) ? $this->RouteOrigin : null;
    }
    /**
     * Set RouteOrigin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routeOrigin
     * @return \StructType\DtoRouteWs
     */
    public function setRouteOrigin($routeOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($routeOrigin) && !is_string($routeOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeOrigin)), __LINE__);
        }
        if (is_null($routeOrigin) || (is_array($routeOrigin) && empty($routeOrigin))) {
            unset($this->RouteOrigin);
        } else {
            $this->RouteOrigin = $routeOrigin;
        }
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\DtoRouteWs
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get TrailerType value
     * @return string|null
     */
    public function getTrailerType()
    {
        return $this->TrailerType;
    }
    /**
     * Set TrailerType value
     * @uses \EnumType\TrailerTypeEnum::valueIsValid()
     * @uses \EnumType\TrailerTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trailerType
     * @return \StructType\DtoRouteWs
     */
    public function setTrailerType($trailerType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TrailerTypeEnum::valueIsValid($trailerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trailerType, implode(', ', \EnumType\TrailerTypeEnum::getValidValues())), __LINE__);
        }
        $this->TrailerType = $trailerType;
        return $this;
    }
    /**
     * Get Transit value
     * @return float|null
     */
    public function getTransit()
    {
        return $this->Transit;
    }
    /**
     * Set Transit value
     * @param float $transit
     * @return \StructType\DtoRouteWs
     */
    public function setTransit($transit = null)
    {
        $this->Transit = $transit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoRouteWs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
