<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for List ServiceType
 * @subpackage Services
 */
class _List extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListDriver
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListDriver $parameters
     * @return \StructType\ListDriverResponse|bool
     */
    public function ListDriver(\StructType\ListDriver $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListDriver($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListTrackTransport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListTrackTransport $parameters
     * @return \StructType\ListTrackTransportResponse|bool
     */
    public function ListTrackTransport(\StructType\ListTrackTransport $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListTrackTransport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListRoute
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListRoute $parameters
     * @return \StructType\ListRouteResponse|bool
     */
    public function ListRoute(\StructType\ListRoute $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListRoute($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListWarehouse
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListWarehouse $parameters
     * @return \StructType\ListWarehouseResponse|bool
     */
    public function ListWarehouse(\StructType\ListWarehouse $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListWarehouse($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListDriverResponse|\StructType\ListRouteResponse|\StructType\ListTrackTransportResponse|\StructType\ListWarehouseResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
