<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Notify ServiceType
 * @subpackage Services
 */
class Notify extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named NotifyPositions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NotifyPositions $parameters
     * @return \StructType\NotifyPositionsResponse|bool
     */
    public function NotifyPositions(\StructType\NotifyPositions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NotifyPositions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named NotifyPositionsByExternalId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\NotifyPositionsByExternalId $parameters
     * @return \StructType\NotifyPositionsByExternalIdResponse|bool
     */
    public function NotifyPositionsByExternalId(\StructType\NotifyPositionsByExternalId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->NotifyPositionsByExternalId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\NotifyPositionsByExternalIdResponse|\StructType\NotifyPositionsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
