<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Desactive ServiceType
 * @subpackage Services
 */
class Desactive extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DesactivePlate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesactivePlate $parameters
     * @return \StructType\DesactivePlateResponse|bool
     */
    public function DesactivePlate(\StructType\DesactivePlate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DesactivePlate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DesactivePlateByExternalId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DesactivePlateByExternalId $parameters
     * @return \StructType\DesactivePlateByExternalIdResponse|bool
     */
    public function DesactivePlateByExternalId(\StructType\DesactivePlateByExternalId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DesactivePlateByExternalId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DesactivePlateByExternalIdResponse|\StructType\DesactivePlateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
