<?php

namespace EnumType;

/**
 * This class stands for TrackTransportStatusEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TrackTransportStatusEnum
 * @subpackage Enumerations
 */
class TrackTransportStatusEnum
{
    /**
     * Constant for value 'Open'
     * @return string 'Open'
     */
    const VALUE_OPEN = 'Open';
    /**
     * Constant for value 'InProcess'
     * @return string 'InProcess'
     */
    const VALUE_IN_PROCESS = 'InProcess';
    /**
     * Constant for value 'Close'
     * @return string 'Close'
     */
    const VALUE_CLOSE = 'Close';
    /**
     * Constant for value 'Cancelled'
     * @return string 'Cancelled'
     */
    const VALUE_CANCELLED = 'Cancelled';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OPEN
     * @uses self::VALUE_IN_PROCESS
     * @uses self::VALUE_CLOSE
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_PENDING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OPEN,
            self::VALUE_IN_PROCESS,
            self::VALUE_CLOSE,
            self::VALUE_CANCELLED,
            self::VALUE_PENDING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
