<?php

namespace EnumType;

/**
 * This class stands for PlateTypeEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PlateTypeEnum
 * @subpackage Enumerations
 */
class PlateTypeEnum
{
    /**
     * Constant for value 'Truck'
     * @return string 'Truck'
     */
    const VALUE_TRUCK = 'Truck';
    /**
     * Constant for value 'Trailer'
     * @return string 'Trailer'
     */
    const VALUE_TRAILER = 'Trailer';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRUCK
     * @uses self::VALUE_TRAILER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRUCK,
            self::VALUE_TRAILER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
