<?php

namespace EnumType;

/**
 * This class stands for FileTypeEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FileTypeEnum
 * @subpackage Enumerations
 */
class FileTypeEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Folder'
     * @return string 'Folder'
     */
    const VALUE_FOLDER = 'Folder';
    /**
     * Constant for value 'Notification'
     * @return string 'Notification'
     */
    const VALUE_NOTIFICATION = 'Notification';
    /**
     * Constant for value 'Incidence'
     * @return string 'Incidence'
     */
    const VALUE_INCIDENCE = 'Incidence';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_FOLDER
     * @uses self::VALUE_NOTIFICATION
     * @uses self::VALUE_INCIDENCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_FOLDER,
            self::VALUE_NOTIFICATION,
            self::VALUE_INCIDENCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
