<?php

namespace EnumType;

/**
 * This class stands for ActivityTypeEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ActivityTypeEnum
 * @subpackage Enumerations
 */
class ActivityTypeEnum
{
    /**
     * Constant for value 'Load'
     * @return string 'Load'
     */
    const VALUE_LOAD = 'Load';
    /**
     * Constant for value 'Unload'
     * @return string 'Unload'
     */
    const VALUE_UNLOAD = 'Unload';
    /**
     * Constant for value 'LoadUnload'
     * @return string 'LoadUnload'
     */
    const VALUE_LOAD_UNLOAD = 'LoadUnload';
    /**
     * Constant for value 'ControlPoint'
     * @return string 'ControlPoint'
     */
    const VALUE_CONTROL_POINT = 'ControlPoint';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LOAD
     * @uses self::VALUE_UNLOAD
     * @uses self::VALUE_LOAD_UNLOAD
     * @uses self::VALUE_CONTROL_POINT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LOAD,
            self::VALUE_UNLOAD,
            self::VALUE_LOAD_UNLOAD,
            self::VALUE_CONTROL_POINT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
