<?php

namespace EnumType;

/**
 * This class stands for ActivityContentTypeEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ActivityContentTypeEnum
 * @subpackage Enumerations
 */
class ActivityContentTypeEnum
{
    /**
     * Constant for value 'Load'
     * @return string 'Load'
     */
    const VALUE_LOAD = 'Load';
    /**
     * Constant for value 'Unload'
     * @return string 'Unload'
     */
    const VALUE_UNLOAD = 'Unload';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LOAD
     * @uses self::VALUE_UNLOAD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LOAD,
            self::VALUE_UNLOAD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
