<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.ictower.net/Services/MasterService.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.ictower.net/Services/MasterService.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetAllPlates operation/method
 */
if ($get->GetAllPlates(new \StructType\GetAllPlates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for New ServiceType
 */
$new = new \ServiceType\_New($options);
/**
 * Sample call for NewPlate operation/method
 */
if ($new->NewPlate(new \StructType\NewPlate()) !== false) {
    print_r($new->getResult());
} else {
    print_r($new->getLastError());
}
/**
 * Sample call for NewDriver operation/method
 */
if ($new->NewDriver(new \StructType\NewDriver()) !== false) {
    print_r($new->getResult());
} else {
    print_r($new->getLastError());
}
/**
 * Samples for Desactive ServiceType
 */
$desactive = new \ServiceType\Desactive($options);
/**
 * Sample call for DesactivePlate operation/method
 */
if ($desactive->DesactivePlate(new \StructType\DesactivePlate()) !== false) {
    print_r($desactive->getResult());
} else {
    print_r($desactive->getLastError());
}
/**
 * Sample call for DesactivePlateByExternalId operation/method
 */
if ($desactive->DesactivePlateByExternalId(new \StructType\DesactivePlateByExternalId()) !== false) {
    print_r($desactive->getResult());
} else {
    print_r($desactive->getLastError());
}
/**
 * Samples for Active ServiceType
 */
$active = new \ServiceType\Active($options);
/**
 * Sample call for ActivePlate operation/method
 */
if ($active->ActivePlate(new \StructType\ActivePlate()) !== false) {
    print_r($active->getResult());
} else {
    print_r($active->getLastError());
}
/**
 * Sample call for ActivePlateByExternalId operation/method
 */
if ($active->ActivePlateByExternalId(new \StructType\ActivePlateByExternalId()) !== false) {
    print_r($active->getResult());
} else {
    print_r($active->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
/**
 * Sample call for ListDriver operation/method
 */
if ($list->ListDriver(new \StructType\ListDriver()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListTrackTransport operation/method
 */
if ($list->ListTrackTransport(new \StructType\ListTrackTransport()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListRoute operation/method
 */
if ($list->ListRoute(new \StructType\ListRoute()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for ListWarehouse operation/method
 */
if ($list->ListWarehouse(new \StructType\ListWarehouse()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Notify ServiceType
 */
$notify = new \ServiceType\Notify($options);
/**
 * Sample call for NotifyPositions operation/method
 */
if ($notify->NotifyPositions(new \StructType\NotifyPositions()) !== false) {
    print_r($notify->getResult());
} else {
    print_r($notify->getLastError());
}
/**
 * Sample call for NotifyPositionsByExternalId operation/method
 */
if ($notify->NotifyPositionsByExternalId(new \StructType\NotifyPositionsByExternalId()) !== false) {
    print_r($notify->getResult());
} else {
    print_r($notify->getLastError());
}
