<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DtoRouteActivityWs StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DtoRouteActivityWs
 * @subpackage Structs
 */
class DtoRouteActivityWs extends AbstractStructBase
{
    /**
     * The Day
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Day;
    /**
     * The DepartDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartDay;
    /**
     * The DepartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DepartTime;
    /**
     * The Dock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Dock;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Kms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Kms;
    /**
     * The Order
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Order;
    /**
     * The RouteId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RouteId;
    /**
     * The RouteName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RouteName;
    /**
     * The Time
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Time;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The WarehouseName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarehouseName;
    /**
     * Constructor method for DtoRouteActivityWs
     * @uses DtoRouteActivityWs::setDay()
     * @uses DtoRouteActivityWs::setDepartDay()
     * @uses DtoRouteActivityWs::setDepartTime()
     * @uses DtoRouteActivityWs::setDock()
     * @uses DtoRouteActivityWs::setId()
     * @uses DtoRouteActivityWs::setKms()
     * @uses DtoRouteActivityWs::setOrder()
     * @uses DtoRouteActivityWs::setRouteId()
     * @uses DtoRouteActivityWs::setRouteName()
     * @uses DtoRouteActivityWs::setTime()
     * @uses DtoRouteActivityWs::setType()
     * @uses DtoRouteActivityWs::setWarehouseName()
     * @param string $day
     * @param string $departDay
     * @param string $departTime
     * @param string $dock
     * @param int $id
     * @param int $kms
     * @param int $order
     * @param int $routeId
     * @param string $routeName
     * @param string $time
     * @param string $type
     * @param string $warehouseName
     */
    public function __construct($day = null, $departDay = null, $departTime = null, $dock = null, $id = null, $kms = null, $order = null, $routeId = null, $routeName = null, $time = null, $type = null, $warehouseName = null)
    {
        $this
            ->setDay($day)
            ->setDepartDay($departDay)
            ->setDepartTime($departTime)
            ->setDock($dock)
            ->setId($id)
            ->setKms($kms)
            ->setOrder($order)
            ->setRouteId($routeId)
            ->setRouteName($routeName)
            ->setTime($time)
            ->setType($type)
            ->setWarehouseName($warehouseName);
    }
    /**
     * Get Day value
     * @return string|null
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @uses \EnumType\DayOfWeek::valueIsValid()
     * @uses \EnumType\DayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $day
     * @return \StructType\DtoRouteActivityWs
     */
    public function setDay($day = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfWeek::valueIsValid($day)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $day, implode(', ', \EnumType\DayOfWeek::getValidValues())), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Get DepartDay value
     * @return string|null
     */
    public function getDepartDay()
    {
        return $this->DepartDay;
    }
    /**
     * Set DepartDay value
     * @uses \EnumType\DayOfWeek::valueIsValid()
     * @uses \EnumType\DayOfWeek::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $departDay
     * @return \StructType\DtoRouteActivityWs
     */
    public function setDepartDay($departDay = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DayOfWeek::valueIsValid($departDay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $departDay, implode(', ', \EnumType\DayOfWeek::getValidValues())), __LINE__);
        }
        $this->DepartDay = $departDay;
        return $this;
    }
    /**
     * Get DepartTime value
     * @return string|null
     */
    public function getDepartTime()
    {
        return $this->DepartTime;
    }
    /**
     * Set DepartTime value
     * @param string $departTime
     * @return \StructType\DtoRouteActivityWs
     */
    public function setDepartTime($departTime = null)
    {
        // validation for constraint: string
        if (!is_null($departTime) && !is_string($departTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departTime)), __LINE__);
        }
        $this->DepartTime = $departTime;
        return $this;
    }
    /**
     * Get Dock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDock()
    {
        return isset($this->Dock) ? $this->Dock : null;
    }
    /**
     * Set Dock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dock
     * @return \StructType\DtoRouteActivityWs
     */
    public function setDock($dock = null)
    {
        // validation for constraint: string
        if (!is_null($dock) && !is_string($dock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dock)), __LINE__);
        }
        if (is_null($dock) || (is_array($dock) && empty($dock))) {
            unset($this->Dock);
        } else {
            $this->Dock = $dock;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\DtoRouteActivityWs
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Kms value
     * @return int|null
     */
    public function getKms()
    {
        return $this->Kms;
    }
    /**
     * Set Kms value
     * @param int $kms
     * @return \StructType\DtoRouteActivityWs
     */
    public function setKms($kms = null)
    {
        // validation for constraint: int
        if (!is_null($kms) && !is_numeric($kms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($kms)), __LINE__);
        }
        $this->Kms = $kms;
        return $this;
    }
    /**
     * Get Order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param int $order
     * @return \StructType\DtoRouteActivityWs
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !is_numeric($order)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order)), __LINE__);
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Get RouteId value
     * @return int|null
     */
    public function getRouteId()
    {
        return $this->RouteId;
    }
    /**
     * Set RouteId value
     * @param int $routeId
     * @return \StructType\DtoRouteActivityWs
     */
    public function setRouteId($routeId = null)
    {
        // validation for constraint: int
        if (!is_null($routeId) && !is_numeric($routeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($routeId)), __LINE__);
        }
        $this->RouteId = $routeId;
        return $this;
    }
    /**
     * Get RouteName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRouteName()
    {
        return isset($this->RouteName) ? $this->RouteName : null;
    }
    /**
     * Set RouteName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routeName
     * @return \StructType\DtoRouteActivityWs
     */
    public function setRouteName($routeName = null)
    {
        // validation for constraint: string
        if (!is_null($routeName) && !is_string($routeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeName)), __LINE__);
        }
        if (is_null($routeName) || (is_array($routeName) && empty($routeName))) {
            unset($this->RouteName);
        } else {
            $this->RouteName = $routeName;
        }
        return $this;
    }
    /**
     * Get Time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->Time;
    }
    /**
     * Set Time value
     * @param string $time
     * @return \StructType\DtoRouteActivityWs
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time)), __LINE__);
        }
        $this->Time = $time;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ActivityTypeEnum::valueIsValid()
     * @uses \EnumType\ActivityTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\DtoRouteActivityWs
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActivityTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ActivityTypeEnum::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get WarehouseName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarehouseName()
    {
        return isset($this->WarehouseName) ? $this->WarehouseName : null;
    }
    /**
     * Set WarehouseName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warehouseName
     * @return \StructType\DtoRouteActivityWs
     */
    public function setWarehouseName($warehouseName = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseName) && !is_string($warehouseName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warehouseName)), __LINE__);
        }
        if (is_null($warehouseName) || (is_array($warehouseName) && empty($warehouseName))) {
            unset($this->WarehouseName);
        } else {
            $this->WarehouseName = $warehouseName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoRouteActivityWs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
