<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DtoLocationWs StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DtoLocationWs
 * @subpackage Structs
 */
class DtoLocationWs extends AbstractStructBase
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The RoutePointControl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DtoRoutePointControlWs
     */
    public $RoutePointControl;
    /**
     * The RoutePointControlName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoutePointControlName;
    /**
     * The RoutePointControlTimeZoneCountryCountryName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoutePointControlTimeZoneCountryCountryName;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for DtoLocationWs
     * @uses DtoLocationWs::setActive()
     * @uses DtoLocationWs::setAddress()
     * @uses DtoLocationWs::setCode()
     * @uses DtoLocationWs::setDescription()
     * @uses DtoLocationWs::setEmail()
     * @uses DtoLocationWs::setId()
     * @uses DtoLocationWs::setName()
     * @uses DtoLocationWs::setPhone()
     * @uses DtoLocationWs::setRoutePointControl()
     * @uses DtoLocationWs::setRoutePointControlName()
     * @uses DtoLocationWs::setRoutePointControlTimeZoneCountryCountryName()
     * @uses DtoLocationWs::setType()
     * @param bool $active
     * @param string $address
     * @param string $code
     * @param string $description
     * @param string $email
     * @param int $id
     * @param string $name
     * @param string $phone
     * @param \StructType\DtoRoutePointControlWs $routePointControl
     * @param string $routePointControlName
     * @param string $routePointControlTimeZoneCountryCountryName
     * @param string $type
     */
    public function __construct($active = null, $address = null, $code = null, $description = null, $email = null, $id = null, $name = null, $phone = null, \StructType\DtoRoutePointControlWs $routePointControl = null, $routePointControlName = null, $routePointControlTimeZoneCountryCountryName = null, $type = null)
    {
        $this
            ->setActive($active)
            ->setAddress($address)
            ->setCode($code)
            ->setDescription($description)
            ->setEmail($email)
            ->setId($id)
            ->setName($name)
            ->setPhone($phone)
            ->setRoutePointControl($routePointControl)
            ->setRoutePointControlName($routePointControlName)
            ->setRoutePointControlTimeZoneCountryCountryName($routePointControlTimeZoneCountryCountryName)
            ->setType($type);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\DtoLocationWs
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address
     * @return \StructType\DtoLocationWs
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\DtoLocationWs
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\DtoLocationWs
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\DtoLocationWs
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\DtoLocationWs
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\DtoLocationWs
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \StructType\DtoLocationWs
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get RoutePointControl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DtoRoutePointControlWs|null
     */
    public function getRoutePointControl()
    {
        return isset($this->RoutePointControl) ? $this->RoutePointControl : null;
    }
    /**
     * Set RoutePointControl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DtoRoutePointControlWs $routePointControl
     * @return \StructType\DtoLocationWs
     */
    public function setRoutePointControl(\StructType\DtoRoutePointControlWs $routePointControl = null)
    {
        if (is_null($routePointControl) || (is_array($routePointControl) && empty($routePointControl))) {
            unset($this->RoutePointControl);
        } else {
            $this->RoutePointControl = $routePointControl;
        }
        return $this;
    }
    /**
     * Get RoutePointControlName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutePointControlName()
    {
        return isset($this->RoutePointControlName) ? $this->RoutePointControlName : null;
    }
    /**
     * Set RoutePointControlName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routePointControlName
     * @return \StructType\DtoLocationWs
     */
    public function setRoutePointControlName($routePointControlName = null)
    {
        // validation for constraint: string
        if (!is_null($routePointControlName) && !is_string($routePointControlName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routePointControlName)), __LINE__);
        }
        if (is_null($routePointControlName) || (is_array($routePointControlName) && empty($routePointControlName))) {
            unset($this->RoutePointControlName);
        } else {
            $this->RoutePointControlName = $routePointControlName;
        }
        return $this;
    }
    /**
     * Get RoutePointControlTimeZoneCountryCountryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoutePointControlTimeZoneCountryCountryName()
    {
        return isset($this->RoutePointControlTimeZoneCountryCountryName) ? $this->RoutePointControlTimeZoneCountryCountryName : null;
    }
    /**
     * Set RoutePointControlTimeZoneCountryCountryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $routePointControlTimeZoneCountryCountryName
     * @return \StructType\DtoLocationWs
     */
    public function setRoutePointControlTimeZoneCountryCountryName($routePointControlTimeZoneCountryCountryName = null)
    {
        // validation for constraint: string
        if (!is_null($routePointControlTimeZoneCountryCountryName) && !is_string($routePointControlTimeZoneCountryCountryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routePointControlTimeZoneCountryCountryName)), __LINE__);
        }
        if (is_null($routePointControlTimeZoneCountryCountryName) || (is_array($routePointControlTimeZoneCountryCountryName) && empty($routePointControlTimeZoneCountryCountryName))) {
            unset($this->RoutePointControlTimeZoneCountryCountryName);
        } else {
            $this->RoutePointControlTimeZoneCountryCountryName = $routePointControlTimeZoneCountryCountryName;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\LocationTypeEnum::valueIsValid()
     * @uses \EnumType\LocationTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\DtoLocationWs
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LocationTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\LocationTypeEnum::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DtoLocationWs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
