<?php

namespace EnumType;

/**
 * This class stands for LocationTypeEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LocationTypeEnum
 * @subpackage Enumerations
 */
class LocationTypeEnum
{
    /**
     * Constant for value 'Loader'
     * @return string 'Loader'
     */
    const VALUE_LOADER = 'Loader';
    /**
     * Constant for value 'DistributionCenter'
     * @return string 'DistributionCenter'
     */
    const VALUE_DISTRIBUTION_CENTER = 'DistributionCenter';
    /**
     * Constant for value 'DistributionPlatform'
     * @return string 'DistributionPlatform'
     */
    const VALUE_DISTRIBUTION_PLATFORM = 'DistributionPlatform';
    /**
     * Constant for value 'ConsolidationCentre'
     * @return string 'ConsolidationCentre'
     */
    const VALUE_CONSOLIDATION_CENTRE = 'ConsolidationCentre';
    /**
     * Constant for value 'Carrier'
     * @return string 'Carrier'
     */
    const VALUE_CARRIER = 'Carrier';
    /**
     * Constant for value 'ControlPoint'
     * @return string 'ControlPoint'
     */
    const VALUE_CONTROL_POINT = 'ControlPoint';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LOADER
     * @uses self::VALUE_DISTRIBUTION_CENTER
     * @uses self::VALUE_DISTRIBUTION_PLATFORM
     * @uses self::VALUE_CONSOLIDATION_CENTRE
     * @uses self::VALUE_CARRIER
     * @uses self::VALUE_CONTROL_POINT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LOADER,
            self::VALUE_DISTRIBUTION_CENTER,
            self::VALUE_DISTRIBUTION_PLATFORM,
            self::VALUE_CONSOLIDATION_CENTRE,
            self::VALUE_CARRIER,
            self::VALUE_CONTROL_POINT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
