<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPositionTrace ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPositionTrace
 * @subpackage Arrays
 */
class ArrayOfPositionTrace extends AbstractStructArrayBase
{
    /**
     * The PositionTrace
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PositionTrace[]
     */
    public $PositionTrace;
    /**
     * Constructor method for ArrayOfPositionTrace
     * @uses ArrayOfPositionTrace::setPositionTrace()
     * @param \StructType\PositionTrace[] $positionTrace
     */
    public function __construct(array $positionTrace = array())
    {
        $this
            ->setPositionTrace($positionTrace);
    }
    /**
     * Get PositionTrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PositionTrace[]|null
     */
    public function getPositionTrace()
    {
        return isset($this->PositionTrace) ? $this->PositionTrace : null;
    }
    /**
     * Set PositionTrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PositionTrace[] $positionTrace
     * @return \ArrayType\ArrayOfPositionTrace
     */
    public function setPositionTrace(array $positionTrace = array())
    {
        foreach ($positionTrace as $arrayOfPositionTracePositionTraceItem) {
            // validation for constraint: itemType
            if (!$arrayOfPositionTracePositionTraceItem instanceof \StructType\PositionTrace) {
                throw new \InvalidArgumentException(sprintf('The PositionTrace property can only contain items of \StructType\PositionTrace, "%s" given', is_object($arrayOfPositionTracePositionTraceItem) ? get_class($arrayOfPositionTracePositionTraceItem) : gettype($arrayOfPositionTracePositionTraceItem)), __LINE__);
            }
        }
        if (is_null($positionTrace) || (is_array($positionTrace) && empty($positionTrace))) {
            unset($this->PositionTrace);
        } else {
            $this->PositionTrace = $positionTrace;
        }
        return $this;
    }
    /**
     * Add item to PositionTrace value
     * @throws \InvalidArgumentException
     * @param \StructType\PositionTrace $item
     * @return \ArrayType\ArrayOfPositionTrace
     */
    public function addToPositionTrace(\StructType\PositionTrace $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PositionTrace) {
            throw new \InvalidArgumentException(sprintf('The PositionTrace property can only contain items of \StructType\PositionTrace, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PositionTrace[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PositionTrace|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PositionTrace|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PositionTrace|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PositionTrace|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PositionTrace|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PositionTrace
     */
    public function getAttributeName()
    {
        return 'PositionTrace';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPositionTrace
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
