<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \CUCM\ClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \CUCM\ServiceType\Add($options);
/**
 * Sample call for addSipProfile operation/method
 */
if ($add->addSipProfile(new \CUCM\StructType\AddSipProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addSipTrunkSecurityProfile operation/method
 */
if ($add->addSipTrunkSecurityProfile(new \CUCM\StructType\AddSipTrunkSecurityProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addTimePeriod operation/method
 */
if ($add->addTimePeriod(new \CUCM\StructType\AddTimePeriodReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addTimeSchedule operation/method
 */
if ($add->addTimeSchedule(new \CUCM\StructType\AddTimeScheduleReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addTodAccess operation/method
 */
if ($add->addTodAccess(new \CUCM\StructType\AddTodAccessReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addVoiceMailPilot operation/method
 */
if ($add->addVoiceMailPilot(new \CUCM\StructType\AddVoiceMailPilotReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addProcessNode operation/method
 */
if ($add->addProcessNode(new \CUCM\StructType\AddProcessNodeReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCallerFilterList operation/method
 */
if ($add->addCallerFilterList(new \CUCM\StructType\AddCallerFilterListReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addRoutePartition operation/method
 */
if ($add->addRoutePartition(new \CUCM\StructType\AddRoutePartitionReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCss operation/method
 */
if ($add->addCss(new \CUCM\StructType\AddCssReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMediaResourceGroup operation/method
 */
if ($add->addMediaResourceGroup(new \CUCM\StructType\AddMediaResourceGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMediaResourceList operation/method
 */
if ($add->addMediaResourceList(new \CUCM\StructType\AddMediaResourceListReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addRegion operation/method
 */
if ($add->addRegion(new \CUCM\StructType\AddRegionReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addAarGroup operation/method
 */
if ($add->addAarGroup(new \CUCM\StructType\AddAarGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addPhysicalLocation operation/method
 */
if ($add->addPhysicalLocation(new \CUCM\StructType\AddPhysicalLocationReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addRouteGroup operation/method
 */
if ($add->addRouteGroup(new \CUCM\StructType\AddRouteGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addDevicePool operation/method
 */
if ($add->addDevicePool(new \CUCM\StructType\AddDevicePoolReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addDeviceMobilityGroup operation/method
 */
if ($add->addDeviceMobilityGroup(new \CUCM\StructType\AddDeviceMobilityGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addLocation operation/method
 */
if ($add->addLocation(new \CUCM\StructType\AddLocationReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addSoftKeyTemplate operation/method
 */
if ($add->addSoftKeyTemplate(new \CUCM\StructType\AddSoftKeyTemplateReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addTranscoder operation/method
 */
if ($add->addTranscoder(new \CUCM\StructType\AddTranscoderReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCommonDeviceConfig operation/method
 */
if ($add->addCommonDeviceConfig(new \CUCM\StructType\AddCommonDeviceConfigReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addResourcePriorityNamespace operation/method
 */
if ($add->addResourcePriorityNamespace(new \CUCM\StructType\AddResourcePriorityNamespaceReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addResourcePriorityNamespaceList operation/method
 */
if ($add->addResourcePriorityNamespaceList(new \CUCM\StructType\AddResourcePriorityNamespaceListReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addDeviceMobility operation/method
 */
if ($add->addDeviceMobility(new \CUCM\StructType\AddDeviceMobilityReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCmcInfo operation/method
 */
if ($add->addCmcInfo(new \CUCM\StructType\AddCmcInfoReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCredentialPolicy operation/method
 */
if ($add->addCredentialPolicy(new \CUCM\StructType\AddCredentialPolicyReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addFacInfo operation/method
 */
if ($add->addFacInfo(new \CUCM\StructType\AddFacInfoReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addHuntList operation/method
 */
if ($add->addHuntList(new \CUCM\StructType\AddHuntListReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addIvrUserLocale operation/method
 */
if ($add->addIvrUserLocale(new \CUCM\StructType\AddIvrUserLocaleReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addLineGroup operation/method
 */
if ($add->addLineGroup(new \CUCM\StructType\AddLineGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addRecordingProfile operation/method
 */
if ($add->addRecordingProfile(new \CUCM\StructType\AddRecordingProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addRouteFilter operation/method
 */
if ($add->addRouteFilter(new \CUCM\StructType\AddRouteFilterReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCallManagerGroup operation/method
 */
if ($add->addCallManagerGroup(new \CUCM\StructType\AddCallManagerGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addUserGroup operation/method
 */
if ($add->addUserGroup(new \CUCM\StructType\AddUserGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addDhcpServer operation/method
 */
if ($add->addDhcpServer(new \CUCM\StructType\AddDhcpServerReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addDhcpSubnet operation/method
 */
if ($add->addDhcpSubnet(new \CUCM\StructType\AddDhcpSubnetReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCallPark operation/method
 */
if ($add->addCallPark(new \CUCM\StructType\AddCallParkReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addDirectedCallPark operation/method
 */
if ($add->addDirectedCallPark(new \CUCM\StructType\AddDirectedCallParkReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMeetMe operation/method
 */
if ($add->addMeetMe(new \CUCM\StructType\AddMeetMeReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMobileVoiceAccess operation/method
 */
if ($add->addMobileVoiceAccess(new \CUCM\StructType\AddMobileVoiceAccessReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addRouteList operation/method
 */
if ($add->addRouteList(new \CUCM\StructType\AddRouteListReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addUser operation/method
 */
if ($add->addUser(new \CUCM\StructType\AddUserReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addAppUser operation/method
 */
if ($add->addAppUser(new \CUCM\StructType\AddAppUserReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addSipRealm operation/method
 */
if ($add->addSipRealm(new \CUCM\StructType\AddSipRealmReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addPhoneNtp operation/method
 */
if ($add->addPhoneNtp(new \CUCM\StructType\AddPhoneNtpReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addDateTimeGroup operation/method
 */
if ($add->addDateTimeGroup(new \CUCM\StructType\AddDateTimeGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addPresenceGroup operation/method
 */
if ($add->addPresenceGroup(new \CUCM\StructType\AddPresenceGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addGeoLocation operation/method
 */
if ($add->addGeoLocation(new \CUCM\StructType\AddGeoLocationReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addSrst operation/method
 */
if ($add->addSrst(new \CUCM\StructType\AddSrstReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMlppDomain operation/method
 */
if ($add->addMlppDomain(new \CUCM\StructType\AddMlppDomainReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCumaServerSecurityProfile operation/method
 */
if ($add->addCumaServerSecurityProfile(new \CUCM\StructType\AddCumaServerSecurityProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addApplicationServer operation/method
 */
if ($add->addApplicationServer(new \CUCM\StructType\AddApplicationServerReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addApplicationUserCapfProfile operation/method
 */
if ($add->addApplicationUserCapfProfile(new \CUCM\StructType\AddApplicationUserCapfProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addEndUserCapfProfile operation/method
 */
if ($add->addEndUserCapfProfile(new \CUCM\StructType\AddEndUserCapfProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addUserPhoneAssociation operation/method
 */
if ($add->addUserPhoneAssociation(new \CUCM\StructType\AddUserPhoneAssociationReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addGeoLocationFilter operation/method
 */
if ($add->addGeoLocationFilter(new \CUCM\StructType\AddGeoLocationFilterReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addVoiceMailProfile operation/method
 */
if ($add->addVoiceMailProfile(new \CUCM\StructType\AddVoiceMailProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addVoiceMailPort operation/method
 */
if ($add->addVoiceMailPort(new \CUCM\StructType\AddVoiceMailPortReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addGatekeeper operation/method
 */
if ($add->addGatekeeper(new \CUCM\StructType\AddGatekeeperReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addPhoneButtonTemplate operation/method
 */
if ($add->addPhoneButtonTemplate(new \CUCM\StructType\AddPhoneButtonTemplateReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCommonPhoneConfig operation/method
 */
if ($add->addCommonPhoneConfig(new \CUCM\StructType\AddCommonPhoneConfigReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMessageWaiting operation/method
 */
if ($add->addMessageWaiting(new \CUCM\StructType\AddMessageWaitingReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addIpPhoneServices operation/method
 */
if ($add->addIpPhoneServices(new \CUCM\StructType\AddIpPhoneServicesReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCtiRoutePoint operation/method
 */
if ($add->addCtiRoutePoint(new \CUCM\StructType\AddCtiRoutePointReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addTransPattern operation/method
 */
if ($add->addTransPattern(new \CUCM\StructType\AddTransPatternReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCallingPartyTransformationPattern operation/method
 */
if ($add->addCallingPartyTransformationPattern(new \CUCM\StructType\AddCallingPartyTransformationPatternReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addSipRoutePattern operation/method
 */
if ($add->addSipRoutePattern(new \CUCM\StructType\AddSipRoutePatternReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addHuntPilot operation/method
 */
if ($add->addHuntPilot(new \CUCM\StructType\AddHuntPilotReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addRoutePattern operation/method
 */
if ($add->addRoutePattern(new \CUCM\StructType\AddRoutePatternReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addApplicationDialRules operation/method
 */
if ($add->addApplicationDialRules(new \CUCM\StructType\AddApplicationDialRulesReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addDirectoryLookupDialRules operation/method
 */
if ($add->addDirectoryLookupDialRules(new \CUCM\StructType\AddDirectoryLookupDialRulesReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addPhoneSecurityProfile operation/method
 */
if ($add->addPhoneSecurityProfile(new \CUCM\StructType\AddPhoneSecurityProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addSipDialRules operation/method
 */
if ($add->addSipDialRules(new \CUCM\StructType\AddSipDialRulesReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addConferenceBridge operation/method
 */
if ($add->addConferenceBridge(new \CUCM\StructType\AddConferenceBridgeReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMtp operation/method
 */
if ($add->addMtp(new \CUCM\StructType\AddMtpReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addRemoteDestinationProfile operation/method
 */
if ($add->addRemoteDestinationProfile(new \CUCM\StructType\AddRemoteDestinationProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addLine operation/method
 */
if ($add->addLine(new \CUCM\StructType\AddLineReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addDefaultDeviceProfile operation/method
 */
if ($add->addDefaultDeviceProfile(new \CUCM\StructType\AddDefaultDeviceProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addH323Phone operation/method
 */
if ($add->addH323Phone(new \CUCM\StructType\AddH323PhoneReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addH323Trunk operation/method
 */
if ($add->addH323Trunk(new \CUCM\StructType\AddH323TrunkReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addPhone operation/method
 */
if ($add->addPhone(new \CUCM\StructType\AddPhoneReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addH323Gateway operation/method
 */
if ($add->addH323Gateway(new \CUCM\StructType\AddH323GatewayReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addDeviceProfile operation/method
 */
if ($add->addDeviceProfile(new \CUCM\StructType\AddDeviceProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addRemoteDestination operation/method
 */
if ($add->addRemoteDestination(new \CUCM\StructType\AddRemoteDestinationReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addGateway operation/method
 */
if ($add->addGateway(new \CUCM\StructType\AddGatewayReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addGatewayEndpointAnalogAccess operation/method
 */
if ($add->addGatewayEndpointAnalogAccess(new \CUCM\StructType\AddGatewayEndpointAnalogAccessReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addGatewayEndpointDigitalAccessPri operation/method
 */
if ($add->addGatewayEndpointDigitalAccessPri(new \CUCM\StructType\AddGatewayEndpointDigitalAccessPriReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addGatewayEndpointDigitalAccessBri operation/method
 */
if ($add->addGatewayEndpointDigitalAccessBri(new \CUCM\StructType\AddGatewayEndpointDigitalAccessBriReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addGatewayEndpointDigitalAccessT1 operation/method
 */
if ($add->addGatewayEndpointDigitalAccessT1(new \CUCM\StructType\AddGatewayEndpointDigitalAccessT1Req()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addVg224 operation/method
 */
if ($add->addVg224(new \CUCM\StructType\AddVg224Req()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCiscoCatalyst600024PortFXSGateway operation/method
 */
if ($add->addCiscoCatalyst600024PortFXSGateway(new \CUCM\StructType\AddCiscoCatalyst600024PortFXSGatewayReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCiscoCatalyst6000E1VoIPGateway operation/method
 */
if ($add->addCiscoCatalyst6000E1VoIPGateway(new \CUCM\StructType\AddCiscoCatalyst6000E1VoIPGatewayReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCiscoCatalyst6000T1VoIPGatewayPri operation/method
 */
if ($add->addCiscoCatalyst6000T1VoIPGatewayPri(new \CUCM\StructType\AddCiscoCatalyst6000T1VoIPGatewayPriReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCiscoCatalyst6000T1VoIPGatewayT1 operation/method
 */
if ($add->addCiscoCatalyst6000T1VoIPGatewayT1(new \CUCM\StructType\AddCiscoCatalyst6000T1VoIPGatewayT1Req()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCallPickupGroup operation/method
 */
if ($add->addCallPickupGroup(new \CUCM\StructType\AddCallPickupGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addGeoLocationPolicy operation/method
 */
if ($add->addGeoLocationPolicy(new \CUCM\StructType\AddGeoLocationPolicyReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addSipTrunk operation/method
 */
if ($add->addSipTrunk(new \CUCM\StructType\AddSipTrunkReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCalledPartyTransformationPattern operation/method
 */
if ($add->addCalledPartyTransformationPattern(new \CUCM\StructType\AddCalledPartyTransformationPatternReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addExternalCallControlProfile operation/method
 */
if ($add->addExternalCallControlProfile(new \CUCM\StructType\AddExternalCallControlProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addSafSecurityProfile operation/method
 */
if ($add->addSafSecurityProfile(new \CUCM\StructType\AddSafSecurityProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addSafForwarder operation/method
 */
if ($add->addSafForwarder(new \CUCM\StructType\AddSafForwarderReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCcdHostedDN operation/method
 */
if ($add->addCcdHostedDN(new \CUCM\StructType\AddCcdHostedDNReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCcdHostedDNGroup operation/method
 */
if ($add->addCcdHostedDNGroup(new \CUCM\StructType\AddCcdHostedDNGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCcdRequestingService operation/method
 */
if ($add->addCcdRequestingService(new \CUCM\StructType\AddCcdRequestingServiceReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addRemoteCluster operation/method
 */
if ($add->addRemoteCluster(new \CUCM\StructType\AddRemoteClusterReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addCcdAdvertisingService operation/method
 */
if ($add->addCcdAdvertisingService(new \CUCM\StructType\AddCcdAdvertisingServiceReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addUnitsToGateway operation/method
 */
if ($add->addUnitsToGateway(new \CUCM\StructType\AddUnitsToGatewayReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addGatewaySubunits operation/method
 */
if ($add->addGatewaySubunits(new \CUCM\StructType\AddGatewaySubunitsReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addLdapDirectory operation/method
 */
if ($add->addLdapDirectory(new \CUCM\StructType\AddLdapDirectoryReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addSafCcdPurgeBlockLearnedRoutes operation/method
 */
if ($add->addSafCcdPurgeBlockLearnedRoutes(new \CUCM\StructType\AddSafCcdPurgeBlockLearnedRoutesReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addVpnGateway operation/method
 */
if ($add->addVpnGateway(new \CUCM\StructType\AddVpnGatewayReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addVpnGroup operation/method
 */
if ($add->addVpnGroup(new \CUCM\StructType\AddVpnGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addVpnProfile operation/method
 */
if ($add->addVpnProfile(new \CUCM\StructType\AddVpnProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addImeServer operation/method
 */
if ($add->addImeServer(new \CUCM\StructType\AddImeServerReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addImeRouteFilterGroup operation/method
 */
if ($add->addImeRouteFilterGroup(new \CUCM\StructType\AddImeRouteFilterGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addImeRouteFilterElement operation/method
 */
if ($add->addImeRouteFilterElement(new \CUCM\StructType\AddImeRouteFilterElementReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addImeClient operation/method
 */
if ($add->addImeClient(new \CUCM\StructType\AddImeClientReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addImeEnrolledPattern operation/method
 */
if ($add->addImeEnrolledPattern(new \CUCM\StructType\AddImeEnrolledPatternReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addImeEnrolledPatternGroup operation/method
 */
if ($add->addImeEnrolledPatternGroup(new \CUCM\StructType\AddImeEnrolledPatternGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addImeExclusionNumber operation/method
 */
if ($add->addImeExclusionNumber(new \CUCM\StructType\AddImeExclusionNumberReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addImeExclusionNumberGroup operation/method
 */
if ($add->addImeExclusionNumberGroup(new \CUCM\StructType\AddImeExclusionNumberGroupReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addImeFirewall operation/method
 */
if ($add->addImeFirewall(new \CUCM\StructType\AddImeFirewallReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addImeE164Transformation operation/method
 */
if ($add->addImeE164Transformation(new \CUCM\StructType\AddImeE164TransformationReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addTransformationProfile operation/method
 */
if ($add->addTransformationProfile(new \CUCM\StructType\AddTransformationProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addFallbackProfile operation/method
 */
if ($add->addFallbackProfile(new \CUCM\StructType\AddFallbackProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addLdapFilter operation/method
 */
if ($add->addLdapFilter(new \CUCM\StructType\AddLdapFilterReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addAppServerInfo operation/method
 */
if ($add->addAppServerInfo(new \CUCM\StructType\AddAppServerInfoReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addFeatureControlPolicy operation/method
 */
if ($add->addFeatureControlPolicy(new \CUCM\StructType\AddFeatureControlPolicyReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMobilityProfile operation/method
 */
if ($add->addMobilityProfile(new \CUCM\StructType\AddMobilityProfileReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addEnterpriseFeatureAccessConfiguration operation/method
 */
if ($add->addEnterpriseFeatureAccessConfiguration(new \CUCM\StructType\AddEnterpriseFeatureAccessConfigurationReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addHandoffConfiguration operation/method
 */
if ($add->addHandoffConfiguration(new \CUCM\StructType\AddHandoffConfigurationReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMobility operation/method
 */
if ($add->addMobility(new \CUCM\StructType\AddMobilityReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addApplicationToSoftkeyTemplate operation/method
 */
if ($add->addApplicationToSoftkeyTemplate(new \CUCM\StructType\AddApplicationToSoftkeyTemplateReq()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \CUCM\ServiceType\Update($options);
/**
 * Sample call for updateSipProfile operation/method
 */
if ($update->updateSipProfile(new \CUCM\StructType\UpdateSipProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateSipTrunkSecurityProfile operation/method
 */
if ($update->updateSipTrunkSecurityProfile(new \CUCM\StructType\UpdateSipTrunkSecurityProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateTimePeriod operation/method
 */
if ($update->updateTimePeriod(new \CUCM\StructType\UpdateTimePeriodReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateTimeSchedule operation/method
 */
if ($update->updateTimeSchedule(new \CUCM\StructType\UpdateTimeScheduleReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateTodAccess operation/method
 */
if ($update->updateTodAccess(new \CUCM\StructType\UpdateTodAccessReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateVoiceMailPilot operation/method
 */
if ($update->updateVoiceMailPilot(new \CUCM\StructType\UpdateVoiceMailPilotReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateProcessNode operation/method
 */
if ($update->updateProcessNode(new \CUCM\StructType\UpdateProcessNodeReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCallerFilterList operation/method
 */
if ($update->updateCallerFilterList(new \CUCM\StructType\UpdateCallerFilterListReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRoutePartition operation/method
 */
if ($update->updateRoutePartition(new \CUCM\StructType\UpdateRoutePartitionReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCss operation/method
 */
if ($update->updateCss(new \CUCM\StructType\UpdateCssReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCallManager operation/method
 */
if ($update->updateCallManager(new \CUCM\StructType\UpdateCallManagerReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMediaResourceGroup operation/method
 */
if ($update->updateMediaResourceGroup(new \CUCM\StructType\UpdateMediaResourceGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMediaResourceList operation/method
 */
if ($update->updateMediaResourceList(new \CUCM\StructType\UpdateMediaResourceListReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRegion operation/method
 */
if ($update->updateRegion(new \CUCM\StructType\UpdateRegionReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAarGroup operation/method
 */
if ($update->updateAarGroup(new \CUCM\StructType\UpdateAarGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePhysicalLocation operation/method
 */
if ($update->updatePhysicalLocation(new \CUCM\StructType\UpdatePhysicalLocationReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRouteGroup operation/method
 */
if ($update->updateRouteGroup(new \CUCM\StructType\UpdateRouteGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateDevicePool operation/method
 */
if ($update->updateDevicePool(new \CUCM\StructType\UpdateDevicePoolReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateDeviceMobilityGroup operation/method
 */
if ($update->updateDeviceMobilityGroup(new \CUCM\StructType\UpdateDeviceMobilityGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateLocation operation/method
 */
if ($update->updateLocation(new \CUCM\StructType\UpdateLocationReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateSoftKeyTemplate operation/method
 */
if ($update->updateSoftKeyTemplate(new \CUCM\StructType\UpdateSoftKeyTemplateReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateTranscoder operation/method
 */
if ($update->updateTranscoder(new \CUCM\StructType\UpdateTranscoderReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCommonDeviceConfig operation/method
 */
if ($update->updateCommonDeviceConfig(new \CUCM\StructType\UpdateCommonDeviceConfigReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateResourcePriorityNamespace operation/method
 */
if ($update->updateResourcePriorityNamespace(new \CUCM\StructType\UpdateResourcePriorityNamespaceReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateResourcePriorityNamespaceList operation/method
 */
if ($update->updateResourcePriorityNamespaceList(new \CUCM\StructType\UpdateResourcePriorityNamespaceListReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateDeviceMobility operation/method
 */
if ($update->updateDeviceMobility(new \CUCM\StructType\UpdateDeviceMobilityReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCmcInfo operation/method
 */
if ($update->updateCmcInfo(new \CUCM\StructType\UpdateCmcInfoReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCredentialPolicy operation/method
 */
if ($update->updateCredentialPolicy(new \CUCM\StructType\UpdateCredentialPolicyReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateFacInfo operation/method
 */
if ($update->updateFacInfo(new \CUCM\StructType\UpdateFacInfoReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateHuntList operation/method
 */
if ($update->updateHuntList(new \CUCM\StructType\UpdateHuntListReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateIvrUserLocale operation/method
 */
if ($update->updateIvrUserLocale(new \CUCM\StructType\UpdateIvrUserLocaleReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateLineGroup operation/method
 */
if ($update->updateLineGroup(new \CUCM\StructType\UpdateLineGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRecordingProfile operation/method
 */
if ($update->updateRecordingProfile(new \CUCM\StructType\UpdateRecordingProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRouteFilter operation/method
 */
if ($update->updateRouteFilter(new \CUCM\StructType\UpdateRouteFilterReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCallManagerGroup operation/method
 */
if ($update->updateCallManagerGroup(new \CUCM\StructType\UpdateCallManagerGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateUserGroup operation/method
 */
if ($update->updateUserGroup(new \CUCM\StructType\UpdateUserGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateProcessNodeService operation/method
 */
if ($update->updateProcessNodeService(new \CUCM\StructType\UpdateProcessNodeServiceReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMohAudioSource operation/method
 */
if ($update->updateMohAudioSource(new \CUCM\StructType\UpdateMohAudioSourceReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateDhcpServer operation/method
 */
if ($update->updateDhcpServer(new \CUCM\StructType\UpdateDhcpServerReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateDhcpSubnet operation/method
 */
if ($update->updateDhcpSubnet(new \CUCM\StructType\UpdateDhcpSubnetReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCallPark operation/method
 */
if ($update->updateCallPark(new \CUCM\StructType\UpdateCallParkReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateDirectedCallPark operation/method
 */
if ($update->updateDirectedCallPark(new \CUCM\StructType\UpdateDirectedCallParkReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMeetMe operation/method
 */
if ($update->updateMeetMe(new \CUCM\StructType\UpdateMeetMeReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMobileVoiceAccess operation/method
 */
if ($update->updateMobileVoiceAccess(new \CUCM\StructType\UpdateMobileVoiceAccessReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRouteList operation/method
 */
if ($update->updateRouteList(new \CUCM\StructType\UpdateRouteListReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateUser operation/method
 */
if ($update->updateUser(new \CUCM\StructType\UpdateUserReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateLicenseCapabilities operation/method
 */
if ($update->updateLicenseCapabilities(new \CUCM\StructType\UpdateLicenseCapabilitiesReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAppUser operation/method
 */
if ($update->updateAppUser(new \CUCM\StructType\UpdateAppUserReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateSipRealm operation/method
 */
if ($update->updateSipRealm(new \CUCM\StructType\UpdateSipRealmReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePhoneNtp operation/method
 */
if ($update->updatePhoneNtp(new \CUCM\StructType\UpdatePhoneNtpReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateDateTimeGroup operation/method
 */
if ($update->updateDateTimeGroup(new \CUCM\StructType\UpdateDateTimeGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePresenceGroup operation/method
 */
if ($update->updatePresenceGroup(new \CUCM\StructType\UpdatePresenceGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGeoLocation operation/method
 */
if ($update->updateGeoLocation(new \CUCM\StructType\UpdateGeoLocationReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateSrst operation/method
 */
if ($update->updateSrst(new \CUCM\StructType\UpdateSrstReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMlppDomain operation/method
 */
if ($update->updateMlppDomain(new \CUCM\StructType\UpdateMlppDomainReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCumaServerSecurityProfile operation/method
 */
if ($update->updateCumaServerSecurityProfile(new \CUCM\StructType\UpdateCumaServerSecurityProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateApplicationServer operation/method
 */
if ($update->updateApplicationServer(new \CUCM\StructType\UpdateApplicationServerReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateApplicationUserCapfProfile operation/method
 */
if ($update->updateApplicationUserCapfProfile(new \CUCM\StructType\UpdateApplicationUserCapfProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateEndUserCapfProfile operation/method
 */
if ($update->updateEndUserCapfProfile(new \CUCM\StructType\UpdateEndUserCapfProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateServiceParameter operation/method
 */
if ($update->updateServiceParameter(new \CUCM\StructType\UpdateServiceParameterReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGeoLocationFilter operation/method
 */
if ($update->updateGeoLocationFilter(new \CUCM\StructType\UpdateGeoLocationFilterReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateVoiceMailProfile operation/method
 */
if ($update->updateVoiceMailProfile(new \CUCM\StructType\UpdateVoiceMailProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateVoiceMailPort operation/method
 */
if ($update->updateVoiceMailPort(new \CUCM\StructType\UpdateVoiceMailPortReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGatekeeper operation/method
 */
if ($update->updateGatekeeper(new \CUCM\StructType\UpdateGatekeeperReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePhoneButtonTemplate operation/method
 */
if ($update->updatePhoneButtonTemplate(new \CUCM\StructType\UpdatePhoneButtonTemplateReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCommonPhoneConfig operation/method
 */
if ($update->updateCommonPhoneConfig(new \CUCM\StructType\UpdateCommonPhoneConfigReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMessageWaiting operation/method
 */
if ($update->updateMessageWaiting(new \CUCM\StructType\UpdateMessageWaitingReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateIpPhoneServices operation/method
 */
if ($update->updateIpPhoneServices(new \CUCM\StructType\UpdateIpPhoneServicesReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCtiRoutePoint operation/method
 */
if ($update->updateCtiRoutePoint(new \CUCM\StructType\UpdateCtiRoutePointReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateTransPattern operation/method
 */
if ($update->updateTransPattern(new \CUCM\StructType\UpdateTransPatternReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCallingPartyTransformationPattern operation/method
 */
if ($update->updateCallingPartyTransformationPattern(new \CUCM\StructType\UpdateCallingPartyTransformationPatternReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateSipRoutePattern operation/method
 */
if ($update->updateSipRoutePattern(new \CUCM\StructType\UpdateSipRoutePatternReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateHuntPilot operation/method
 */
if ($update->updateHuntPilot(new \CUCM\StructType\UpdateHuntPilotReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRoutePattern operation/method
 */
if ($update->updateRoutePattern(new \CUCM\StructType\UpdateRoutePatternReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateApplicationDialRules operation/method
 */
if ($update->updateApplicationDialRules(new \CUCM\StructType\UpdateApplicationDialRulesReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateDirectoryLookupDialRules operation/method
 */
if ($update->updateDirectoryLookupDialRules(new \CUCM\StructType\UpdateDirectoryLookupDialRulesReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePhoneSecurityProfile operation/method
 */
if ($update->updatePhoneSecurityProfile(new \CUCM\StructType\UpdatePhoneSecurityProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateSipDialRules operation/method
 */
if ($update->updateSipDialRules(new \CUCM\StructType\UpdateSipDialRulesReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateConferenceBridge operation/method
 */
if ($update->updateConferenceBridge(new \CUCM\StructType\UpdateConferenceBridgeReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAnnunciator operation/method
 */
if ($update->updateAnnunciator(new \CUCM\StructType\UpdateAnnunciatorReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMtp operation/method
 */
if ($update->updateMtp(new \CUCM\StructType\UpdateMtpReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateFixedMohAudioSource operation/method
 */
if ($update->updateFixedMohAudioSource(new \CUCM\StructType\UpdateFixedMohAudioSourceReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAarGroupMatrix operation/method
 */
if ($update->updateAarGroupMatrix(new \CUCM\StructType\UpdateAarGroupMatrixReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRemoteDestinationProfile operation/method
 */
if ($update->updateRemoteDestinationProfile(new \CUCM\StructType\UpdateRemoteDestinationProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateLine operation/method
 */
if ($update->updateLine(new \CUCM\StructType\UpdateLineReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateDefaultDeviceProfile operation/method
 */
if ($update->updateDefaultDeviceProfile(new \CUCM\StructType\UpdateDefaultDeviceProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateH323Phone operation/method
 */
if ($update->updateH323Phone(new \CUCM\StructType\UpdateH323PhoneReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMohServer operation/method
 */
if ($update->updateMohServer(new \CUCM\StructType\UpdateMohServerReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateH323Trunk operation/method
 */
if ($update->updateH323Trunk(new \CUCM\StructType\UpdateH323TrunkReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updatePhone operation/method
 */
if ($update->updatePhone(new \CUCM\StructType\UpdatePhoneReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateH323Gateway operation/method
 */
if ($update->updateH323Gateway(new \CUCM\StructType\UpdateH323GatewayReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateDeviceProfile operation/method
 */
if ($update->updateDeviceProfile(new \CUCM\StructType\UpdateDeviceProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRemoteDestination operation/method
 */
if ($update->updateRemoteDestination(new \CUCM\StructType\UpdateRemoteDestinationReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGateway operation/method
 */
if ($update->updateGateway(new \CUCM\StructType\UpdateGatewayReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGatewayEndpointAnalogAccess operation/method
 */
if ($update->updateGatewayEndpointAnalogAccess(new \CUCM\StructType\UpdateGatewayEndpointAnalogAccessReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGatewayEndpointDigitalAccessPri operation/method
 */
if ($update->updateGatewayEndpointDigitalAccessPri(new \CUCM\StructType\UpdateGatewayEndpointDigitalAccessPriReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGatewayEndpointDigitalAccessBri operation/method
 */
if ($update->updateGatewayEndpointDigitalAccessBri(new \CUCM\StructType\UpdateGatewayEndpointDigitalAccessBriReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGatewayEndpointDigitalAccessT1 operation/method
 */
if ($update->updateGatewayEndpointDigitalAccessT1(new \CUCM\StructType\UpdateGatewayEndpointDigitalAccessT1Req()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateVg224 operation/method
 */
if ($update->updateVg224(new \CUCM\StructType\UpdateVg224Req()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCiscoCatalyst600024PortFXSGateway operation/method
 */
if ($update->updateCiscoCatalyst600024PortFXSGateway(new \CUCM\StructType\UpdateCiscoCatalyst600024PortFXSGatewayReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCiscoCatalyst6000E1VoIPGateway operation/method
 */
if ($update->updateCiscoCatalyst6000E1VoIPGateway(new \CUCM\StructType\UpdateCiscoCatalyst6000E1VoIPGatewayReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCiscoCatalyst6000T1VoIPGatewayPri operation/method
 */
if ($update->updateCiscoCatalyst6000T1VoIPGatewayPri(new \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayPriReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCiscoCatalyst6000T1VoIPGatewayT1 operation/method
 */
if ($update->updateCiscoCatalyst6000T1VoIPGatewayT1(new \CUCM\StructType\UpdateCiscoCatalyst6000T1VoIPGatewayT1Req()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCallPickupGroup operation/method
 */
if ($update->updateCallPickupGroup(new \CUCM\StructType\UpdateCallPickupGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateGeoLocationPolicy operation/method
 */
if ($update->updateGeoLocationPolicy(new \CUCM\StructType\UpdateGeoLocationPolicyReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateSipTrunk operation/method
 */
if ($update->updateSipTrunk(new \CUCM\StructType\UpdateSipTrunkReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRegionMatrix operation/method
 */
if ($update->updateRegionMatrix(new \CUCM\StructType\UpdateRegionMatrixReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCalledPartyTransformationPattern operation/method
 */
if ($update->updateCalledPartyTransformationPattern(new \CUCM\StructType\UpdateCalledPartyTransformationPatternReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateExternalCallControlProfile operation/method
 */
if ($update->updateExternalCallControlProfile(new \CUCM\StructType\UpdateExternalCallControlProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateSafSecurityProfile operation/method
 */
if ($update->updateSafSecurityProfile(new \CUCM\StructType\UpdateSafSecurityProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateSafForwarder operation/method
 */
if ($update->updateSafForwarder(new \CUCM\StructType\UpdateSafForwarderReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCcdHostedDN operation/method
 */
if ($update->updateCcdHostedDN(new \CUCM\StructType\UpdateCcdHostedDNReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCcdHostedDNGroup operation/method
 */
if ($update->updateCcdHostedDNGroup(new \CUCM\StructType\UpdateCcdHostedDNGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCcdRequestingService operation/method
 */
if ($update->updateCcdRequestingService(new \CUCM\StructType\UpdateCcdRequestingServiceReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateInterClusterServiceProfile operation/method
 */
if ($update->updateInterClusterServiceProfile(new \CUCM\StructType\UpdateInterClusterServiceProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateRemoteCluster operation/method
 */
if ($update->updateRemoteCluster(new \CUCM\StructType\UpdateRemoteClusterReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateCcdAdvertisingService operation/method
 */
if ($update->updateCcdAdvertisingService(new \CUCM\StructType\UpdateCcdAdvertisingServiceReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateLdapDirectory operation/method
 */
if ($update->updateLdapDirectory(new \CUCM\StructType\UpdateLdapDirectoryReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateEmccFeatureConfig operation/method
 */
if ($update->updateEmccFeatureConfig(new \CUCM\StructType\UpdateEmccFeatureConfigReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateSafCcdPurgeBlockLearnedRoutes operation/method
 */
if ($update->updateSafCcdPurgeBlockLearnedRoutes(new \CUCM\StructType\UpdateSafCcdPurgeBlockLearnedRoutesReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateVpnGateway operation/method
 */
if ($update->updateVpnGateway(new \CUCM\StructType\UpdateVpnGatewayReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateVpnGroup operation/method
 */
if ($update->updateVpnGroup(new \CUCM\StructType\UpdateVpnGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateVpnProfile operation/method
 */
if ($update->updateVpnProfile(new \CUCM\StructType\UpdateVpnProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateImeServer operation/method
 */
if ($update->updateImeServer(new \CUCM\StructType\UpdateImeServerReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateImeRouteFilterGroup operation/method
 */
if ($update->updateImeRouteFilterGroup(new \CUCM\StructType\UpdateImeRouteFilterGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateImeRouteFilterElement operation/method
 */
if ($update->updateImeRouteFilterElement(new \CUCM\StructType\UpdateImeRouteFilterElementReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateImeClient operation/method
 */
if ($update->updateImeClient(new \CUCM\StructType\UpdateImeClientReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateImeEnrolledPattern operation/method
 */
if ($update->updateImeEnrolledPattern(new \CUCM\StructType\UpdateImeEnrolledPatternReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateImeEnrolledPatternGroup operation/method
 */
if ($update->updateImeEnrolledPatternGroup(new \CUCM\StructType\UpdateImeEnrolledPatternGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateImeExclusionNumber operation/method
 */
if ($update->updateImeExclusionNumber(new \CUCM\StructType\UpdateImeExclusionNumberReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateImeExclusionNumberGroup operation/method
 */
if ($update->updateImeExclusionNumberGroup(new \CUCM\StructType\UpdateImeExclusionNumberGroupReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateImeFirewall operation/method
 */
if ($update->updateImeFirewall(new \CUCM\StructType\UpdateImeFirewallReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateImeE164Transformation operation/method
 */
if ($update->updateImeE164Transformation(new \CUCM\StructType\UpdateImeE164TransformationReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateTransformationProfile operation/method
 */
if ($update->updateTransformationProfile(new \CUCM\StructType\UpdateTransformationProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateFallbackProfile operation/method
 */
if ($update->updateFallbackProfile(new \CUCM\StructType\UpdateFallbackProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateLdapFilter operation/method
 */
if ($update->updateLdapFilter(new \CUCM\StructType\UpdateLdapFilterReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateAppServerInfo operation/method
 */
if ($update->updateAppServerInfo(new \CUCM\StructType\UpdateAppServerInfoReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateTvsCertificate operation/method
 */
if ($update->updateTvsCertificate(new \CUCM\StructType\UpdateTvsCertificateReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateFeatureControlPolicy operation/method
 */
if ($update->updateFeatureControlPolicy(new \CUCM\StructType\UpdateFeatureControlPolicyReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMobilityProfile operation/method
 */
if ($update->updateMobilityProfile(new \CUCM\StructType\UpdateMobilityProfileReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateEnterpriseFeatureAccessConfiguration operation/method
 */
if ($update->updateEnterpriseFeatureAccessConfiguration(new \CUCM\StructType\UpdateEnterpriseFeatureAccessConfigurationReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateHandoffConfiguration operation/method
 */
if ($update->updateHandoffConfiguration(new \CUCM\StructType\UpdateHandoffConfigurationReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMobility operation/method
 */
if ($update->updateMobility(new \CUCM\StructType\UpdateMobilityReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateEnterprisePhoneConfig operation/method
 */
if ($update->updateEnterprisePhoneConfig(new \CUCM\StructType\UpdateEnterprisePhoneConfigReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateLdapSystem operation/method
 */
if ($update->updateLdapSystem(new \CUCM\StructType\UpdateLdapSystemReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateLdapAuthentication operation/method
 */
if ($update->updateLdapAuthentication(new \CUCM\StructType\UpdateLdapAuthenticationReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateImeFeatureConfig operation/method
 */
if ($update->updateImeFeatureConfig(new \CUCM\StructType\UpdateImeFeatureConfigReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateFallbackFeatureConfig operation/method
 */
if ($update->updateFallbackFeatureConfig(new \CUCM\StructType\UpdateFallbackFeatureConfigReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateImeLearnedRoutes operation/method
 */
if ($update->updateImeLearnedRoutes(new \CUCM\StructType\UpdateImeLearnedRoutesReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateSoftKeySet operation/method
 */
if ($update->updateSoftKeySet(new \CUCM\StructType\UpdateSoftKeySetReq()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \CUCM\ServiceType\Get($options);
/**
 * Sample call for getSipProfile operation/method
 */
if ($get->getSipProfile(new \CUCM\StructType\GetSipProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSipTrunkSecurityProfile operation/method
 */
if ($get->getSipTrunkSecurityProfile(new \CUCM\StructType\GetSipTrunkSecurityProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTimePeriod operation/method
 */
if ($get->getTimePeriod(new \CUCM\StructType\GetTimePeriodReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTimeSchedule operation/method
 */
if ($get->getTimeSchedule(new \CUCM\StructType\GetTimeScheduleReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTodAccess operation/method
 */
if ($get->getTodAccess(new \CUCM\StructType\GetTodAccessReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVoiceMailPilot operation/method
 */
if ($get->getVoiceMailPilot(new \CUCM\StructType\GetVoiceMailPilotReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProcessNode operation/method
 */
if ($get->getProcessNode(new \CUCM\StructType\GetProcessNodeReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCallerFilterList operation/method
 */
if ($get->getCallerFilterList(new \CUCM\StructType\GetCallerFilterListReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRoutePartition operation/method
 */
if ($get->getRoutePartition(new \CUCM\StructType\GetRoutePartitionReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCss operation/method
 */
if ($get->getCss(new \CUCM\StructType\GetCssReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCallManager operation/method
 */
if ($get->getCallManager(new \CUCM\StructType\GetCallManagerReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMediaResourceGroup operation/method
 */
if ($get->getMediaResourceGroup(new \CUCM\StructType\GetMediaResourceGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMediaResourceList operation/method
 */
if ($get->getMediaResourceList(new \CUCM\StructType\GetMediaResourceListReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRegion operation/method
 */
if ($get->getRegion(new \CUCM\StructType\GetRegionReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAarGroup operation/method
 */
if ($get->getAarGroup(new \CUCM\StructType\GetAarGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPhysicalLocation operation/method
 */
if ($get->getPhysicalLocation(new \CUCM\StructType\GetPhysicalLocationReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRouteGroup operation/method
 */
if ($get->getRouteGroup(new \CUCM\StructType\GetRouteGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDevicePool operation/method
 */
if ($get->getDevicePool(new \CUCM\StructType\GetDevicePoolReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeviceMobilityGroup operation/method
 */
if ($get->getDeviceMobilityGroup(new \CUCM\StructType\GetDeviceMobilityGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLocation operation/method
 */
if ($get->getLocation(new \CUCM\StructType\GetLocationReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSoftKeyTemplate operation/method
 */
if ($get->getSoftKeyTemplate(new \CUCM\StructType\GetSoftKeyTemplateReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTranscoder operation/method
 */
if ($get->getTranscoder(new \CUCM\StructType\GetTranscoderReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCommonDeviceConfig operation/method
 */
if ($get->getCommonDeviceConfig(new \CUCM\StructType\GetCommonDeviceConfigReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getResourcePriorityNamespace operation/method
 */
if ($get->getResourcePriorityNamespace(new \CUCM\StructType\GetResourcePriorityNamespaceReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getResourcePriorityNamespaceList operation/method
 */
if ($get->getResourcePriorityNamespaceList(new \CUCM\StructType\GetResourcePriorityNamespaceListReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeviceMobility operation/method
 */
if ($get->getDeviceMobility(new \CUCM\StructType\GetDeviceMobilityReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCmcInfo operation/method
 */
if ($get->getCmcInfo(new \CUCM\StructType\GetCmcInfoReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCredentialPolicy operation/method
 */
if ($get->getCredentialPolicy(new \CUCM\StructType\GetCredentialPolicyReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFacInfo operation/method
 */
if ($get->getFacInfo(new \CUCM\StructType\GetFacInfoReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getHuntList operation/method
 */
if ($get->getHuntList(new \CUCM\StructType\GetHuntListReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getIvrUserLocale operation/method
 */
if ($get->getIvrUserLocale(new \CUCM\StructType\GetIvrUserLocaleReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLineGroup operation/method
 */
if ($get->getLineGroup(new \CUCM\StructType\GetLineGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRecordingProfile operation/method
 */
if ($get->getRecordingProfile(new \CUCM\StructType\GetRecordingProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRouteFilter operation/method
 */
if ($get->getRouteFilter(new \CUCM\StructType\GetRouteFilterReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCallManagerGroup operation/method
 */
if ($get->getCallManagerGroup(new \CUCM\StructType\GetCallManagerGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUserGroup operation/method
 */
if ($get->getUserGroup(new \CUCM\StructType\GetUserGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDialPlan operation/method
 */
if ($get->getDialPlan(new \CUCM\StructType\GetDialPlanReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDialPlanTag operation/method
 */
if ($get->getDialPlanTag(new \CUCM\StructType\GetDialPlanTagReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDdi operation/method
 */
if ($get->getDdi(new \CUCM\StructType\GetDdiReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMobileSmartClientProfile operation/method
 */
if ($get->getMobileSmartClientProfile(new \CUCM\StructType\GetMobileSmartClientProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getProcessNodeService operation/method
 */
if ($get->getProcessNodeService(new \CUCM\StructType\GetProcessNodeServiceReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMohAudioSource operation/method
 */
if ($get->getMohAudioSource(new \CUCM\StructType\GetMohAudioSourceReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDhcpServer operation/method
 */
if ($get->getDhcpServer(new \CUCM\StructType\GetDhcpServerReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDhcpSubnet operation/method
 */
if ($get->getDhcpSubnet(new \CUCM\StructType\GetDhcpSubnetReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCallPark operation/method
 */
if ($get->getCallPark(new \CUCM\StructType\GetCallParkReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDirectedCallPark operation/method
 */
if ($get->getDirectedCallPark(new \CUCM\StructType\GetDirectedCallParkReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMeetMe operation/method
 */
if ($get->getMeetMe(new \CUCM\StructType\GetMeetMeReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMobileVoiceAccess operation/method
 */
if ($get->getMobileVoiceAccess(new \CUCM\StructType\GetMobileVoiceAccessReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRouteList operation/method
 */
if ($get->getRouteList(new \CUCM\StructType\GetRouteListReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUser operation/method
 */
if ($get->getUser(new \CUCM\StructType\GetUserReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLicenseCapabilities operation/method
 */
if ($get->getLicenseCapabilities(new \CUCM\StructType\GetLicenseCapabilitiesReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAppUser operation/method
 */
if ($get->getAppUser(new \CUCM\StructType\GetAppUserReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSipRealm operation/method
 */
if ($get->getSipRealm(new \CUCM\StructType\GetSipRealmReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPhoneNtp operation/method
 */
if ($get->getPhoneNtp(new \CUCM\StructType\GetPhoneNtpReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDateTimeGroup operation/method
 */
if ($get->getDateTimeGroup(new \CUCM\StructType\GetDateTimeGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPresenceGroup operation/method
 */
if ($get->getPresenceGroup(new \CUCM\StructType\GetPresenceGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGeoLocation operation/method
 */
if ($get->getGeoLocation(new \CUCM\StructType\GetGeoLocationReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSrst operation/method
 */
if ($get->getSrst(new \CUCM\StructType\GetSrstReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMlppDomain operation/method
 */
if ($get->getMlppDomain(new \CUCM\StructType\GetMlppDomainReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCumaServerSecurityProfile operation/method
 */
if ($get->getCumaServerSecurityProfile(new \CUCM\StructType\GetCumaServerSecurityProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getApplicationServer operation/method
 */
if ($get->getApplicationServer(new \CUCM\StructType\GetApplicationServerReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getApplicationUserCapfProfile operation/method
 */
if ($get->getApplicationUserCapfProfile(new \CUCM\StructType\GetApplicationUserCapfProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEndUserCapfProfile operation/method
 */
if ($get->getEndUserCapfProfile(new \CUCM\StructType\GetEndUserCapfProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getServiceParameter operation/method
 */
if ($get->getServiceParameter(new \CUCM\StructType\GetServiceParameterReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGeoLocationFilter operation/method
 */
if ($get->getGeoLocationFilter(new \CUCM\StructType\GetGeoLocationFilterReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVoiceMailProfile operation/method
 */
if ($get->getVoiceMailProfile(new \CUCM\StructType\GetVoiceMailProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVoiceMailPort operation/method
 */
if ($get->getVoiceMailPort(new \CUCM\StructType\GetVoiceMailPortReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGatekeeper operation/method
 */
if ($get->getGatekeeper(new \CUCM\StructType\GetGatekeeperReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPhoneButtonTemplate operation/method
 */
if ($get->getPhoneButtonTemplate(new \CUCM\StructType\GetPhoneButtonTemplateReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCommonPhoneConfig operation/method
 */
if ($get->getCommonPhoneConfig(new \CUCM\StructType\GetCommonPhoneConfigReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMessageWaiting operation/method
 */
if ($get->getMessageWaiting(new \CUCM\StructType\GetMessageWaitingReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getIpPhoneServices operation/method
 */
if ($get->getIpPhoneServices(new \CUCM\StructType\GetIpPhoneServicesReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCtiRoutePoint operation/method
 */
if ($get->getCtiRoutePoint(new \CUCM\StructType\GetCtiRoutePointReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTransPattern operation/method
 */
if ($get->getTransPattern(new \CUCM\StructType\GetTransPatternReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCallingPartyTransformationPattern operation/method
 */
if ($get->getCallingPartyTransformationPattern(new \CUCM\StructType\GetCallingPartyTransformationPatternReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSipRoutePattern operation/method
 */
if ($get->getSipRoutePattern(new \CUCM\StructType\GetSipRoutePatternReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getHuntPilot operation/method
 */
if ($get->getHuntPilot(new \CUCM\StructType\GetHuntPilotReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRoutePattern operation/method
 */
if ($get->getRoutePattern(new \CUCM\StructType\GetRoutePatternReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getApplicationDialRules operation/method
 */
if ($get->getApplicationDialRules(new \CUCM\StructType\GetApplicationDialRulesReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDirectoryLookupDialRules operation/method
 */
if ($get->getDirectoryLookupDialRules(new \CUCM\StructType\GetDirectoryLookupDialRulesReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPhoneSecurityProfile operation/method
 */
if ($get->getPhoneSecurityProfile(new \CUCM\StructType\GetPhoneSecurityProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSipDialRules operation/method
 */
if ($get->getSipDialRules(new \CUCM\StructType\GetSipDialRulesReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getConferenceBridge operation/method
 */
if ($get->getConferenceBridge(new \CUCM\StructType\GetConferenceBridgeReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAnnunciator operation/method
 */
if ($get->getAnnunciator(new \CUCM\StructType\GetAnnunciatorReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMtp operation/method
 */
if ($get->getMtp(new \CUCM\StructType\GetMtpReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFixedMohAudioSource operation/method
 */
if ($get->getFixedMohAudioSource(new \CUCM\StructType\GetFixedMohAudioSourceReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRemoteDestinationProfile operation/method
 */
if ($get->getRemoteDestinationProfile(new \CUCM\StructType\GetRemoteDestinationProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLine operation/method
 */
if ($get->getLine(new \CUCM\StructType\GetLineReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDefaultDeviceProfile operation/method
 */
if ($get->getDefaultDeviceProfile(new \CUCM\StructType\GetDefaultDeviceProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getH323Phone operation/method
 */
if ($get->getH323Phone(new \CUCM\StructType\GetH323PhoneReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMohServer operation/method
 */
if ($get->getMohServer(new \CUCM\StructType\GetMohServerReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getH323Trunk operation/method
 */
if ($get->getH323Trunk(new \CUCM\StructType\GetH323TrunkReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPhone operation/method
 */
if ($get->getPhone(new \CUCM\StructType\GetPhoneReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getH323Gateway operation/method
 */
if ($get->getH323Gateway(new \CUCM\StructType\GetH323GatewayReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDeviceProfile operation/method
 */
if ($get->getDeviceProfile(new \CUCM\StructType\GetDeviceProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRemoteDestination operation/method
 */
if ($get->getRemoteDestination(new \CUCM\StructType\GetRemoteDestinationReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGateway operation/method
 */
if ($get->getGateway(new \CUCM\StructType\GetGatewayReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGatewayEndpointAnalogAccess operation/method
 */
if ($get->getGatewayEndpointAnalogAccess(new \CUCM\StructType\GetGatewayEndpointAnalogAccessReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGatewayEndpointDigitalAccessPri operation/method
 */
if ($get->getGatewayEndpointDigitalAccessPri(new \CUCM\StructType\GetGatewayEndpointDigitalAccessPriReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGatewayEndpointDigitalAccessBri operation/method
 */
if ($get->getGatewayEndpointDigitalAccessBri(new \CUCM\StructType\GetGatewayEndpointDigitalAccessBriReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGatewayEndpointDigitalAccessT1 operation/method
 */
if ($get->getGatewayEndpointDigitalAccessT1(new \CUCM\StructType\GetGatewayEndpointDigitalAccessT1Req()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVg224 operation/method
 */
if ($get->getVg224(new \CUCM\StructType\GetVg224Req()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCiscoCatalyst600024PortFXSGateway operation/method
 */
if ($get->getCiscoCatalyst600024PortFXSGateway(new \CUCM\StructType\GetCiscoCatalyst600024PortFXSGatewayReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCiscoCatalyst6000E1VoIPGateway operation/method
 */
if ($get->getCiscoCatalyst6000E1VoIPGateway(new \CUCM\StructType\GetCiscoCatalyst6000E1VoIPGatewayReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCiscoCatalyst6000T1VoIPGatewayPri operation/method
 */
if ($get->getCiscoCatalyst6000T1VoIPGatewayPri(new \CUCM\StructType\GetCiscoCatalyst6000T1VoIPGatewayPriReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCiscoCatalyst6000T1VoIPGatewayT1 operation/method
 */
if ($get->getCiscoCatalyst6000T1VoIPGatewayT1(new \CUCM\StructType\GetCiscoCatalyst6000T1VoIPGatewayT1Req()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCallPickupGroup operation/method
 */
if ($get->getCallPickupGroup(new \CUCM\StructType\GetCallPickupGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getGeoLocationPolicy operation/method
 */
if ($get->getGeoLocationPolicy(new \CUCM\StructType\GetGeoLocationPolicyReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSipTrunk operation/method
 */
if ($get->getSipTrunk(new \CUCM\StructType\GetSipTrunkReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCalledPartyTransformationPattern operation/method
 */
if ($get->getCalledPartyTransformationPattern(new \CUCM\StructType\GetCalledPartyTransformationPatternReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getExternalCallControlProfile operation/method
 */
if ($get->getExternalCallControlProfile(new \CUCM\StructType\GetExternalCallControlProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSafSecurityProfile operation/method
 */
if ($get->getSafSecurityProfile(new \CUCM\StructType\GetSafSecurityProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSafForwarder operation/method
 */
if ($get->getSafForwarder(new \CUCM\StructType\GetSafForwarderReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCcdHostedDN operation/method
 */
if ($get->getCcdHostedDN(new \CUCM\StructType\GetCcdHostedDNReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCcdHostedDNGroup operation/method
 */
if ($get->getCcdHostedDNGroup(new \CUCM\StructType\GetCcdHostedDNGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCcdRequestingService operation/method
 */
if ($get->getCcdRequestingService(new \CUCM\StructType\GetCcdRequestingServiceReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getInterClusterServiceProfile operation/method
 */
if ($get->getInterClusterServiceProfile(new \CUCM\StructType\GetInterClusterServiceProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRemoteCluster operation/method
 */
if ($get->getRemoteCluster(new \CUCM\StructType\GetRemoteClusterReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCcdAdvertisingService operation/method
 */
if ($get->getCcdAdvertisingService(new \CUCM\StructType\GetCcdAdvertisingServiceReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLdapDirectory operation/method
 */
if ($get->getLdapDirectory(new \CUCM\StructType\GetLdapDirectoryReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEmccFeatureConfig operation/method
 */
if ($get->getEmccFeatureConfig(new \CUCM\StructType\GetEmccFeatureConfigReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSafCcdPurgeBlockLearnedRoutes operation/method
 */
if ($get->getSafCcdPurgeBlockLearnedRoutes(new \CUCM\StructType\GetSafCcdPurgeBlockLearnedRoutesReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVpnGateway operation/method
 */
if ($get->getVpnGateway(new \CUCM\StructType\GetVpnGatewayReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVpnGroup operation/method
 */
if ($get->getVpnGroup(new \CUCM\StructType\GetVpnGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVpnProfile operation/method
 */
if ($get->getVpnProfile(new \CUCM\StructType\GetVpnProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getImeServer operation/method
 */
if ($get->getImeServer(new \CUCM\StructType\GetImeServerReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getImeRouteFilterGroup operation/method
 */
if ($get->getImeRouteFilterGroup(new \CUCM\StructType\GetImeRouteFilterGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getImeRouteFilterElement operation/method
 */
if ($get->getImeRouteFilterElement(new \CUCM\StructType\GetImeRouteFilterElementReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getImeClient operation/method
 */
if ($get->getImeClient(new \CUCM\StructType\GetImeClientReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getImeEnrolledPattern operation/method
 */
if ($get->getImeEnrolledPattern(new \CUCM\StructType\GetImeEnrolledPatternReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getImeEnrolledPatternGroup operation/method
 */
if ($get->getImeEnrolledPatternGroup(new \CUCM\StructType\GetImeEnrolledPatternGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getImeExclusionNumber operation/method
 */
if ($get->getImeExclusionNumber(new \CUCM\StructType\GetImeExclusionNumberReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getImeExclusionNumberGroup operation/method
 */
if ($get->getImeExclusionNumberGroup(new \CUCM\StructType\GetImeExclusionNumberGroupReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getImeFirewall operation/method
 */
if ($get->getImeFirewall(new \CUCM\StructType\GetImeFirewallReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getImeE164Transformation operation/method
 */
if ($get->getImeE164Transformation(new \CUCM\StructType\GetImeE164TransformationReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTransformationProfile operation/method
 */
if ($get->getTransformationProfile(new \CUCM\StructType\GetTransformationProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFallbackProfile operation/method
 */
if ($get->getFallbackProfile(new \CUCM\StructType\GetFallbackProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLdapFilter operation/method
 */
if ($get->getLdapFilter(new \CUCM\StructType\GetLdapFilterReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getTvsCertificate operation/method
 */
if ($get->getTvsCertificate(new \CUCM\StructType\GetTvsCertificateReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFeatureControlPolicy operation/method
 */
if ($get->getFeatureControlPolicy(new \CUCM\StructType\GetFeatureControlPolicyReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMobilityProfile operation/method
 */
if ($get->getMobilityProfile(new \CUCM\StructType\GetMobilityProfileReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEnterpriseFeatureAccessConfiguration operation/method
 */
if ($get->getEnterpriseFeatureAccessConfiguration(new \CUCM\StructType\GetEnterpriseFeatureAccessConfigurationReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getHandoffConfiguration operation/method
 */
if ($get->getHandoffConfiguration(new \CUCM\StructType\GetHandoffConfigurationReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOSVersion operation/method
 */
if ($get->getOSVersion(new \CUCM\StructType\GetOSVersionReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getNumDevices operation/method
 */
if ($get->getNumDevices(new \CUCM\StructType\GetNumDevicesReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMobility operation/method
 */
if ($get->getMobility(new \CUCM\StructType\GetMobilityReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getEnterprisePhoneConfig operation/method
 */
if ($get->getEnterprisePhoneConfig(new \CUCM\StructType\GetEnterprisePhoneConfigReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLicenseUnitReport operation/method
 */
if ($get->getLicenseUnitReport(new \CUCM\StructType\GetLicenseUnitReportReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLdapSystem operation/method
 */
if ($get->getLdapSystem(new \CUCM\StructType\GetLdapSystemReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLdapAuthentication operation/method
 */
if ($get->getLdapAuthentication(new \CUCM\StructType\GetLdapAuthenticationReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCCMVersion operation/method
 */
if ($get->getCCMVersion(new \CUCM\StructType\GetCCMVersionReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getImeLearnedRoutes operation/method
 */
if ($get->getImeLearnedRoutes(new \CUCM\StructType\GetImeLearnedRoutesReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getImeFeatureConfig operation/method
 */
if ($get->getImeFeatureConfig(new \CUCM\StructType\GetImeFeatureConfigReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFallbackFeatureConfig operation/method
 */
if ($get->getFallbackFeatureConfig(new \CUCM\StructType\GetFallbackFeatureConfigReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAppServerInfo operation/method
 */
if ($get->getAppServerInfo(new \CUCM\StructType\GetAppServerInfoReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLdapSyncStatus operation/method
 */
if ($get->getLdapSyncStatus(new \CUCM\StructType\GetLdapSyncStatusReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSoftKeySet operation/method
 */
if ($get->getSoftKeySet(new \CUCM\StructType\GetSoftKeySetReq()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \CUCM\ServiceType\Remove($options);
/**
 * Sample call for removeSipProfile operation/method
 */
if ($remove->removeSipProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeSipTrunkSecurityProfile operation/method
 */
if ($remove->removeSipTrunkSecurityProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeTimePeriod operation/method
 */
if ($remove->removeTimePeriod(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeTimeSchedule operation/method
 */
if ($remove->removeTimeSchedule(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeTodAccess operation/method
 */
if ($remove->removeTodAccess(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeVoiceMailPilot operation/method
 */
if ($remove->removeVoiceMailPilot(new \CUCM\StructType\RemoveVoiceMailPilotReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeProcessNode operation/method
 */
if ($remove->removeProcessNode(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCallerFilterList operation/method
 */
if ($remove->removeCallerFilterList(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeRoutePartition operation/method
 */
if ($remove->removeRoutePartition(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCss operation/method
 */
if ($remove->removeCss(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeMediaResourceGroup operation/method
 */
if ($remove->removeMediaResourceGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeMediaResourceList operation/method
 */
if ($remove->removeMediaResourceList(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeRegion operation/method
 */
if ($remove->removeRegion(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeAarGroup operation/method
 */
if ($remove->removeAarGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removePhysicalLocation operation/method
 */
if ($remove->removePhysicalLocation(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeRouteGroup operation/method
 */
if ($remove->removeRouteGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeDevicePool operation/method
 */
if ($remove->removeDevicePool(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeDeviceMobilityGroup operation/method
 */
if ($remove->removeDeviceMobilityGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeLocation operation/method
 */
if ($remove->removeLocation(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeSoftKeyTemplate operation/method
 */
if ($remove->removeSoftKeyTemplate(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeTranscoder operation/method
 */
if ($remove->removeTranscoder(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCommonDeviceConfig operation/method
 */
if ($remove->removeCommonDeviceConfig(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeResourcePriorityNamespace operation/method
 */
if ($remove->removeResourcePriorityNamespace(new \CUCM\StructType\RemoveResourcePriorityNamespaceReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeResourcePriorityNamespaceList operation/method
 */
if ($remove->removeResourcePriorityNamespaceList(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeDeviceMobility operation/method
 */
if ($remove->removeDeviceMobility(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCmcInfo operation/method
 */
if ($remove->removeCmcInfo(new \CUCM\StructType\RemoveCmcInfoReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCredentialPolicy operation/method
 */
if ($remove->removeCredentialPolicy(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeFacInfo operation/method
 */
if ($remove->removeFacInfo(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeHuntList operation/method
 */
if ($remove->removeHuntList(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeIvrUserLocale operation/method
 */
if ($remove->removeIvrUserLocale(new \CUCM\StructType\RemoveIvrUserLocaleReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeLineGroup operation/method
 */
if ($remove->removeLineGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeRecordingProfile operation/method
 */
if ($remove->removeRecordingProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeRouteFilter operation/method
 */
if ($remove->removeRouteFilter(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCallManagerGroup operation/method
 */
if ($remove->removeCallManagerGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeUserGroup operation/method
 */
if ($remove->removeUserGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeMohAudioSource operation/method
 */
if ($remove->removeMohAudioSource(new \CUCM\StructType\RemoveMohAudioSourceReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeDhcpServer operation/method
 */
if ($remove->removeDhcpServer(new \CUCM\StructType\RemoveDhcpServerReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeDhcpSubnet operation/method
 */
if ($remove->removeDhcpSubnet(new \CUCM\StructType\RemoveDhcpSubnetReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCallPark operation/method
 */
if ($remove->removeCallPark(new \CUCM\StructType\RemoveCallParkReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeDirectedCallPark operation/method
 */
if ($remove->removeDirectedCallPark(new \CUCM\StructType\RemoveDirectedCallParkReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeMeetMe operation/method
 */
if ($remove->removeMeetMe(new \CUCM\StructType\RemoveMeetMeReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeMobileVoiceAccess operation/method
 */
if ($remove->removeMobileVoiceAccess(new \CUCM\StructType\RemoveMobileVoiceAccessReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeRouteList operation/method
 */
if ($remove->removeRouteList(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeUser operation/method
 */
if ($remove->removeUser(new \CUCM\StructType\RemoveUserReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeAppUser operation/method
 */
if ($remove->removeAppUser(new \CUCM\StructType\RemoveAppUserReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeSipRealm operation/method
 */
if ($remove->removeSipRealm(new \CUCM\StructType\RemoveSipRealmReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removePhoneNtp operation/method
 */
if ($remove->removePhoneNtp(new \CUCM\StructType\RemovePhoneNtpReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeDateTimeGroup operation/method
 */
if ($remove->removeDateTimeGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removePresenceGroup operation/method
 */
if ($remove->removePresenceGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeGeoLocation operation/method
 */
if ($remove->removeGeoLocation(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeSrst operation/method
 */
if ($remove->removeSrst(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeMlppDomain operation/method
 */
if ($remove->removeMlppDomain(new \CUCM\StructType\RemoveMlppDomainReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCumaServerSecurityProfile operation/method
 */
if ($remove->removeCumaServerSecurityProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeApplicationServer operation/method
 */
if ($remove->removeApplicationServer(new \CUCM\StructType\RemoveApplicationServerReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeApplicationUserCapfProfile operation/method
 */
if ($remove->removeApplicationUserCapfProfile(new \CUCM\StructType\RemoveApplicationUserCapfProfileReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeEndUserCapfProfile operation/method
 */
if ($remove->removeEndUserCapfProfile(new \CUCM\StructType\RemoveEndUserCapfProfileReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeGeoLocationFilter operation/method
 */
if ($remove->removeGeoLocationFilter(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeVoiceMailProfile operation/method
 */
if ($remove->removeVoiceMailProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeVoiceMailPort operation/method
 */
if ($remove->removeVoiceMailPort(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeGatekeeper operation/method
 */
if ($remove->removeGatekeeper(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removePhoneButtonTemplate operation/method
 */
if ($remove->removePhoneButtonTemplate(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCommonPhoneConfig operation/method
 */
if ($remove->removeCommonPhoneConfig(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeMessageWaiting operation/method
 */
if ($remove->removeMessageWaiting(new \CUCM\StructType\RemoveMessageWaitingReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeIpPhoneServices operation/method
 */
if ($remove->removeIpPhoneServices(new \CUCM\StructType\RemoveIpPhoneServicesReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCtiRoutePoint operation/method
 */
if ($remove->removeCtiRoutePoint(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeTransPattern operation/method
 */
if ($remove->removeTransPattern(new \CUCM\StructType\RemoveTransPatternReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCallingPartyTransformationPattern operation/method
 */
if ($remove->removeCallingPartyTransformationPattern(new \CUCM\StructType\RemoveCallingPartyTransformationPatternReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeSipRoutePattern operation/method
 */
if ($remove->removeSipRoutePattern(new \CUCM\StructType\RemoveSipRoutePatternReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeHuntPilot operation/method
 */
if ($remove->removeHuntPilot(new \CUCM\StructType\RemoveHuntPilotReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeRoutePattern operation/method
 */
if ($remove->removeRoutePattern(new \CUCM\StructType\RemoveRoutePatternReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeApplicationDialRules operation/method
 */
if ($remove->removeApplicationDialRules(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeDirectoryLookupDialRules operation/method
 */
if ($remove->removeDirectoryLookupDialRules(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removePhoneSecurityProfile operation/method
 */
if ($remove->removePhoneSecurityProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeSipDialRules operation/method
 */
if ($remove->removeSipDialRules(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeConferenceBridge operation/method
 */
if ($remove->removeConferenceBridge(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeMtp operation/method
 */
if ($remove->removeMtp(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeRemoteDestinationProfile operation/method
 */
if ($remove->removeRemoteDestinationProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeLine operation/method
 */
if ($remove->removeLine(new \CUCM\StructType\RemoveLineReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeDefaultDeviceProfile operation/method
 */
if ($remove->removeDefaultDeviceProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeH323Phone operation/method
 */
if ($remove->removeH323Phone(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeH323Trunk operation/method
 */
if ($remove->removeH323Trunk(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removePhone operation/method
 */
if ($remove->removePhone(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeH323Gateway operation/method
 */
if ($remove->removeH323Gateway(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeDeviceProfile operation/method
 */
if ($remove->removeDeviceProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeRemoteDestination operation/method
 */
if ($remove->removeRemoteDestination(new \CUCM\StructType\RemoveRemoteDestinationReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeGateway operation/method
 */
if ($remove->removeGateway(new \CUCM\StructType\RemoveGatewayReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeGatewayEndpointAnalogAccess operation/method
 */
if ($remove->removeGatewayEndpointAnalogAccess(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeGatewayEndpointDigitalAccessPri operation/method
 */
if ($remove->removeGatewayEndpointDigitalAccessPri(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeGatewayEndpointDigitalAccessBri operation/method
 */
if ($remove->removeGatewayEndpointDigitalAccessBri(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeGatewayEndpointDigitalAccessT1 operation/method
 */
if ($remove->removeGatewayEndpointDigitalAccessT1(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeVg224 operation/method
 */
if ($remove->removeVg224(new \CUCM\StructType\RemoveVg224Req()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCiscoCatalyst600024PortFXSGateway operation/method
 */
if ($remove->removeCiscoCatalyst600024PortFXSGateway(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCiscoCatalyst6000E1VoIPGateway operation/method
 */
if ($remove->removeCiscoCatalyst6000E1VoIPGateway(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCiscoCatalyst6000T1VoIPGatewayPri operation/method
 */
if ($remove->removeCiscoCatalyst6000T1VoIPGatewayPri(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCiscoCatalyst6000T1VoIPGatewayT1 operation/method
 */
if ($remove->removeCiscoCatalyst6000T1VoIPGatewayT1(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCallPickupGroup operation/method
 */
if ($remove->removeCallPickupGroup(new \CUCM\StructType\RemoveCallPickupGroupReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeGeoLocationPolicy operation/method
 */
if ($remove->removeGeoLocationPolicy(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeSipTrunk operation/method
 */
if ($remove->removeSipTrunk(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCalledPartyTransformationPattern operation/method
 */
if ($remove->removeCalledPartyTransformationPattern(new \CUCM\StructType\RemoveCalledPartyTransformationPatternReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeExternalCallControlProfile operation/method
 */
if ($remove->removeExternalCallControlProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeSafSecurityProfile operation/method
 */
if ($remove->removeSafSecurityProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeSafForwarder operation/method
 */
if ($remove->removeSafForwarder(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCcdHostedDN operation/method
 */
if ($remove->removeCcdHostedDN(new \CUCM\StructType\RemoveCcdHostedDNReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCcdHostedDNGroup operation/method
 */
if ($remove->removeCcdHostedDNGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCcdRequestingService operation/method
 */
if ($remove->removeCcdRequestingService(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeRemoteCluster operation/method
 */
if ($remove->removeRemoteCluster(new \CUCM\StructType\RemoveRemoteClusterReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeCcdAdvertisingService operation/method
 */
if ($remove->removeCcdAdvertisingService(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeLdapDirectory operation/method
 */
if ($remove->removeLdapDirectory(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeSafCcdPurgeBlockLearnedRoutes operation/method
 */
if ($remove->removeSafCcdPurgeBlockLearnedRoutes(new \CUCM\StructType\RemoveSafCcdPurgeBlockLearnedRoutesReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeVpnGateway operation/method
 */
if ($remove->removeVpnGateway(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeVpnGroup operation/method
 */
if ($remove->removeVpnGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeVpnProfile operation/method
 */
if ($remove->removeVpnProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeImeServer operation/method
 */
if ($remove->removeImeServer(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeImeRouteFilterGroup operation/method
 */
if ($remove->removeImeRouteFilterGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeImeRouteFilterElement operation/method
 */
if ($remove->removeImeRouteFilterElement(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeImeClient operation/method
 */
if ($remove->removeImeClient(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeImeEnrolledPattern operation/method
 */
if ($remove->removeImeEnrolledPattern(new \CUCM\StructType\RemoveImeEnrolledPatternReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeImeEnrolledPatternGroup operation/method
 */
if ($remove->removeImeEnrolledPatternGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeImeExclusionNumber operation/method
 */
if ($remove->removeImeExclusionNumber(new \CUCM\StructType\RemoveImeExclusionNumberReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeImeExclusionNumberGroup operation/method
 */
if ($remove->removeImeExclusionNumberGroup(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeImeFirewall operation/method
 */
if ($remove->removeImeFirewall(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeImeE164Transformation operation/method
 */
if ($remove->removeImeE164Transformation(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeTransformationProfile operation/method
 */
if ($remove->removeTransformationProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeFallbackProfile operation/method
 */
if ($remove->removeFallbackProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeLdapFilter operation/method
 */
if ($remove->removeLdapFilter(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeFeatureControlPolicy operation/method
 */
if ($remove->removeFeatureControlPolicy(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeMobilityProfile operation/method
 */
if ($remove->removeMobilityProfile(new \CUCM\StructType\NameAndGUIDRequest()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeEnterpriseFeatureAccessConfiguration operation/method
 */
if ($remove->removeEnterpriseFeatureAccessConfiguration(new \CUCM\StructType\RemoveEnterpriseFeatureAccessConfigurationReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeHandoffConfiguration operation/method
 */
if ($remove->removeHandoffConfiguration(new \CUCM\StructType\RemoveHandoffConfigurationReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeApplicationToSoftkeyTemplate operation/method
 */
if ($remove->removeApplicationToSoftkeyTemplate(new \CUCM\StructType\RemoveApplicationToSoftkeyTemplateReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeUnitsToGateway operation/method
 */
if ($remove->removeUnitsToGateway(new \CUCM\StructType\RemoveUnitsToGatewayReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeGatewaySubunits operation/method
 */
if ($remove->removeGatewaySubunits(new \CUCM\StructType\RemoveGatewaySubunitsReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeImeLearnedRoutes operation/method
 */
if ($remove->removeImeLearnedRoutes(new \CUCM\StructType\RemoveImeLearnedRoutesReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Sample call for removeAppServerInfo operation/method
 */
if ($remove->removeAppServerInfo(new \CUCM\StructType\RemoveAppServerInfoReq()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \CUCM\ServiceType\_List($options);
/**
 * Sample call for listSipProfile operation/method
 */
if ($list->listSipProfile(new \CUCM\StructType\ListSipProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listSipTrunkSecurityProfile operation/method
 */
if ($list->listSipTrunkSecurityProfile(new \CUCM\StructType\ListSipTrunkSecurityProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listTimePeriod operation/method
 */
if ($list->listTimePeriod(new \CUCM\StructType\ListTimePeriodReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listTimeSchedule operation/method
 */
if ($list->listTimeSchedule(new \CUCM\StructType\ListTimeScheduleReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listTodAccess operation/method
 */
if ($list->listTodAccess(new \CUCM\StructType\ListTodAccessReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listVoiceMailPilot operation/method
 */
if ($list->listVoiceMailPilot(new \CUCM\StructType\ListVoiceMailPilotReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listProcessNode operation/method
 */
if ($list->listProcessNode(new \CUCM\StructType\ListProcessNodeReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCallerFilterList operation/method
 */
if ($list->listCallerFilterList(new \CUCM\StructType\ListCallerFilterListReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listRoutePartition operation/method
 */
if ($list->listRoutePartition(new \CUCM\StructType\ListRoutePartitionReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCss operation/method
 */
if ($list->listCss(new \CUCM\StructType\ListCssReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCallManager operation/method
 */
if ($list->listCallManager(new \CUCM\StructType\ListCallManagerReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listMediaResourceGroup operation/method
 */
if ($list->listMediaResourceGroup(new \CUCM\StructType\ListMediaResourceGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listMediaResourceList operation/method
 */
if ($list->listMediaResourceList(new \CUCM\StructType\ListMediaResourceListReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listRegion operation/method
 */
if ($list->listRegion(new \CUCM\StructType\ListRegionReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listAarGroup operation/method
 */
if ($list->listAarGroup(new \CUCM\StructType\ListAarGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listPhysicalLocation operation/method
 */
if ($list->listPhysicalLocation(new \CUCM\StructType\ListPhysicalLocationReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listRouteGroup operation/method
 */
if ($list->listRouteGroup(new \CUCM\StructType\ListRouteGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDevicePool operation/method
 */
if ($list->listDevicePool(new \CUCM\StructType\ListDevicePoolReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDeviceMobilityGroup operation/method
 */
if ($list->listDeviceMobilityGroup(new \CUCM\StructType\ListDeviceMobilityGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listLocation operation/method
 */
if ($list->listLocation(new \CUCM\StructType\ListLocationReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listSoftKeyTemplate operation/method
 */
if ($list->listSoftKeyTemplate(new \CUCM\StructType\ListSoftKeyTemplateReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listTranscoder operation/method
 */
if ($list->listTranscoder(new \CUCM\StructType\ListTranscoderReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCommonDeviceConfig operation/method
 */
if ($list->listCommonDeviceConfig(new \CUCM\StructType\ListCommonDeviceConfigReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listResourcePriorityNamespace operation/method
 */
if ($list->listResourcePriorityNamespace(new \CUCM\StructType\ListResourcePriorityNamespaceReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listResourcePriorityNamespaceList operation/method
 */
if ($list->listResourcePriorityNamespaceList(new \CUCM\StructType\ListResourcePriorityNamespaceListReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDeviceMobility operation/method
 */
if ($list->listDeviceMobility(new \CUCM\StructType\ListDeviceMobilityReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCmcInfo operation/method
 */
if ($list->listCmcInfo(new \CUCM\StructType\ListCmcInfoReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCredentialPolicy operation/method
 */
if ($list->listCredentialPolicy(new \CUCM\StructType\ListCredentialPolicyReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listFacInfo operation/method
 */
if ($list->listFacInfo(new \CUCM\StructType\ListFacInfoReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listHuntList operation/method
 */
if ($list->listHuntList(new \CUCM\StructType\ListHuntListReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listIvrUserLocale operation/method
 */
if ($list->listIvrUserLocale(new \CUCM\StructType\ListIvrUserLocaleReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listLineGroup operation/method
 */
if ($list->listLineGroup(new \CUCM\StructType\ListLineGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listRecordingProfile operation/method
 */
if ($list->listRecordingProfile(new \CUCM\StructType\ListRecordingProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listRouteFilter operation/method
 */
if ($list->listRouteFilter(new \CUCM\StructType\ListRouteFilterReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCallManagerGroup operation/method
 */
if ($list->listCallManagerGroup(new \CUCM\StructType\ListCallManagerGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listUserGroup operation/method
 */
if ($list->listUserGroup(new \CUCM\StructType\ListUserGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDialPlan operation/method
 */
if ($list->listDialPlan(new \CUCM\StructType\ListDialPlanReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDialPlanTag operation/method
 */
if ($list->listDialPlanTag(new \CUCM\StructType\ListDialPlanTagReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDdi operation/method
 */
if ($list->listDdi(new \CUCM\StructType\ListDdiReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listMobileSmartClientProfile operation/method
 */
if ($list->listMobileSmartClientProfile(new \CUCM\StructType\ListMobileSmartClientProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listProcessNodeService operation/method
 */
if ($list->listProcessNodeService(new \CUCM\StructType\ListProcessNodeServiceReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listMohAudioSource operation/method
 */
if ($list->listMohAudioSource(new \CUCM\StructType\ListMohAudioSourceReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDhcpServer operation/method
 */
if ($list->listDhcpServer(new \CUCM\StructType\ListDhcpServerReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDhcpSubnet operation/method
 */
if ($list->listDhcpSubnet(new \CUCM\StructType\ListDhcpSubnetReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCallPark operation/method
 */
if ($list->listCallPark(new \CUCM\StructType\ListCallParkReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDirectedCallPark operation/method
 */
if ($list->listDirectedCallPark(new \CUCM\StructType\ListDirectedCallParkReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listMeetMe operation/method
 */
if ($list->listMeetMe(new \CUCM\StructType\ListMeetMeReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listRouteList operation/method
 */
if ($list->listRouteList(new \CUCM\StructType\ListRouteListReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listUser operation/method
 */
if ($list->listUser(new \CUCM\StructType\ListUserReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listLicenseCapabilities operation/method
 */
if ($list->listLicenseCapabilities(new \CUCM\StructType\ListLicenseCapabilitiesReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listAppUser operation/method
 */
if ($list->listAppUser(new \CUCM\StructType\ListAppUserReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listSipRealm operation/method
 */
if ($list->listSipRealm(new \CUCM\StructType\ListSipRealmReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listPhoneNtp operation/method
 */
if ($list->listPhoneNtp(new \CUCM\StructType\ListPhoneNtpReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDateTimeGroup operation/method
 */
if ($list->listDateTimeGroup(new \CUCM\StructType\ListDateTimeGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listPresenceGroup operation/method
 */
if ($list->listPresenceGroup(new \CUCM\StructType\ListPresenceGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listGeoLocation operation/method
 */
if ($list->listGeoLocation(new \CUCM\StructType\ListGeoLocationReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listSrst operation/method
 */
if ($list->listSrst(new \CUCM\StructType\ListSrstReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listMlppDomain operation/method
 */
if ($list->listMlppDomain(new \CUCM\StructType\ListMlppDomainReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCumaServerSecurityProfile operation/method
 */
if ($list->listCumaServerSecurityProfile(new \CUCM\StructType\ListCumaServerSecurityProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listApplicationServer operation/method
 */
if ($list->listApplicationServer(new \CUCM\StructType\ListApplicationServerReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listApplicationUserCapfProfile operation/method
 */
if ($list->listApplicationUserCapfProfile(new \CUCM\StructType\ListApplicationUserCapfProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listEndUserCapfProfile operation/method
 */
if ($list->listEndUserCapfProfile(new \CUCM\StructType\ListEndUserCapfProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listGeoLocationFilter operation/method
 */
if ($list->listGeoLocationFilter(new \CUCM\StructType\ListGeoLocationFilterReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listVoiceMailProfile operation/method
 */
if ($list->listVoiceMailProfile(new \CUCM\StructType\ListVoiceMailProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listVoiceMailPort operation/method
 */
if ($list->listVoiceMailPort(new \CUCM\StructType\ListVoiceMailPortReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listGatekeeper operation/method
 */
if ($list->listGatekeeper(new \CUCM\StructType\ListGatekeeperReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listPhoneButtonTemplate operation/method
 */
if ($list->listPhoneButtonTemplate(new \CUCM\StructType\ListPhoneButtonTemplateReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCommonPhoneConfig operation/method
 */
if ($list->listCommonPhoneConfig(new \CUCM\StructType\ListCommonPhoneConfigReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listMessageWaiting operation/method
 */
if ($list->listMessageWaiting(new \CUCM\StructType\ListMessageWaitingReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listIpPhoneServices operation/method
 */
if ($list->listIpPhoneServices(new \CUCM\StructType\ListIpPhoneServicesReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCtiRoutePoint operation/method
 */
if ($list->listCtiRoutePoint(new \CUCM\StructType\ListCtiRoutePointReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listTransPattern operation/method
 */
if ($list->listTransPattern(new \CUCM\StructType\ListTransPatternReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCallingPartyTransformationPattern operation/method
 */
if ($list->listCallingPartyTransformationPattern(new \CUCM\StructType\ListCallingPartyTransformationPatternReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listSipRoutePattern operation/method
 */
if ($list->listSipRoutePattern(new \CUCM\StructType\ListSipRoutePatternReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listHuntPilot operation/method
 */
if ($list->listHuntPilot(new \CUCM\StructType\ListHuntPilotReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listRoutePattern operation/method
 */
if ($list->listRoutePattern(new \CUCM\StructType\ListRoutePatternReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listApplicationDialRules operation/method
 */
if ($list->listApplicationDialRules(new \CUCM\StructType\ListApplicationDialRulesReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDirectoryLookupDialRules operation/method
 */
if ($list->listDirectoryLookupDialRules(new \CUCM\StructType\ListDirectoryLookupDialRulesReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listPhoneSecurityProfile operation/method
 */
if ($list->listPhoneSecurityProfile(new \CUCM\StructType\ListPhoneSecurityProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listSipDialRules operation/method
 */
if ($list->listSipDialRules(new \CUCM\StructType\ListSipDialRulesReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listConferenceBridge operation/method
 */
if ($list->listConferenceBridge(new \CUCM\StructType\ListConferenceBridgeReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listAnnunciator operation/method
 */
if ($list->listAnnunciator(new \CUCM\StructType\ListAnnunciatorReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listMtp operation/method
 */
if ($list->listMtp(new \CUCM\StructType\ListMtpReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listRemoteDestinationProfile operation/method
 */
if ($list->listRemoteDestinationProfile(new \CUCM\StructType\ListRemoteDestinationProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listLine operation/method
 */
if ($list->listLine(new \CUCM\StructType\ListLineReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDefaultDeviceProfile operation/method
 */
if ($list->listDefaultDeviceProfile(new \CUCM\StructType\ListDefaultDeviceProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listH323Phone operation/method
 */
if ($list->listH323Phone(new \CUCM\StructType\ListH323PhoneReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listMohServer operation/method
 */
if ($list->listMohServer(new \CUCM\StructType\ListMohServerReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listH323Trunk operation/method
 */
if ($list->listH323Trunk(new \CUCM\StructType\ListH323TrunkReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listPhone operation/method
 */
if ($list->listPhone(new \CUCM\StructType\ListPhoneReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listH323Gateway operation/method
 */
if ($list->listH323Gateway(new \CUCM\StructType\ListH323GatewayReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listDeviceProfile operation/method
 */
if ($list->listDeviceProfile(new \CUCM\StructType\ListDeviceProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listRemoteDestination operation/method
 */
if ($list->listRemoteDestination(new \CUCM\StructType\ListRemoteDestinationReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listGateway operation/method
 */
if ($list->listGateway(new \CUCM\StructType\ListGatewayReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCiscoCatalyst600024PortFXSGateway operation/method
 */
if ($list->listCiscoCatalyst600024PortFXSGateway(new \CUCM\StructType\ListCiscoCatalyst600024PortFXSGatewayReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCiscoCatalyst6000E1VoIPGateway operation/method
 */
if ($list->listCiscoCatalyst6000E1VoIPGateway(new \CUCM\StructType\ListCiscoCatalyst6000E1VoIPGatewayReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCiscoCatalyst6000T1VoIPGatewayPri operation/method
 */
if ($list->listCiscoCatalyst6000T1VoIPGatewayPri(new \CUCM\StructType\ListCiscoCatalyst6000T1VoIPGatewayPriReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCiscoCatalyst6000T1VoIPGatewayT1 operation/method
 */
if ($list->listCiscoCatalyst6000T1VoIPGatewayT1(new \CUCM\StructType\ListCiscoCatalyst6000T1VoIPGatewayT1Req()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCallPickupGroup operation/method
 */
if ($list->listCallPickupGroup(new \CUCM\StructType\ListCallPickupGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listRoutePlan operation/method
 */
if ($list->listRoutePlan(new \CUCM\StructType\ListRoutePlanReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listGeoLocationPolicy operation/method
 */
if ($list->listGeoLocationPolicy(new \CUCM\StructType\ListGeoLocationPolicyReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listSipTrunk operation/method
 */
if ($list->listSipTrunk(new \CUCM\StructType\ListSipTrunkReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCalledPartyTransformationPattern operation/method
 */
if ($list->listCalledPartyTransformationPattern(new \CUCM\StructType\ListCalledPartyTransformationPatternReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listExternalCallControlProfile operation/method
 */
if ($list->listExternalCallControlProfile(new \CUCM\StructType\ListExternalCallControlProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listSafSecurityProfile operation/method
 */
if ($list->listSafSecurityProfile(new \CUCM\StructType\ListSafSecurityProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listSafForwarder operation/method
 */
if ($list->listSafForwarder(new \CUCM\StructType\ListSafForwarderReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCcdHostedDN operation/method
 */
if ($list->listCcdHostedDN(new \CUCM\StructType\ListCcdHostedDNReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCcdHostedDNGroup operation/method
 */
if ($list->listCcdHostedDNGroup(new \CUCM\StructType\ListCcdHostedDNGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listRemoteCluster operation/method
 */
if ($list->listRemoteCluster(new \CUCM\StructType\ListRemoteClusterReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCcdAdvertisingService operation/method
 */
if ($list->listCcdAdvertisingService(new \CUCM\StructType\ListCcdAdvertisingServiceReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listLdapDirectory operation/method
 */
if ($list->listLdapDirectory(new \CUCM\StructType\ListLdapDirectoryReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listSafCcdPurgeBlockLearnedRoutes operation/method
 */
if ($list->listSafCcdPurgeBlockLearnedRoutes(new \CUCM\StructType\ListSafCcdPurgeBlockLearnedRoutesReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listVpnGateway operation/method
 */
if ($list->listVpnGateway(new \CUCM\StructType\ListVpnGatewayReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listVpnGroup operation/method
 */
if ($list->listVpnGroup(new \CUCM\StructType\ListVpnGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listVpnProfile operation/method
 */
if ($list->listVpnProfile(new \CUCM\StructType\ListVpnProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listImeServer operation/method
 */
if ($list->listImeServer(new \CUCM\StructType\ListImeServerReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listImeRouteFilterGroup operation/method
 */
if ($list->listImeRouteFilterGroup(new \CUCM\StructType\ListImeRouteFilterGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listImeRouteFilterElement operation/method
 */
if ($list->listImeRouteFilterElement(new \CUCM\StructType\ListImeRouteFilterElementReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listImeClient operation/method
 */
if ($list->listImeClient(new \CUCM\StructType\ListImeClientReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listImeEnrolledPattern operation/method
 */
if ($list->listImeEnrolledPattern(new \CUCM\StructType\ListImeEnrolledPatternReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listImeEnrolledPatternGroup operation/method
 */
if ($list->listImeEnrolledPatternGroup(new \CUCM\StructType\ListImeEnrolledPatternGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listImeExclusionNumber operation/method
 */
if ($list->listImeExclusionNumber(new \CUCM\StructType\ListImeExclusionNumberReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listImeExclusionNumberGroup operation/method
 */
if ($list->listImeExclusionNumberGroup(new \CUCM\StructType\ListImeExclusionNumberGroupReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listImeFirewall operation/method
 */
if ($list->listImeFirewall(new \CUCM\StructType\ListImeFirewallReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listImeE164Transformation operation/method
 */
if ($list->listImeE164Transformation(new \CUCM\StructType\ListImeE164TransformationReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listTransformationProfile operation/method
 */
if ($list->listTransformationProfile(new \CUCM\StructType\ListTransformationProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listFallbackProfile operation/method
 */
if ($list->listFallbackProfile(new \CUCM\StructType\ListFallbackProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listLdapFilter operation/method
 */
if ($list->listLdapFilter(new \CUCM\StructType\ListLdapFilterReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listTvsCertificate operation/method
 */
if ($list->listTvsCertificate(new \CUCM\StructType\ListTvsCertificateReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listFeatureControlPolicy operation/method
 */
if ($list->listFeatureControlPolicy(new \CUCM\StructType\ListFeatureControlPolicyReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listMobilityProfile operation/method
 */
if ($list->listMobilityProfile(new \CUCM\StructType\ListMobilityProfileReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listEnterpriseFeatureAccessConfiguration operation/method
 */
if ($list->listEnterpriseFeatureAccessConfiguration(new \CUCM\StructType\ListEnterpriseFeatureAccessConfigurationReq()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Execute ServiceType
 */
$execute = new \CUCM\ServiceType\Execute($options);
/**
 * Sample call for executeSQLQuery operation/method
 */
if ($execute->executeSQLQuery(new \CUCM\StructType\ExecuteSQLQueryReq()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Sample call for executeSQLUpdate operation/method
 */
if ($execute->executeSQLUpdate(new \CUCM\StructType\ExecuteSQLUpdateReq()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Samples for Do ServiceType
 */
$do = new \CUCM\ServiceType\_Do($options);
/**
 * Sample call for doAuthenticateUser operation/method
 */
if ($do->doAuthenticateUser(new \CUCM\StructType\DoAuthenticateUserReq()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Sample call for doDeviceLogin operation/method
 */
if ($do->doDeviceLogin(new \CUCM\StructType\DoDeviceLoginReq()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Sample call for doDeviceLogout operation/method
 */
if ($do->doDeviceLogout(new \CUCM\StructType\DoDeviceLogoutReq()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Sample call for doDeviceReset operation/method
 */
if ($do->doDeviceReset(new \CUCM\StructType\DoDeviceResetReq()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Sample call for doLdapSync operation/method
 */
if ($do->doLdapSync(new \CUCM\StructType\DoLdapSyncReq()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Sample call for doUpdateRemoteCluster operation/method
 */
if ($do->doUpdateRemoteCluster(new \CUCM\StructType\DoUpdateRemoteClusterReq()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
