<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XSipTrunk StructType
 * @subpackage Structs
 */
class XSipTrunk extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - default: User
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocolSide;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $locationName;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * The sipProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $sipProfileName;
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkLocation;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $mediaResourceListName;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not valid for H323Phone,H323trunk and SIPTrunk
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - documentation: For devices with load information, if any special load information is specified the special attribute is set to TRUE.Otherwise,the load information is default for the product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The traceFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $traceFlag;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - default: Off
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This setting only affects devices that support MLPP.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $preemption;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The retryVideoCallAsAudio
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $retryVideoCallAsAudio;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationName;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $geoLocationFilterName;
    /**
     * The sendGeoLocation
     * Meta informations extracted from the WSDL
     * - documentation: Not valid for CTI route points and VoiceMail ports
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendGeoLocation;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The unattendedPort
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: Applicable only for H323Phones and H323Trunks.Not for Gateways.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $unattendedPort;
    /**
     * The transmitUtf8
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $transmitUtf8;
    /**
     * The subscribeCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $subscribeCallingSearchSpaceName;
    /**
     * The rerouteCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $rerouteCallingSearchSpaceName;
    /**
     * The referCallingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $referCallingSearchSpaceName;
    /**
     * The mtpRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $mtpRequired;
    /**
     * The unknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $unknownPrefix;
    /**
     * The destinationAddress
     * Meta informations extracted from the WSDL
     * - documentation: This tag is deprecated from version 8.5 onwards and is ignored by AXL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $destinationAddress;
    /**
     * The destAddrIsSrv
     * Meta informations extracted from the WSDL
     * - documentation: This tag is ignored and destAddrIsSRV is set to false if destinationaddress is an IP address and destinationport is mentioned correctly.This tag will not be returned by list.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $destAddrIsSrv;
    /**
     * The destinationport
     * Meta informations extracted from the WSDL
     * - documentation: This tag is deprecated from version 8.5 onwards and is ignored by AXL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destinationport;
    /**
     * The tkSipCodec
     * Meta informations extracted from the WSDL
     * - default: 711ulaw
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tkSipCodec;
    /**
     * The sigDigits
     * Meta informations extracted from the WSDL
     * - default: 99
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\SigDigits
     */
    public $sigDigits;
    /**
     * The connectedNamePresentation
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedNamePresentation;
    /**
     * The connectedPartyIdPresentation
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $connectedPartyIdPresentation;
    /**
     * The callingPartySelection
     * Meta informations extracted from the WSDL
     * - default: Originator
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingname
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingname;
    /**
     * The callingLineIdPresentation
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callingLineIdPresentation;
    /**
     * The prefixDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $prefixDn;
    /**
     * The callerName
     * Meta informations extracted from the WSDL
     * - documentation: Characters which are not valid for caller name are ampersand, braces, less than or greater than, percentage sign, double quotes, square brackets and pipe.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $callerName;
    /**
     * The callerIdDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $callerIdDn;
    /**
     * The acceptInboundRdnis
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptInboundRdnis;
    /**
     * The acceptOutboundRdnis
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $acceptOutboundRdnis;
    /**
     * The srtpAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpAllowed;
    /**
     * The srtpFallbackAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: This tag is valid only if srtpAllowed is set to false.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $srtpFallbackAllowed;
    /**
     * The isPaiEnabled
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isPaiEnabled;
    /**
     * The sipPrivacy
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipPrivacy;
    /**
     * The isRpidEnabled
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isRpidEnabled;
    /**
     * The sipAssertedType
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipAssertedType;
    /**
     * The destinationAddressIpv6
     * Meta informations extracted from the WSDL
     * - documentation: This tag is deprecated from version 8.5 onwards and is ignored by AXL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destinationAddressIpv6;
    /**
     * The dtmfSignalingMethod
     * Meta informations extracted from the WSDL
     * - default: No Preference
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dtmfSignalingMethod;
    /**
     * The routeClassSignalling
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $routeClassSignalling;
    /**
     * The sipTrunkType
     * Meta informations extracted from the WSDL
     * - default: None(Default)
     * - documentation: This tag is not supported in the Update method.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $sipTrunkType;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $imeE164TransformationName;
    /**
     * The useImePublicIpPort
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useImePublicIpPort;
    /**
     * The useDevicePoolCntdPnTransformationCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCntdPnTransformationCss;
    /**
     * The cntdPnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $cntdPnTransformationCssName;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The sipNormalizationScriptName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $sipNormalizationScriptName;
    /**
     * The runOnEveryNode
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $runOnEveryNode;
    /**
     * The destinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Destinations
     */
    public $destinations;
    /**
     * The unknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $unknownStripDigits;
    /**
     * The cgpnTransformationUnknownCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $cgpnTransformationUnknownCssName;
    /**
     * The tunneledProtocol
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $tunneledProtocol;
    /**
     * The asn1RoseOidEncoding
     * Meta informations extracted from the WSDL
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $asn1RoseOidEncoding;
    /**
     * The qsigVariant
     * Meta informations extracted from the WSDL
     * - default: No Changes
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $qsigVariant;
    /**
     * The pathReplacementSupport
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pathReplacementSupport;
    /**
     * The enableQsigUtf8
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableQsigUtf8;
    /**
     * The scriptParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $scriptParameters;
    /**
     * The scriptTraceEnabled
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $scriptTraceEnabled;
    /**
     * The trunkTrafficSecure
     * Meta informations extracted from the WSDL
     * - default: When using both sRTP and TLS
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $trunkTrafficSecure;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XSipTrunk
     * @uses XSipTrunk::setName()
     * @uses XSipTrunk::setProduct()
     * @uses XSipTrunk::setClass()
     * @uses XSipTrunk::setProtocol()
     * @uses XSipTrunk::setProtocolSide()
     * @uses XSipTrunk::setDevicePoolName()
     * @uses XSipTrunk::setLocationName()
     * @uses XSipTrunk::setSecurityProfileName()
     * @uses XSipTrunk::setSipProfileName()
     * @uses XSipTrunk::setPresenceGroupName()
     * @uses XSipTrunk::setDescription()
     * @uses XSipTrunk::setCallingSearchSpaceName()
     * @uses XSipTrunk::setCommonDeviceConfigName()
     * @uses XSipTrunk::setNetworkLocation()
     * @uses XSipTrunk::setMediaResourceListName()
     * @uses XSipTrunk::setNetworkHoldMohAudioSourceId()
     * @uses XSipTrunk::setUserHoldMohAudioSourceId()
     * @uses XSipTrunk::setAutomatedAlternateRoutingCssName()
     * @uses XSipTrunk::setAarNeighborhoodName()
     * @uses XSipTrunk::setPacketCaptureMode()
     * @uses XSipTrunk::setPacketCaptureDuration()
     * @uses XSipTrunk::setLoadInformation()
     * @uses XSipTrunk::setTraceFlag()
     * @uses XSipTrunk::setMlppDomainId()
     * @uses XSipTrunk::setMlppIndicationStatus()
     * @uses XSipTrunk::setPreemption()
     * @uses XSipTrunk::setUseTrustedRelayPoint()
     * @uses XSipTrunk::setRetryVideoCallAsAudio()
     * @uses XSipTrunk::setCgpnTransformationCssName()
     * @uses XSipTrunk::setUseDevicePoolCgpnTransformCss()
     * @uses XSipTrunk::setGeoLocationName()
     * @uses XSipTrunk::setGeoLocationFilterName()
     * @uses XSipTrunk::setSendGeoLocation()
     * @uses XSipTrunk::setCdpnTransformationCssName()
     * @uses XSipTrunk::setUseDevicePoolCdpnTransformCss()
     * @uses XSipTrunk::setUnattendedPort()
     * @uses XSipTrunk::setTransmitUtf8()
     * @uses XSipTrunk::setSubscribeCallingSearchSpaceName()
     * @uses XSipTrunk::setRerouteCallingSearchSpaceName()
     * @uses XSipTrunk::setReferCallingSearchSpaceName()
     * @uses XSipTrunk::setMtpRequired()
     * @uses XSipTrunk::setUnknownPrefix()
     * @uses XSipTrunk::setDestinationAddress()
     * @uses XSipTrunk::setDestAddrIsSrv()
     * @uses XSipTrunk::setDestinationport()
     * @uses XSipTrunk::setTkSipCodec()
     * @uses XSipTrunk::setSigDigits()
     * @uses XSipTrunk::setConnectedNamePresentation()
     * @uses XSipTrunk::setConnectedPartyIdPresentation()
     * @uses XSipTrunk::setCallingPartySelection()
     * @uses XSipTrunk::setCallingname()
     * @uses XSipTrunk::setCallingLineIdPresentation()
     * @uses XSipTrunk::setPrefixDn()
     * @uses XSipTrunk::setCallerName()
     * @uses XSipTrunk::setCallerIdDn()
     * @uses XSipTrunk::setAcceptInboundRdnis()
     * @uses XSipTrunk::setAcceptOutboundRdnis()
     * @uses XSipTrunk::setSrtpAllowed()
     * @uses XSipTrunk::setSrtpFallbackAllowed()
     * @uses XSipTrunk::setIsPaiEnabled()
     * @uses XSipTrunk::setSipPrivacy()
     * @uses XSipTrunk::setIsRpidEnabled()
     * @uses XSipTrunk::setSipAssertedType()
     * @uses XSipTrunk::setDestinationAddressIpv6()
     * @uses XSipTrunk::setDtmfSignalingMethod()
     * @uses XSipTrunk::setRouteClassSignalling()
     * @uses XSipTrunk::setSipTrunkType()
     * @uses XSipTrunk::setPstnAccess()
     * @uses XSipTrunk::setImeE164TransformationName()
     * @uses XSipTrunk::setUseImePublicIpPort()
     * @uses XSipTrunk::setUseDevicePoolCntdPnTransformationCss()
     * @uses XSipTrunk::setCntdPnTransformationCssName()
     * @uses XSipTrunk::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses XSipTrunk::setSipNormalizationScriptName()
     * @uses XSipTrunk::setRunOnEveryNode()
     * @uses XSipTrunk::setDestinations()
     * @uses XSipTrunk::setUnknownStripDigits()
     * @uses XSipTrunk::setCgpnTransformationUnknownCssName()
     * @uses XSipTrunk::setTunneledProtocol()
     * @uses XSipTrunk::setAsn1RoseOidEncoding()
     * @uses XSipTrunk::setQsigVariant()
     * @uses XSipTrunk::setPathReplacementSupport()
     * @uses XSipTrunk::setEnableQsigUtf8()
     * @uses XSipTrunk::setScriptParameters()
     * @uses XSipTrunk::setScriptTraceEnabled()
     * @uses XSipTrunk::setTrunkTrafficSecure()
     * @uses XSipTrunk::setCtiid()
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @param \CUCM\StructType\XFkType $locationName
     * @param \CUCM\StructType\XFkType $securityProfileName
     * @param \CUCM\StructType\XFkType $sipProfileName
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @param string $description
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @param string $networkLocation
     * @param \CUCM\StructType\XFkType $mediaResourceListName
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param \CUCM\StructType\XFkType $automatedAlternateRoutingCssName
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @param string $traceFlag
     * @param string $mlppDomainId
     * @param string $mlppIndicationStatus
     * @param string $preemption
     * @param string $useTrustedRelayPoint
     * @param string $retryVideoCallAsAudio
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCss
     * @param \CUCM\StructType\XFkType $geoLocationName
     * @param \CUCM\StructType\XFkType $geoLocationFilterName
     * @param string $sendGeoLocation
     * @param \CUCM\StructType\XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param string $unattendedPort
     * @param string $transmitUtf8
     * @param \CUCM\StructType\XFkType $subscribeCallingSearchSpaceName
     * @param \CUCM\StructType\XFkType $rerouteCallingSearchSpaceName
     * @param \CUCM\StructType\XFkType $referCallingSearchSpaceName
     * @param string $mtpRequired
     * @param string $unknownPrefix
     * @param string $destinationAddress
     * @param string $destAddrIsSrv
     * @param string $destinationport
     * @param string $tkSipCodec
     * @param \CUCM\StructType\SigDigits $sigDigits
     * @param string $connectedNamePresentation
     * @param string $connectedPartyIdPresentation
     * @param string $callingPartySelection
     * @param string $callingname
     * @param string $callingLineIdPresentation
     * @param string $prefixDn
     * @param string $callerName
     * @param string $callerIdDn
     * @param string $acceptInboundRdnis
     * @param string $acceptOutboundRdnis
     * @param string $srtpAllowed
     * @param string $srtpFallbackAllowed
     * @param string $isPaiEnabled
     * @param string $sipPrivacy
     * @param string $isRpidEnabled
     * @param string $sipAssertedType
     * @param string $destinationAddressIpv6
     * @param string $dtmfSignalingMethod
     * @param string $routeClassSignalling
     * @param string $sipTrunkType
     * @param string $pstnAccess
     * @param \CUCM\StructType\XFkType $imeE164TransformationName
     * @param string $useImePublicIpPort
     * @param string $useDevicePoolCntdPnTransformationCss
     * @param \CUCM\StructType\XFkType $cntdPnTransformationCssName
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param \CUCM\StructType\XFkType $sipNormalizationScriptName
     * @param string $runOnEveryNode
     * @param \CUCM\StructType\Destinations $destinations
     * @param int $unknownStripDigits
     * @param \CUCM\StructType\XFkType $cgpnTransformationUnknownCssName
     * @param string $tunneledProtocol
     * @param string $asn1RoseOidEncoding
     * @param string $qsigVariant
     * @param string $pathReplacementSupport
     * @param string $enableQsigUtf8
     * @param string $scriptParameters
     * @param string $scriptTraceEnabled
     * @param string $trunkTrafficSecure
     * @param int $ctiid
     */
    public function __construct($name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', \CUCM\StructType\XFkType $devicePoolName = null, \CUCM\StructType\XFkType $locationName = null, \CUCM\StructType\XFkType $securityProfileName = null, \CUCM\StructType\XFkType $sipProfileName = null, \CUCM\StructType\XFkType $presenceGroupName = null, $description = null, \CUCM\StructType\XFkType $callingSearchSpaceName = null, \CUCM\StructType\XFkType $commonDeviceConfigName = null, $networkLocation = 'Use System Default', \CUCM\StructType\XFkType $mediaResourceListName = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, \CUCM\StructType\XFkType $automatedAlternateRoutingCssName = null, \CUCM\StructType\XFkType $aarNeighborhoodName = null, $packetCaptureMode = 'None', $packetCaptureDuration = '0', \CUCM\StructType\XLoadInformation $loadInformation = null, $traceFlag = null, $mlppDomainId = null, $mlppIndicationStatus = 'Off', $preemption = 'Default', $useTrustedRelayPoint = 'Default', $retryVideoCallAsAudio = true, \CUCM\StructType\XFkType $cgpnTransformationCssName = null, $useDevicePoolCgpnTransformCss = true, \CUCM\StructType\XFkType $geoLocationName = null, \CUCM\StructType\XFkType $geoLocationFilterName = null, $sendGeoLocation = null, \CUCM\StructType\XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = true, $unattendedPort = false, $transmitUtf8 = false, \CUCM\StructType\XFkType $subscribeCallingSearchSpaceName = null, \CUCM\StructType\XFkType $rerouteCallingSearchSpaceName = null, \CUCM\StructType\XFkType $referCallingSearchSpaceName = null, $mtpRequired = null, $unknownPrefix = null, $destinationAddress = null, $destAddrIsSrv = null, $destinationport = null, $tkSipCodec = '711ulaw', \CUCM\StructType\SigDigits $sigDigits = '99', $connectedNamePresentation = 'Default', $connectedPartyIdPresentation = 'Default', $callingPartySelection = 'Originator', $callingname = 'Default', $callingLineIdPresentation = 'Default', $prefixDn = null, $callerName = null, $callerIdDn = null, $acceptInboundRdnis = null, $acceptOutboundRdnis = null, $srtpAllowed = false, $srtpFallbackAllowed = false, $isPaiEnabled = true, $sipPrivacy = 'Default', $isRpidEnabled = true, $sipAssertedType = 'Default', $destinationAddressIpv6 = null, $dtmfSignalingMethod = 'No Preference', $routeClassSignalling = 'Default', $sipTrunkType = None(Default), $pstnAccess = true, \CUCM\StructType\XFkType $imeE164TransformationName = null, $useImePublicIpPort = false, $useDevicePoolCntdPnTransformationCss = true, \CUCM\StructType\XFkType $cntdPnTransformationCssName = null, $useDevicePoolCgpnTransformCssUnkn = true, \CUCM\StructType\XFkType $sipNormalizationScriptName = null, $runOnEveryNode = false, \CUCM\StructType\Destinations $destinations = null, $unknownStripDigits = null, \CUCM\StructType\XFkType $cgpnTransformationUnknownCssName = null, $tunneledProtocol = 'None', $asn1RoseOidEncoding = 'No Changes', $qsigVariant = 'No Changes', $pathReplacementSupport = false, $enableQsigUtf8 = false, $scriptParameters = null, $scriptTraceEnabled = false, $trunkTrafficSecure = 'When using both sRTP and TLS', $ctiid = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setDevicePoolName($devicePoolName)
            ->setLocationName($locationName)
            ->setSecurityProfileName($securityProfileName)
            ->setSipProfileName($sipProfileName)
            ->setPresenceGroupName($presenceGroupName)
            ->setDescription($description)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setNetworkLocation($networkLocation)
            ->setMediaResourceListName($mediaResourceListName)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setLoadInformation($loadInformation)
            ->setTraceFlag($traceFlag)
            ->setMlppDomainId($mlppDomainId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setPreemption($preemption)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setRetryVideoCallAsAudio($retryVideoCallAsAudio)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setGeoLocationName($geoLocationName)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setSendGeoLocation($sendGeoLocation)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setUnattendedPort($unattendedPort)
            ->setTransmitUtf8($transmitUtf8)
            ->setSubscribeCallingSearchSpaceName($subscribeCallingSearchSpaceName)
            ->setRerouteCallingSearchSpaceName($rerouteCallingSearchSpaceName)
            ->setReferCallingSearchSpaceName($referCallingSearchSpaceName)
            ->setMtpRequired($mtpRequired)
            ->setUnknownPrefix($unknownPrefix)
            ->setDestinationAddress($destinationAddress)
            ->setDestAddrIsSrv($destAddrIsSrv)
            ->setDestinationport($destinationport)
            ->setTkSipCodec($tkSipCodec)
            ->setSigDigits($sigDigits)
            ->setConnectedNamePresentation($connectedNamePresentation)
            ->setConnectedPartyIdPresentation($connectedPartyIdPresentation)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingname($callingname)
            ->setCallingLineIdPresentation($callingLineIdPresentation)
            ->setPrefixDn($prefixDn)
            ->setCallerName($callerName)
            ->setCallerIdDn($callerIdDn)
            ->setAcceptInboundRdnis($acceptInboundRdnis)
            ->setAcceptOutboundRdnis($acceptOutboundRdnis)
            ->setSrtpAllowed($srtpAllowed)
            ->setSrtpFallbackAllowed($srtpFallbackAllowed)
            ->setIsPaiEnabled($isPaiEnabled)
            ->setSipPrivacy($sipPrivacy)
            ->setIsRpidEnabled($isRpidEnabled)
            ->setSipAssertedType($sipAssertedType)
            ->setDestinationAddressIpv6($destinationAddressIpv6)
            ->setDtmfSignalingMethod($dtmfSignalingMethod)
            ->setRouteClassSignalling($routeClassSignalling)
            ->setSipTrunkType($sipTrunkType)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setUseImePublicIpPort($useImePublicIpPort)
            ->setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss)
            ->setCntdPnTransformationCssName($cntdPnTransformationCssName)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setSipNormalizationScriptName($sipNormalizationScriptName)
            ->setRunOnEveryNode($runOnEveryNode)
            ->setDestinations($destinations)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setCgpnTransformationUnknownCssName($cgpnTransformationUnknownCssName)
            ->setTunneledProtocol($tunneledProtocol)
            ->setAsn1RoseOidEncoding($asn1RoseOidEncoding)
            ->setQsigVariant($qsigVariant)
            ->setPathReplacementSupport($pathReplacementSupport)
            ->setEnableQsigUtf8($enableQsigUtf8)
            ->setScriptParameters($scriptParameters)
            ->setScriptTraceEnabled($scriptTraceEnabled)
            ->setTrunkTrafficSecure($trunkTrafficSecure)
            ->setCtiid($ctiid);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \CUCM\EnumType\XProduct::valueIsValid()
     * @uses \CUCM\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \CUCM\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \CUCM\EnumType\XClass::valueIsValid()
     * @uses \CUCM\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \CUCM\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \CUCM\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \CUCM\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', \CUCM\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \CUCM\EnumType\XProtocolSide::valueIsValid()
     * @uses \CUCM\EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', \CUCM\EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return \CUCM\StructType\XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setDevicePoolName(\CUCM\StructType\XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get locationName value
     * @return \CUCM\StructType\XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \CUCM\StructType\XFkType $locationName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setLocationName(\CUCM\StructType\XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get securityProfileName value
     * @return \CUCM\StructType\XFkType
     */
    public function getSecurityProfileName()
    {
        return $this->securityProfileName;
    }
    /**
     * Set securityProfileName value
     * @param \CUCM\StructType\XFkType $securityProfileName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setSecurityProfileName(\CUCM\StructType\XFkType $securityProfileName = null)
    {
        $this->securityProfileName = $securityProfileName;
        return $this;
    }
    /**
     * Get sipProfileName value
     * @return \CUCM\StructType\XFkType
     */
    public function getSipProfileName()
    {
        return $this->sipProfileName;
    }
    /**
     * Set sipProfileName value
     * @param \CUCM\StructType\XFkType $sipProfileName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setSipProfileName(\CUCM\StructType\XFkType $sipProfileName = null)
    {
        $this->sipProfileName = $sipProfileName;
        return $this;
    }
    /**
     * Get presenceGroupName value
     * @return \CUCM\StructType\XFkType
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setPresenceGroupName(\CUCM\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCallingSearchSpaceName()
    {
        return isset($this->callingSearchSpaceName) ? $this->callingSearchSpaceName : null;
    }
    /**
     * Set callingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setCallingSearchSpaceName(\CUCM\StructType\XFkType $callingSearchSpaceName = null)
    {
        if (is_null($callingSearchSpaceName) || (is_array($callingSearchSpaceName) && empty($callingSearchSpaceName))) {
            unset($this->callingSearchSpaceName);
        } else {
            $this->callingSearchSpaceName = $callingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setCommonDeviceConfigName(\CUCM\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses \CUCM\EnumType\XNetworkLocation::valueIsValid()
     * @uses \CUCM\EnumType\XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', \CUCM\EnumType\XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getMediaResourceListName()
    {
        return isset($this->mediaResourceListName) ? $this->mediaResourceListName : null;
    }
    /**
     * Set mediaResourceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $mediaResourceListName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setMediaResourceListName(\CUCM\StructType\XFkType $mediaResourceListName = null)
    {
        if (is_null($mediaResourceListName) || (is_array($mediaResourceListName) && empty($mediaResourceListName))) {
            unset($this->mediaResourceListName);
        } else {
            $this->mediaResourceListName = $mediaResourceListName;
        }
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return isset($this->networkHoldMohAudioSourceId) ? $this->networkHoldMohAudioSourceId : null;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \CUCM\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSourceId, implode(', ', \CUCM\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($networkHoldMohAudioSourceId) || (is_array($networkHoldMohAudioSourceId) && empty($networkHoldMohAudioSourceId))) {
            unset($this->networkHoldMohAudioSourceId);
        } else {
            $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \CUCM\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', \CUCM\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return isset($this->automatedAlternateRoutingCssName) ? $this->automatedAlternateRoutingCssName : null;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $automatedAlternateRoutingCssName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setAutomatedAlternateRoutingCssName(\CUCM\StructType\XFkType $automatedAlternateRoutingCssName = null)
    {
        if (is_null($automatedAlternateRoutingCssName) || (is_array($automatedAlternateRoutingCssName) && empty($automatedAlternateRoutingCssName))) {
            unset($this->automatedAlternateRoutingCssName);
        } else {
            $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        }
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getAarNeighborhoodName()
    {
        return isset($this->aarNeighborhoodName) ? $this->aarNeighborhoodName : null;
    }
    /**
     * Set aarNeighborhoodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $aarNeighborhoodName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setAarNeighborhoodName(\CUCM\StructType\XFkType $aarNeighborhoodName = null)
    {
        if (is_null($aarNeighborhoodName) || (is_array($aarNeighborhoodName) && empty($aarNeighborhoodName))) {
            unset($this->aarNeighborhoodName);
        } else {
            $this->aarNeighborhoodName = $aarNeighborhoodName;
        }
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses \CUCM\EnumType\XPacketCaptureMode::valueIsValid()
     * @uses \CUCM\EnumType\XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', \CUCM\EnumType\XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setLoadInformation(\CUCM\StructType\XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get traceFlag value
     * @return string|null
     */
    public function getTraceFlag()
    {
        return $this->traceFlag;
    }
    /**
     * Set traceFlag value
     * @param string $traceFlag
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setTraceFlag($traceFlag = null)
    {
        // validation for constraint: pattern
        if (is_scalar($traceFlag) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($traceFlag, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($traceFlag) && !is_string($traceFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($traceFlag)), __LINE__);
        }
        $this->traceFlag = $traceFlag;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = 'Off')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \CUCM\EnumType\XPreemption::valueIsValid()
     * @uses \CUCM\EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setPreemption($preemption = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', \CUCM\EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get retryVideoCallAsAudio value
     * @return string|null
     */
    public function getRetryVideoCallAsAudio()
    {
        return $this->retryVideoCallAsAudio;
    }
    /**
     * Set retryVideoCallAsAudio value
     * @param string $retryVideoCallAsAudio
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setRetryVideoCallAsAudio($retryVideoCallAsAudio = true)
    {
        // validation for constraint: pattern
        if (is_scalar($retryVideoCallAsAudio) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($retryVideoCallAsAudio, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($retryVideoCallAsAudio) && !is_string($retryVideoCallAsAudio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retryVideoCallAsAudio)), __LINE__);
        }
        $this->retryVideoCallAsAudio = $retryVideoCallAsAudio;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCgpnTransformationCssName()
    {
        return isset($this->cgpnTransformationCssName) ? $this->cgpnTransformationCssName : null;
    }
    /**
     * Set cgpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $cgpnTransformationCssName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setCgpnTransformationCssName(\CUCM\StructType\XFkType $cgpnTransformationCssName = null)
    {
        if (is_null($cgpnTransformationCssName) || (is_array($cgpnTransformationCssName) && empty($cgpnTransformationCssName))) {
            unset($this->cgpnTransformationCssName);
        } else {
            $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGeoLocationName()
    {
        return isset($this->geoLocationName) ? $this->geoLocationName : null;
    }
    /**
     * Set geoLocationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $geoLocationName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setGeoLocationName(\CUCM\StructType\XFkType $geoLocationName = null)
    {
        if (is_null($geoLocationName) || (is_array($geoLocationName) && empty($geoLocationName))) {
            unset($this->geoLocationName);
        } else {
            $this->geoLocationName = $geoLocationName;
        }
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $geoLocationFilterName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setGeoLocationFilterName(\CUCM\StructType\XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get sendGeoLocation value
     * @return string|null
     */
    public function getSendGeoLocation()
    {
        return $this->sendGeoLocation;
    }
    /**
     * Set sendGeoLocation value
     * @param string $sendGeoLocation
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setSendGeoLocation($sendGeoLocation = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendGeoLocation) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendGeoLocation, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendGeoLocation) && !is_string($sendGeoLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendGeoLocation)), __LINE__);
        }
        $this->sendGeoLocation = $sendGeoLocation;
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $cdpnTransformationCssName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setCdpnTransformationCssName(\CUCM\StructType\XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get unattendedPort value
     * @return string|null
     */
    public function getUnattendedPort()
    {
        return $this->unattendedPort;
    }
    /**
     * Set unattendedPort value
     * @param string $unattendedPort
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setUnattendedPort($unattendedPort = false)
    {
        // validation for constraint: pattern
        if (is_scalar($unattendedPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($unattendedPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unattendedPort) && !is_string($unattendedPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unattendedPort)), __LINE__);
        }
        $this->unattendedPort = $unattendedPort;
        return $this;
    }
    /**
     * Get transmitUtf8 value
     * @return string|null
     */
    public function getTransmitUtf8()
    {
        return $this->transmitUtf8;
    }
    /**
     * Set transmitUtf8 value
     * @param string $transmitUtf8
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setTransmitUtf8($transmitUtf8 = false)
    {
        // validation for constraint: pattern
        if (is_scalar($transmitUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($transmitUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transmitUtf8) && !is_string($transmitUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transmitUtf8)), __LINE__);
        }
        $this->transmitUtf8 = $transmitUtf8;
        return $this;
    }
    /**
     * Get subscribeCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getSubscribeCallingSearchSpaceName()
    {
        return isset($this->subscribeCallingSearchSpaceName) ? $this->subscribeCallingSearchSpaceName : null;
    }
    /**
     * Set subscribeCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $subscribeCallingSearchSpaceName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setSubscribeCallingSearchSpaceName(\CUCM\StructType\XFkType $subscribeCallingSearchSpaceName = null)
    {
        if (is_null($subscribeCallingSearchSpaceName) || (is_array($subscribeCallingSearchSpaceName) && empty($subscribeCallingSearchSpaceName))) {
            unset($this->subscribeCallingSearchSpaceName);
        } else {
            $this->subscribeCallingSearchSpaceName = $subscribeCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get rerouteCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRerouteCallingSearchSpaceName()
    {
        return isset($this->rerouteCallingSearchSpaceName) ? $this->rerouteCallingSearchSpaceName : null;
    }
    /**
     * Set rerouteCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $rerouteCallingSearchSpaceName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setRerouteCallingSearchSpaceName(\CUCM\StructType\XFkType $rerouteCallingSearchSpaceName = null)
    {
        if (is_null($rerouteCallingSearchSpaceName) || (is_array($rerouteCallingSearchSpaceName) && empty($rerouteCallingSearchSpaceName))) {
            unset($this->rerouteCallingSearchSpaceName);
        } else {
            $this->rerouteCallingSearchSpaceName = $rerouteCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get referCallingSearchSpaceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getReferCallingSearchSpaceName()
    {
        return isset($this->referCallingSearchSpaceName) ? $this->referCallingSearchSpaceName : null;
    }
    /**
     * Set referCallingSearchSpaceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $referCallingSearchSpaceName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setReferCallingSearchSpaceName(\CUCM\StructType\XFkType $referCallingSearchSpaceName = null)
    {
        if (is_null($referCallingSearchSpaceName) || (is_array($referCallingSearchSpaceName) && empty($referCallingSearchSpaceName))) {
            unset($this->referCallingSearchSpaceName);
        } else {
            $this->referCallingSearchSpaceName = $referCallingSearchSpaceName;
        }
        return $this;
    }
    /**
     * Get mtpRequired value
     * @return string|null
     */
    public function getMtpRequired()
    {
        return $this->mtpRequired;
    }
    /**
     * Set mtpRequired value
     * @param string $mtpRequired
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setMtpRequired($mtpRequired = null)
    {
        // validation for constraint: pattern
        if (is_scalar($mtpRequired) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($mtpRequired, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mtpRequired) && !is_string($mtpRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mtpRequired)), __LINE__);
        }
        $this->mtpRequired = $mtpRequired;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($unknownPrefix) && strlen($unknownPrefix) > 16) || (is_array($unknownPrefix) && count($unknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($unknownPrefix) ? strlen($unknownPrefix) : count($unknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unknownPrefix) && !is_string($unknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unknownPrefix)), __LINE__);
        }
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get destinationAddress value
     * @return string|null
     */
    public function getDestinationAddress()
    {
        return $this->destinationAddress;
    }
    /**
     * Set destinationAddress value
     * @param string $destinationAddress
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setDestinationAddress($destinationAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($destinationAddress) && strlen($destinationAddress) > 50) || (is_array($destinationAddress) && count($destinationAddress) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($destinationAddress) ? strlen($destinationAddress) : count($destinationAddress)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destinationAddress) && !is_string($destinationAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationAddress)), __LINE__);
        }
        $this->destinationAddress = $destinationAddress;
        return $this;
    }
    /**
     * Get destAddrIsSrv value
     * @return string|null
     */
    public function getDestAddrIsSrv()
    {
        return $this->destAddrIsSrv;
    }
    /**
     * Set destAddrIsSrv value
     * @param string $destAddrIsSrv
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setDestAddrIsSrv($destAddrIsSrv = null)
    {
        // validation for constraint: pattern
        if (is_scalar($destAddrIsSrv) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $destAddrIsSrv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($destAddrIsSrv, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destAddrIsSrv) && !is_string($destAddrIsSrv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destAddrIsSrv)), __LINE__);
        }
        $this->destAddrIsSrv = $destAddrIsSrv;
        return $this;
    }
    /**
     * Get destinationport value
     * @return string|null
     */
    public function getDestinationport()
    {
        return $this->destinationport;
    }
    /**
     * Set destinationport value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinationport
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setDestinationport($destinationport = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($destinationport)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $destinationport, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->destinationport = $destinationport;
        return $this;
    }
    /**
     * Get tkSipCodec value
     * @return string|null
     */
    public function getTkSipCodec()
    {
        return $this->tkSipCodec;
    }
    /**
     * Set tkSipCodec value
     * @uses \CUCM\EnumType\XSIPCodec::valueIsValid()
     * @uses \CUCM\EnumType\XSIPCodec::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tkSipCodec
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setTkSipCodec($tkSipCodec = '711ulaw')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XSIPCodec::valueIsValid($tkSipCodec)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tkSipCodec, implode(', ', \CUCM\EnumType\XSIPCodec::getValidValues())), __LINE__);
        }
        $this->tkSipCodec = $tkSipCodec;
        return $this;
    }
    /**
     * Get sigDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\SigDigits|null
     */
    public function getSigDigits()
    {
        return isset($this->sigDigits) ? $this->sigDigits : null;
    }
    /**
     * Set sigDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\SigDigits $sigDigits
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setSigDigits(\CUCM\StructType\SigDigits $sigDigits = '99')
    {
        if (is_null($sigDigits) || (is_array($sigDigits) && empty($sigDigits))) {
            unset($this->sigDigits);
        } else {
            $this->sigDigits = $sigDigits;
        }
        return $this;
    }
    /**
     * Get connectedNamePresentation value
     * @return string|null
     */
    public function getConnectedNamePresentation()
    {
        return $this->connectedNamePresentation;
    }
    /**
     * Set connectedNamePresentation value
     * @uses \CUCM\EnumType\XPresentationBit::valueIsValid()
     * @uses \CUCM\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedNamePresentation
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setConnectedNamePresentation($connectedNamePresentation = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPresentationBit::valueIsValid($connectedNamePresentation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectedNamePresentation, implode(', ', \CUCM\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedNamePresentation = $connectedNamePresentation;
        return $this;
    }
    /**
     * Get connectedPartyIdPresentation value
     * @return string|null
     */
    public function getConnectedPartyIdPresentation()
    {
        return $this->connectedPartyIdPresentation;
    }
    /**
     * Set connectedPartyIdPresentation value
     * @uses \CUCM\EnumType\XPresentationBit::valueIsValid()
     * @uses \CUCM\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $connectedPartyIdPresentation
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setConnectedPartyIdPresentation($connectedPartyIdPresentation = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPresentationBit::valueIsValid($connectedPartyIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $connectedPartyIdPresentation, implode(', ', \CUCM\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->connectedPartyIdPresentation = $connectedPartyIdPresentation;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string|null
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses \CUCM\EnumType\XCallingPartySelection::valueIsValid()
     * @uses \CUCM\EnumType\XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setCallingPartySelection($callingPartySelection = 'Originator')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartySelection, implode(', ', \CUCM\EnumType\XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingname value
     * @return string|null
     */
    public function getCallingname()
    {
        return $this->callingname;
    }
    /**
     * Set callingname value
     * @uses \CUCM\EnumType\XPresentationBit::valueIsValid()
     * @uses \CUCM\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingname
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setCallingname($callingname = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPresentationBit::valueIsValid($callingname)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingname, implode(', ', \CUCM\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingname = $callingname;
        return $this;
    }
    /**
     * Get callingLineIdPresentation value
     * @return string|null
     */
    public function getCallingLineIdPresentation()
    {
        return $this->callingLineIdPresentation;
    }
    /**
     * Set callingLineIdPresentation value
     * @uses \CUCM\EnumType\XPresentationBit::valueIsValid()
     * @uses \CUCM\EnumType\XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingLineIdPresentation
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setCallingLineIdPresentation($callingLineIdPresentation = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPresentationBit::valueIsValid($callingLineIdPresentation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingLineIdPresentation, implode(', ', \CUCM\EnumType\XPresentationBit::getValidValues())), __LINE__);
        }
        $this->callingLineIdPresentation = $callingLineIdPresentation;
        return $this;
    }
    /**
     * Get prefixDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrefixDn()
    {
        return isset($this->prefixDn) ? $this->prefixDn : null;
    }
    /**
     * Set prefixDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prefixDn
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setPrefixDn($prefixDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($prefixDn) && strlen($prefixDn) > 50) || (is_array($prefixDn) && count($prefixDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($prefixDn) ? strlen($prefixDn) : count($prefixDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prefixDn) && !is_string($prefixDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefixDn)), __LINE__);
        }
        if (is_null($prefixDn) || (is_array($prefixDn) && empty($prefixDn))) {
            unset($this->prefixDn);
        } else {
            $this->prefixDn = $prefixDn;
        }
        return $this;
    }
    /**
     * Get callerName value
     * @return string|null
     */
    public function getCallerName()
    {
        return $this->callerName;
    }
    /**
     * Set callerName value
     * @param string $callerName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setCallerName($callerName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerName) && strlen($callerName) > 50) || (is_array($callerName) && count($callerName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerName) ? strlen($callerName) : count($callerName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerName) && !is_string($callerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerName)), __LINE__);
        }
        $this->callerName = $callerName;
        return $this;
    }
    /**
     * Get callerIdDn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallerIdDn()
    {
        return isset($this->callerIdDn) ? $this->callerIdDn : null;
    }
    /**
     * Set callerIdDn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $callerIdDn
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDn) && strlen($callerIdDn) > 50) || (is_array($callerIdDn) && count($callerIdDn) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($callerIdDn) ? strlen($callerIdDn) : count($callerIdDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDn)), __LINE__);
        }
        if (is_null($callerIdDn) || (is_array($callerIdDn) && empty($callerIdDn))) {
            unset($this->callerIdDn);
        } else {
            $this->callerIdDn = $callerIdDn;
        }
        return $this;
    }
    /**
     * Get acceptInboundRdnis value
     * @return string|null
     */
    public function getAcceptInboundRdnis()
    {
        return $this->acceptInboundRdnis;
    }
    /**
     * Set acceptInboundRdnis value
     * @param string $acceptInboundRdnis
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setAcceptInboundRdnis($acceptInboundRdnis = null)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptInboundRdnis) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptInboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptInboundRdnis, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptInboundRdnis) && !is_string($acceptInboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptInboundRdnis)), __LINE__);
        }
        $this->acceptInboundRdnis = $acceptInboundRdnis;
        return $this;
    }
    /**
     * Get acceptOutboundRdnis value
     * @return string|null
     */
    public function getAcceptOutboundRdnis()
    {
        return $this->acceptOutboundRdnis;
    }
    /**
     * Set acceptOutboundRdnis value
     * @param string $acceptOutboundRdnis
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setAcceptOutboundRdnis($acceptOutboundRdnis = null)
    {
        // validation for constraint: pattern
        if (is_scalar($acceptOutboundRdnis) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $acceptOutboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($acceptOutboundRdnis, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($acceptOutboundRdnis) && !is_string($acceptOutboundRdnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($acceptOutboundRdnis)), __LINE__);
        }
        $this->acceptOutboundRdnis = $acceptOutboundRdnis;
        return $this;
    }
    /**
     * Get srtpAllowed value
     * @return string|null
     */
    public function getSrtpAllowed()
    {
        return $this->srtpAllowed;
    }
    /**
     * Set srtpAllowed value
     * @param string $srtpAllowed
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setSrtpAllowed($srtpAllowed = false)
    {
        // validation for constraint: pattern
        if (is_scalar($srtpAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($srtpAllowed, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($srtpAllowed) && !is_string($srtpAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srtpAllowed)), __LINE__);
        }
        $this->srtpAllowed = $srtpAllowed;
        return $this;
    }
    /**
     * Get srtpFallbackAllowed value
     * @return string|null
     */
    public function getSrtpFallbackAllowed()
    {
        return $this->srtpFallbackAllowed;
    }
    /**
     * Set srtpFallbackAllowed value
     * @param string $srtpFallbackAllowed
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setSrtpFallbackAllowed($srtpFallbackAllowed = false)
    {
        // validation for constraint: pattern
        if (is_scalar($srtpFallbackAllowed) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $srtpFallbackAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($srtpFallbackAllowed, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($srtpFallbackAllowed) && !is_string($srtpFallbackAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srtpFallbackAllowed)), __LINE__);
        }
        $this->srtpFallbackAllowed = $srtpFallbackAllowed;
        return $this;
    }
    /**
     * Get isPaiEnabled value
     * @return string|null
     */
    public function getIsPaiEnabled()
    {
        return $this->isPaiEnabled;
    }
    /**
     * Set isPaiEnabled value
     * @param string $isPaiEnabled
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setIsPaiEnabled($isPaiEnabled = true)
    {
        // validation for constraint: pattern
        if (is_scalar($isPaiEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isPaiEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isPaiEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isPaiEnabled) && !is_string($isPaiEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isPaiEnabled)), __LINE__);
        }
        $this->isPaiEnabled = $isPaiEnabled;
        return $this;
    }
    /**
     * Get sipPrivacy value
     * @return string|null
     */
    public function getSipPrivacy()
    {
        return $this->sipPrivacy;
    }
    /**
     * Set sipPrivacy value
     * @uses \CUCM\EnumType\XSipPrivacy::valueIsValid()
     * @uses \CUCM\EnumType\XSipPrivacy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPrivacy
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setSipPrivacy($sipPrivacy = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XSipPrivacy::valueIsValid($sipPrivacy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipPrivacy, implode(', ', \CUCM\EnumType\XSipPrivacy::getValidValues())), __LINE__);
        }
        $this->sipPrivacy = $sipPrivacy;
        return $this;
    }
    /**
     * Get isRpidEnabled value
     * @return string|null
     */
    public function getIsRpidEnabled()
    {
        return $this->isRpidEnabled;
    }
    /**
     * Set isRpidEnabled value
     * @param string $isRpidEnabled
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setIsRpidEnabled($isRpidEnabled = true)
    {
        // validation for constraint: pattern
        if (is_scalar($isRpidEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isRpidEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isRpidEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isRpidEnabled) && !is_string($isRpidEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isRpidEnabled)), __LINE__);
        }
        $this->isRpidEnabled = $isRpidEnabled;
        return $this;
    }
    /**
     * Get sipAssertedType value
     * @return string|null
     */
    public function getSipAssertedType()
    {
        return $this->sipAssertedType;
    }
    /**
     * Set sipAssertedType value
     * @uses \CUCM\EnumType\XSipAssertedType::valueIsValid()
     * @uses \CUCM\EnumType\XSipAssertedType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipAssertedType
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setSipAssertedType($sipAssertedType = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XSipAssertedType::valueIsValid($sipAssertedType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipAssertedType, implode(', ', \CUCM\EnumType\XSipAssertedType::getValidValues())), __LINE__);
        }
        $this->sipAssertedType = $sipAssertedType;
        return $this;
    }
    /**
     * Get destinationAddressIpv6 value
     * @return string|null
     */
    public function getDestinationAddressIpv6()
    {
        return $this->destinationAddressIpv6;
    }
    /**
     * Set destinationAddressIpv6 value
     * @param string $destinationAddressIpv6
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setDestinationAddressIpv6($destinationAddressIpv6 = null)
    {
        // validation for constraint: string
        if (!is_null($destinationAddressIpv6) && !is_string($destinationAddressIpv6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destinationAddressIpv6)), __LINE__);
        }
        $this->destinationAddressIpv6 = $destinationAddressIpv6;
        return $this;
    }
    /**
     * Get dtmfSignalingMethod value
     * @return string|null
     */
    public function getDtmfSignalingMethod()
    {
        return $this->dtmfSignalingMethod;
    }
    /**
     * Set dtmfSignalingMethod value
     * @uses \CUCM\EnumType\XDTMFSignaling::valueIsValid()
     * @uses \CUCM\EnumType\XDTMFSignaling::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfSignalingMethod
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setDtmfSignalingMethod($dtmfSignalingMethod = 'No Preference')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDTMFSignaling::valueIsValid($dtmfSignalingMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dtmfSignalingMethod, implode(', ', \CUCM\EnumType\XDTMFSignaling::getValidValues())), __LINE__);
        }
        $this->dtmfSignalingMethod = $dtmfSignalingMethod;
        return $this;
    }
    /**
     * Get routeClassSignalling value
     * @return string|null
     */
    public function getRouteClassSignalling()
    {
        return $this->routeClassSignalling;
    }
    /**
     * Set routeClassSignalling value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeClassSignalling
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setRouteClassSignalling($routeClassSignalling = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($routeClassSignalling)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $routeClassSignalling, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->routeClassSignalling = $routeClassSignalling;
        return $this;
    }
    /**
     * Get sipTrunkType value
     * @return string|null
     */
    public function getSipTrunkType()
    {
        return $this->sipTrunkType;
    }
    /**
     * Set sipTrunkType value
     * @uses \CUCM\EnumType\XTrunkService::valueIsValid()
     * @uses \CUCM\EnumType\XTrunkService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipTrunkType
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setSipTrunkType($sipTrunkType = None(Default))
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTrunkService::valueIsValid($sipTrunkType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipTrunkType, implode(', ', \CUCM\EnumType\XTrunkService::getValidValues())), __LINE__);
        }
        $this->sipTrunkType = $sipTrunkType;
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setPstnAccess($pstnAccess = true)
    {
        // validation for constraint: pattern
        if (is_scalar($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pstnAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnAccess)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return isset($this->imeE164TransformationName) ? $this->imeE164TransformationName : null;
    }
    /**
     * Set imeE164TransformationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $imeE164TransformationName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setImeE164TransformationName(\CUCM\StructType\XFkType $imeE164TransformationName = null)
    {
        if (is_null($imeE164TransformationName) || (is_array($imeE164TransformationName) && empty($imeE164TransformationName))) {
            unset($this->imeE164TransformationName);
        } else {
            $this->imeE164TransformationName = $imeE164TransformationName;
        }
        return $this;
    }
    /**
     * Get useImePublicIpPort value
     * @return string|null
     */
    public function getUseImePublicIpPort()
    {
        return $this->useImePublicIpPort;
    }
    /**
     * Set useImePublicIpPort value
     * @param string $useImePublicIpPort
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setUseImePublicIpPort($useImePublicIpPort = false)
    {
        // validation for constraint: pattern
        if (is_scalar($useImePublicIpPort) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useImePublicIpPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useImePublicIpPort, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useImePublicIpPort) && !is_string($useImePublicIpPort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useImePublicIpPort)), __LINE__);
        }
        $this->useImePublicIpPort = $useImePublicIpPort;
        return $this;
    }
    /**
     * Get useDevicePoolCntdPnTransformationCss value
     * @return string|null
     */
    public function getUseDevicePoolCntdPnTransformationCss()
    {
        return $this->useDevicePoolCntdPnTransformationCss;
    }
    /**
     * Set useDevicePoolCntdPnTransformationCss value
     * @param string $useDevicePoolCntdPnTransformationCss
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setUseDevicePoolCntdPnTransformationCss($useDevicePoolCntdPnTransformationCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCntdPnTransformationCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCntdPnTransformationCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCntdPnTransformationCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCntdPnTransformationCss) && !is_string($useDevicePoolCntdPnTransformationCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCntdPnTransformationCss)), __LINE__);
        }
        $this->useDevicePoolCntdPnTransformationCss = $useDevicePoolCntdPnTransformationCss;
        return $this;
    }
    /**
     * Get cntdPnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCntdPnTransformationCssName()
    {
        return isset($this->cntdPnTransformationCssName) ? $this->cntdPnTransformationCssName : null;
    }
    /**
     * Set cntdPnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $cntdPnTransformationCssName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setCntdPnTransformationCssName(\CUCM\StructType\XFkType $cntdPnTransformationCssName = null)
    {
        if (is_null($cntdPnTransformationCssName) || (is_array($cntdPnTransformationCssName) && empty($cntdPnTransformationCssName))) {
            unset($this->cntdPnTransformationCssName);
        } else {
            $this->cntdPnTransformationCssName = $cntdPnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssUnkn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !is_string($useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssUnkn)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get sipNormalizationScriptName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getSipNormalizationScriptName()
    {
        return isset($this->sipNormalizationScriptName) ? $this->sipNormalizationScriptName : null;
    }
    /**
     * Set sipNormalizationScriptName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $sipNormalizationScriptName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setSipNormalizationScriptName(\CUCM\StructType\XFkType $sipNormalizationScriptName = null)
    {
        if (is_null($sipNormalizationScriptName) || (is_array($sipNormalizationScriptName) && empty($sipNormalizationScriptName))) {
            unset($this->sipNormalizationScriptName);
        } else {
            $this->sipNormalizationScriptName = $sipNormalizationScriptName;
        }
        return $this;
    }
    /**
     * Get runOnEveryNode value
     * @return string|null
     */
    public function getRunOnEveryNode()
    {
        return $this->runOnEveryNode;
    }
    /**
     * Set runOnEveryNode value
     * @param string $runOnEveryNode
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setRunOnEveryNode($runOnEveryNode = false)
    {
        // validation for constraint: pattern
        if (is_scalar($runOnEveryNode) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($runOnEveryNode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($runOnEveryNode) && !is_string($runOnEveryNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($runOnEveryNode)), __LINE__);
        }
        $this->runOnEveryNode = $runOnEveryNode;
        return $this;
    }
    /**
     * Get destinations value
     * @return \CUCM\StructType\Destinations|null
     */
    public function getDestinations()
    {
        return $this->destinations;
    }
    /**
     * Set destinations value
     * @param \CUCM\StructType\Destinations $destinations
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setDestinations(\CUCM\StructType\Destinations $destinations = null)
    {
        $this->destinations = $destinations;
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUnknownStripDigits()
    {
        return isset($this->unknownStripDigits) ? $this->unknownStripDigits : null;
    }
    /**
     * Set unknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $unknownStripDigits
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        // validation for constraint: int
        if (!is_null($unknownStripDigits) && !is_numeric($unknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unknownStripDigits)), __LINE__);
        }
        if (is_null($unknownStripDigits) || (is_array($unknownStripDigits) && empty($unknownStripDigits))) {
            unset($this->unknownStripDigits);
        } else {
            $this->unknownStripDigits = $unknownStripDigits;
        }
        return $this;
    }
    /**
     * Get cgpnTransformationUnknownCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCgpnTransformationUnknownCssName()
    {
        return isset($this->cgpnTransformationUnknownCssName) ? $this->cgpnTransformationUnknownCssName : null;
    }
    /**
     * Set cgpnTransformationUnknownCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $cgpnTransformationUnknownCssName
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setCgpnTransformationUnknownCssName(\CUCM\StructType\XFkType $cgpnTransformationUnknownCssName = null)
    {
        if (is_null($cgpnTransformationUnknownCssName) || (is_array($cgpnTransformationUnknownCssName) && empty($cgpnTransformationUnknownCssName))) {
            unset($this->cgpnTransformationUnknownCssName);
        } else {
            $this->cgpnTransformationUnknownCssName = $cgpnTransformationUnknownCssName;
        }
        return $this;
    }
    /**
     * Get tunneledProtocol value
     * @return string|null
     */
    public function getTunneledProtocol()
    {
        return $this->tunneledProtocol;
    }
    /**
     * Set tunneledProtocol value
     * @uses \CUCM\EnumType\XTunneledProtocol::valueIsValid()
     * @uses \CUCM\EnumType\XTunneledProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tunneledProtocol
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setTunneledProtocol($tunneledProtocol = 'None')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTunneledProtocol::valueIsValid($tunneledProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tunneledProtocol, implode(', ', \CUCM\EnumType\XTunneledProtocol::getValidValues())), __LINE__);
        }
        $this->tunneledProtocol = $tunneledProtocol;
        return $this;
    }
    /**
     * Get asn1RoseOidEncoding value
     * @return string|null
     */
    public function getAsn1RoseOidEncoding()
    {
        return $this->asn1RoseOidEncoding;
    }
    /**
     * Set asn1RoseOidEncoding value
     * @uses \CUCM\EnumType\XASN1RoseOidEncoding::valueIsValid()
     * @uses \CUCM\EnumType\XASN1RoseOidEncoding::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $asn1RoseOidEncoding
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setAsn1RoseOidEncoding($asn1RoseOidEncoding = 'No Changes')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XASN1RoseOidEncoding::valueIsValid($asn1RoseOidEncoding)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $asn1RoseOidEncoding, implode(', ', \CUCM\EnumType\XASN1RoseOidEncoding::getValidValues())), __LINE__);
        }
        $this->asn1RoseOidEncoding = $asn1RoseOidEncoding;
        return $this;
    }
    /**
     * Get qsigVariant value
     * @return string|null
     */
    public function getQsigVariant()
    {
        return $this->qsigVariant;
    }
    /**
     * Set qsigVariant value
     * @uses \CUCM\EnumType\XQSIGVariant::valueIsValid()
     * @uses \CUCM\EnumType\XQSIGVariant::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qsigVariant
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setQsigVariant($qsigVariant = 'No Changes')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XQSIGVariant::valueIsValid($qsigVariant)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qsigVariant, implode(', ', \CUCM\EnumType\XQSIGVariant::getValidValues())), __LINE__);
        }
        $this->qsigVariant = $qsigVariant;
        return $this;
    }
    /**
     * Get pathReplacementSupport value
     * @return string|null
     */
    public function getPathReplacementSupport()
    {
        return $this->pathReplacementSupport;
    }
    /**
     * Set pathReplacementSupport value
     * @param string $pathReplacementSupport
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setPathReplacementSupport($pathReplacementSupport = false)
    {
        // validation for constraint: pattern
        if (is_scalar($pathReplacementSupport) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pathReplacementSupport, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pathReplacementSupport) && !is_string($pathReplacementSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pathReplacementSupport)), __LINE__);
        }
        $this->pathReplacementSupport = $pathReplacementSupport;
        return $this;
    }
    /**
     * Get enableQsigUtf8 value
     * @return string|null
     */
    public function getEnableQsigUtf8()
    {
        return $this->enableQsigUtf8;
    }
    /**
     * Set enableQsigUtf8 value
     * @param string $enableQsigUtf8
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setEnableQsigUtf8($enableQsigUtf8 = false)
    {
        // validation for constraint: pattern
        if (is_scalar($enableQsigUtf8) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableQsigUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableQsigUtf8, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableQsigUtf8) && !is_string($enableQsigUtf8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableQsigUtf8)), __LINE__);
        }
        $this->enableQsigUtf8 = $enableQsigUtf8;
        return $this;
    }
    /**
     * Get scriptParameters value
     * @return string|null
     */
    public function getScriptParameters()
    {
        return $this->scriptParameters;
    }
    /**
     * Set scriptParameters value
     * @param string $scriptParameters
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setScriptParameters($scriptParameters = null)
    {
        // validation for constraint: string
        if (!is_null($scriptParameters) && !is_string($scriptParameters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scriptParameters)), __LINE__);
        }
        $this->scriptParameters = $scriptParameters;
        return $this;
    }
    /**
     * Get scriptTraceEnabled value
     * @return string|null
     */
    public function getScriptTraceEnabled()
    {
        return $this->scriptTraceEnabled;
    }
    /**
     * Set scriptTraceEnabled value
     * @param string $scriptTraceEnabled
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setScriptTraceEnabled($scriptTraceEnabled = false)
    {
        // validation for constraint: pattern
        if (is_scalar($scriptTraceEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $scriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($scriptTraceEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($scriptTraceEnabled) && !is_string($scriptTraceEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scriptTraceEnabled)), __LINE__);
        }
        $this->scriptTraceEnabled = $scriptTraceEnabled;
        return $this;
    }
    /**
     * Get trunkTrafficSecure value
     * @return string|null
     */
    public function getTrunkTrafficSecure()
    {
        return $this->trunkTrafficSecure;
    }
    /**
     * Set trunkTrafficSecure value
     * @uses \CUCM\EnumType\XSIPTrunkCallLegSecurity::valueIsValid()
     * @uses \CUCM\EnumType\XSIPTrunkCallLegSecurity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $trunkTrafficSecure
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setTrunkTrafficSecure($trunkTrafficSecure = 'When using both sRTP and TLS')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XSIPTrunkCallLegSecurity::valueIsValid($trunkTrafficSecure)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $trunkTrafficSecure, implode(', ', \CUCM\EnumType\XSIPTrunkCallLegSecurity::getValidValues())), __LINE__);
        }
        $this->trunkTrafficSecure = $trunkTrafficSecure;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return \CUCM\StructType\XSipTrunk
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XSipTrunk
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
