<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRecordingProfile StructType
 * @subpackage Structs
 */
class XRecordingProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The recorderDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $recorderDestination;
    /**
     * The recordingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $recordingCssName;
    /**
     * Constructor method for XRecordingProfile
     * @uses XRecordingProfile::setName()
     * @uses XRecordingProfile::setRecorderDestination()
     * @uses XRecordingProfile::setRecordingCssName()
     * @param string $name
     * @param string $recorderDestination
     * @param \CUCM\StructType\XFkType $recordingCssName
     */
    public function __construct($name = null, $recorderDestination = null, \CUCM\StructType\XFkType $recordingCssName = null)
    {
        $this
            ->setName($name)
            ->setRecorderDestination($recorderDestination)
            ->setRecordingCssName($recordingCssName);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\XRecordingProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get recorderDestination value
     * @return string
     */
    public function getRecorderDestination()
    {
        return $this->recorderDestination;
    }
    /**
     * Set recorderDestination value
     * @param string $recorderDestination
     * @return \CUCM\StructType\XRecordingProfile
     */
    public function setRecorderDestination($recorderDestination = null)
    {
        // validation for constraint: string
        if (!is_null($recorderDestination) && !is_string($recorderDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recorderDestination)), __LINE__);
        }
        $this->recorderDestination = $recorderDestination;
        return $this;
    }
    /**
     * Get recordingCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRecordingCssName()
    {
        return isset($this->recordingCssName) ? $this->recordingCssName : null;
    }
    /**
     * Set recordingCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $recordingCssName
     * @return \CUCM\StructType\XRecordingProfile
     */
    public function setRecordingCssName(\CUCM\StructType\XFkType $recordingCssName = null)
    {
        if (is_null($recordingCssName) || (is_array($recordingCssName) && empty($recordingCssName))) {
            unset($this->recordingCssName);
        } else {
            $this->recordingCssName = $recordingCssName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XRecordingProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
