<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XPresenceGroupMember StructType
 * @subpackage Structs
 */
class XPresenceGroupMember extends AbstractStructBase
{
    /**
     * The presenceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \CUCM\StructType\XFkType
     */
    public $presenceGroupName;
    /**
     * The subscriptionPermission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $subscriptionPermission;
    /**
     * Constructor method for XPresenceGroupMember
     * @uses XPresenceGroupMember::setPresenceGroupName()
     * @uses XPresenceGroupMember::setSubscriptionPermission()
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @param string $subscriptionPermission
     */
    public function __construct(\CUCM\StructType\XFkType $presenceGroupName = null, $subscriptionPermission = null)
    {
        $this
            ->setPresenceGroupName($presenceGroupName)
            ->setSubscriptionPermission($subscriptionPermission);
    }
    /**
     * Get presenceGroupName value
     * @return \CUCM\StructType\XFkType
     */
    public function getPresenceGroupName()
    {
        return $this->presenceGroupName;
    }
    /**
     * Set presenceGroupName value
     * @param \CUCM\StructType\XFkType $presenceGroupName
     * @return \CUCM\StructType\XPresenceGroupMember
     */
    public function setPresenceGroupName(\CUCM\StructType\XFkType $presenceGroupName = null)
    {
        $this->presenceGroupName = $presenceGroupName;
        return $this;
    }
    /**
     * Get subscriptionPermission value
     * @return string
     */
    public function getSubscriptionPermission()
    {
        return $this->subscriptionPermission;
    }
    /**
     * Set subscriptionPermission value
     * @uses \CUCM\EnumType\XMatrixValue::valueIsValid()
     * @uses \CUCM\EnumType\XMatrixValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriptionPermission
     * @return \CUCM\StructType\XPresenceGroupMember
     */
    public function setSubscriptionPermission($subscriptionPermission = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMatrixValue::valueIsValid($subscriptionPermission)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subscriptionPermission, implode(', ', \CUCM\EnumType\XMatrixValue::getValidValues())), __LINE__);
        }
        $this->subscriptionPermission = $subscriptionPermission;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XPresenceGroupMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
