<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XMobilityProfile StructType
 * @subpackage Structs
 */
class XMobilityProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The mobileClientCallingOption
     * Meta informations extracted from the WSDL
     * - default: Dial via Office Reverse
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $mobileClientCallingOption;
    /**
     * The dvofServiceAccessNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dvofServiceAccessNumber;
    /**
     * The dirn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XDirn
     */
    public $dirn;
    /**
     * The dvorCallerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dvorCallerId;
    /**
     * Constructor method for XMobilityProfile
     * @uses XMobilityProfile::setName()
     * @uses XMobilityProfile::setDescription()
     * @uses XMobilityProfile::setMobileClientCallingOption()
     * @uses XMobilityProfile::setDvofServiceAccessNumber()
     * @uses XMobilityProfile::setDirn()
     * @uses XMobilityProfile::setDvorCallerId()
     * @param string $name
     * @param string $description
     * @param string $mobileClientCallingOption
     * @param string $dvofServiceAccessNumber
     * @param \CUCM\StructType\XDirn $dirn
     * @param string $dvorCallerId
     */
    public function __construct($name = null, $description = null, $mobileClientCallingOption = 'Dial via Office Reverse', $dvofServiceAccessNumber = null, \CUCM\StructType\XDirn $dirn = null, $dvorCallerId = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setMobileClientCallingOption($mobileClientCallingOption)
            ->setDvofServiceAccessNumber($dvofServiceAccessNumber)
            ->setDirn($dirn)
            ->setDvorCallerId($dvorCallerId);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\XMobilityProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\XMobilityProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mobileClientCallingOption value
     * @return string|null
     */
    public function getMobileClientCallingOption()
    {
        return $this->mobileClientCallingOption;
    }
    /**
     * Set mobileClientCallingOption value
     * @uses \CUCM\EnumType\XDialViaOffice::valueIsValid()
     * @uses \CUCM\EnumType\XDialViaOffice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mobileClientCallingOption
     * @return \CUCM\StructType\XMobilityProfile
     */
    public function setMobileClientCallingOption($mobileClientCallingOption = 'Dial via Office Reverse')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDialViaOffice::valueIsValid($mobileClientCallingOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mobileClientCallingOption, implode(', ', \CUCM\EnumType\XDialViaOffice::getValidValues())), __LINE__);
        }
        $this->mobileClientCallingOption = $mobileClientCallingOption;
        return $this;
    }
    /**
     * Get dvofServiceAccessNumber value
     * @return string|null
     */
    public function getDvofServiceAccessNumber()
    {
        return $this->dvofServiceAccessNumber;
    }
    /**
     * Set dvofServiceAccessNumber value
     * @param string $dvofServiceAccessNumber
     * @return \CUCM\StructType\XMobilityProfile
     */
    public function setDvofServiceAccessNumber($dvofServiceAccessNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dvofServiceAccessNumber) && !is_string($dvofServiceAccessNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dvofServiceAccessNumber)), __LINE__);
        }
        $this->dvofServiceAccessNumber = $dvofServiceAccessNumber;
        return $this;
    }
    /**
     * Get dirn value
     * @return \CUCM\StructType\XDirn|null
     */
    public function getDirn()
    {
        return $this->dirn;
    }
    /**
     * Set dirn value
     * @param \CUCM\StructType\XDirn $dirn
     * @return \CUCM\StructType\XMobilityProfile
     */
    public function setDirn(\CUCM\StructType\XDirn $dirn = null)
    {
        $this->dirn = $dirn;
        return $this;
    }
    /**
     * Get dvorCallerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDvorCallerId()
    {
        return isset($this->dvorCallerId) ? $this->dvorCallerId : null;
    }
    /**
     * Set dvorCallerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dvorCallerId
     * @return \CUCM\StructType\XMobilityProfile
     */
    public function setDvorCallerId($dvorCallerId = null)
    {
        // validation for constraint: string
        if (!is_null($dvorCallerId) && !is_string($dvorCallerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dvorCallerId)), __LINE__);
        }
        if (is_null($dvorCallerId) || (is_array($dvorCallerId) && empty($dvorCallerId))) {
            unset($this->dvorCallerId);
        } else {
            $this->dvorCallerId = $dvorCallerId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XMobilityProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
