<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XMediaResourceListMember StructType
 * @subpackage Structs
 */
class XMediaResourceListMember extends AbstractStructBase
{
    /**
     * The mediaResourceGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \CUCM\StructType\XFkType
     */
    public $mediaResourceGroupName;
    /**
     * The order
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $order;
    /**
     * Constructor method for XMediaResourceListMember
     * @uses XMediaResourceListMember::setMediaResourceGroupName()
     * @uses XMediaResourceListMember::setOrder()
     * @param \CUCM\StructType\XFkType $mediaResourceGroupName
     * @param string $order
     */
    public function __construct(\CUCM\StructType\XFkType $mediaResourceGroupName = null, $order = null)
    {
        $this
            ->setMediaResourceGroupName($mediaResourceGroupName)
            ->setOrder($order);
    }
    /**
     * Get mediaResourceGroupName value
     * @return \CUCM\StructType\XFkType
     */
    public function getMediaResourceGroupName()
    {
        return $this->mediaResourceGroupName;
    }
    /**
     * Set mediaResourceGroupName value
     * @param \CUCM\StructType\XFkType $mediaResourceGroupName
     * @return \CUCM\StructType\XMediaResourceListMember
     */
    public function setMediaResourceGroupName(\CUCM\StructType\XFkType $mediaResourceGroupName = null)
    {
        $this->mediaResourceGroupName = $mediaResourceGroupName;
        return $this;
    }
    /**
     * Get order value
     * @return string
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $order
     * @return \CUCM\StructType\XMediaResourceListMember
     */
    public function setOrder($order = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($order)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $order, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XMediaResourceListMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
