<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XImeEnrolledPattern StructType
 * @subpackage Structs
 */
class XImeEnrolledPattern extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $pattern;
    /**
     * The imeEnrolledPatternGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $imeEnrolledPatternGroupName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * Constructor method for XImeEnrolledPattern
     * @uses XImeEnrolledPattern::setPattern()
     * @uses XImeEnrolledPattern::setImeEnrolledPatternGroupName()
     * @uses XImeEnrolledPattern::setDescription()
     * @param string $pattern
     * @param \CUCM\StructType\XFkType $imeEnrolledPatternGroupName
     * @param string $description
     */
    public function __construct($pattern = null, \CUCM\StructType\XFkType $imeEnrolledPatternGroupName = null, $description = null)
    {
        $this
            ->setPattern($pattern)
            ->setImeEnrolledPatternGroupName($imeEnrolledPatternGroupName)
            ->setDescription($description);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \CUCM\StructType\XImeEnrolledPattern
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pattern) && strlen($pattern) > 16) || (is_array($pattern) && count($pattern) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($pattern) ? strlen($pattern) : count($pattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get imeEnrolledPatternGroupName value
     * @return \CUCM\StructType\XFkType
     */
    public function getImeEnrolledPatternGroupName()
    {
        return $this->imeEnrolledPatternGroupName;
    }
    /**
     * Set imeEnrolledPatternGroupName value
     * @param \CUCM\StructType\XFkType $imeEnrolledPatternGroupName
     * @return \CUCM\StructType\XImeEnrolledPattern
     */
    public function setImeEnrolledPatternGroupName(\CUCM\StructType\XFkType $imeEnrolledPatternGroupName = null)
    {
        $this->imeEnrolledPatternGroupName = $imeEnrolledPatternGroupName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\XImeEnrolledPattern
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XImeEnrolledPattern
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
