<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XHuntList StructType
 * @subpackage Structs
 */
class XHuntList extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The callManagerGroupName
     * Meta informations extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The routeListEnabled
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $routeListEnabled;
    /**
     * The voiceMailUsage
     * Meta informations extracted from the WSDL
     * - default: false
     * - documentation: From Device table.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $voiceMailUsage;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Members
     */
    public $members;
    /**
     * Constructor method for XHuntList
     * @uses XHuntList::setName()
     * @uses XHuntList::setCallManagerGroupName()
     * @uses XHuntList::setDescription()
     * @uses XHuntList::setRouteListEnabled()
     * @uses XHuntList::setVoiceMailUsage()
     * @uses XHuntList::setMembers()
     * @param string $name
     * @param \CUCM\StructType\XFkType $callManagerGroupName
     * @param string $description
     * @param string $routeListEnabled
     * @param string $voiceMailUsage
     * @param \CUCM\StructType\Members $members
     */
    public function __construct($name = null, \CUCM\StructType\XFkType $callManagerGroupName = null, $description = null, $routeListEnabled = false, $voiceMailUsage = false, \CUCM\StructType\Members $members = null)
    {
        $this
            ->setName($name)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setDescription($description)
            ->setRouteListEnabled($routeListEnabled)
            ->setVoiceMailUsage($voiceMailUsage)
            ->setMembers($members);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\XHuntList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return \CUCM\StructType\XFkType
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param \CUCM\StructType\XFkType $callManagerGroupName
     * @return \CUCM\StructType\XHuntList
     */
    public function setCallManagerGroupName(\CUCM\StructType\XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\XHuntList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get routeListEnabled value
     * @return string|null
     */
    public function getRouteListEnabled()
    {
        return $this->routeListEnabled;
    }
    /**
     * Set routeListEnabled value
     * @param string $routeListEnabled
     * @return \CUCM\StructType\XHuntList
     */
    public function setRouteListEnabled($routeListEnabled = false)
    {
        // validation for constraint: pattern
        if (is_scalar($routeListEnabled) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($routeListEnabled, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($routeListEnabled) && !is_string($routeListEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeListEnabled)), __LINE__);
        }
        $this->routeListEnabled = $routeListEnabled;
        return $this;
    }
    /**
     * Get voiceMailUsage value
     * @return string|null
     */
    public function getVoiceMailUsage()
    {
        return $this->voiceMailUsage;
    }
    /**
     * Set voiceMailUsage value
     * @param string $voiceMailUsage
     * @return \CUCM\StructType\XHuntList
     */
    public function setVoiceMailUsage($voiceMailUsage = false)
    {
        // validation for constraint: pattern
        if (is_scalar($voiceMailUsage) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $voiceMailUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($voiceMailUsage, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($voiceMailUsage) && !is_string($voiceMailUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voiceMailUsage)), __LINE__);
        }
        $this->voiceMailUsage = $voiceMailUsage;
        return $this;
    }
    /**
     * Get members value
     * @return \CUCM\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \CUCM\StructType\Members $members
     * @return \CUCM\StructType\XHuntList
     */
    public function setMembers(\CUCM\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XHuntList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
