<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XHuntForwardInfoBusy StructType
 * @subpackage Structs
 */
class XHuntForwardInfoBusy extends AbstractStructBase
{
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The usePersonalPreferences
     * Meta informations extracted from the WSDL
     * - documentation: Use original Called DN forward no-coverage settings
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $usePersonalPreferences;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $destination;
    /**
     * The maxHuntduration
     * Meta informations extracted from the WSDL
     * - documentation: Value "-1" in the response means no value has been assigned and internally the CM will use default setting i.e., 1800s.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $maxHuntduration;
    /**
     * Constructor method for XHuntForwardInfoBusy
     * @uses XHuntForwardInfoBusy::setCallingSearchSpaceName()
     * @uses XHuntForwardInfoBusy::setUsePersonalPreferences()
     * @uses XHuntForwardInfoBusy::setDestination()
     * @uses XHuntForwardInfoBusy::setMaxHuntduration()
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @param string $usePersonalPreferences
     * @param string $destination
     * @param string $maxHuntduration
     */
    public function __construct(\CUCM\StructType\XFkType $callingSearchSpaceName = null, $usePersonalPreferences = null, $destination = null, $maxHuntduration = null)
    {
        $this
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setUsePersonalPreferences($usePersonalPreferences)
            ->setDestination($destination)
            ->setMaxHuntduration($maxHuntduration);
    }
    /**
     * Get callingSearchSpaceName value
     * @return \CUCM\StructType\XFkType
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @return \CUCM\StructType\XHuntForwardInfoBusy
     */
    public function setCallingSearchSpaceName(\CUCM\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get usePersonalPreferences value
     * @return string|null
     */
    public function getUsePersonalPreferences()
    {
        return $this->usePersonalPreferences;
    }
    /**
     * Set usePersonalPreferences value
     * @param string $usePersonalPreferences
     * @return \CUCM\StructType\XHuntForwardInfoBusy
     */
    public function setUsePersonalPreferences($usePersonalPreferences = null)
    {
        // validation for constraint: pattern
        if (is_scalar($usePersonalPreferences) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $usePersonalPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($usePersonalPreferences, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($usePersonalPreferences) && !is_string($usePersonalPreferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usePersonalPreferences)), __LINE__);
        }
        $this->usePersonalPreferences = $usePersonalPreferences;
        return $this;
    }
    /**
     * Get destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->destination) ? $this->destination : null;
    }
    /**
     * Set destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return \CUCM\StructType\XHuntForwardInfoBusy
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($destination) && strlen($destination) > 50) || (is_array($destination) && count($destination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($destination) ? strlen($destination) : count($destination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->destination);
        } else {
            $this->destination = $destination;
        }
        return $this;
    }
    /**
     * Get maxHuntduration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaxHuntduration()
    {
        return isset($this->maxHuntduration) ? $this->maxHuntduration : null;
    }
    /**
     * Set maxHuntduration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maxHuntduration
     * @return \CUCM\StructType\XHuntForwardInfoBusy
     */
    public function setMaxHuntduration($maxHuntduration = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($maxHuntduration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maxHuntduration, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($maxHuntduration) || (is_array($maxHuntduration) && empty($maxHuntduration))) {
            unset($this->maxHuntduration);
        } else {
            $this->maxHuntduration = $maxHuntduration;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XHuntForwardInfoBusy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
