<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XGateway StructType
 * @subpackage Structs
 */
class XGateway extends AbstractStructBase
{
    /**
     * The domainName
     * Meta informations extracted from the WSDL
     * - documentation: For SCCP mention MAC Address
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $domainName;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - default: Cisco VG200
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $product;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - default: MGCP
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The callManagerGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $callManagerGroupName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The units
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Units
     */
    public $units;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * Constructor method for XGateway
     * @uses XGateway::setDomainName()
     * @uses XGateway::setProduct()
     * @uses XGateway::setProtocol()
     * @uses XGateway::setCallManagerGroupName()
     * @uses XGateway::setDescription()
     * @uses XGateway::setUnits()
     * @uses XGateway::setVendorConfig()
     * @param string $domainName
     * @param string $product
     * @param string $protocol
     * @param \CUCM\StructType\XFkType $callManagerGroupName
     * @param string $description
     * @param \CUCM\StructType\Units $units
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     */
    public function __construct($domainName = null, $product = 'Cisco VG200', $protocol = 'MGCP', \CUCM\StructType\XFkType $callManagerGroupName = null, $description = null, \CUCM\StructType\Units $units = null, \CUCM\StructType\XVendorConfig $vendorConfig = null)
    {
        $this
            ->setDomainName($domainName)
            ->setProduct($product)
            ->setProtocol($protocol)
            ->setCallManagerGroupName($callManagerGroupName)
            ->setDescription($description)
            ->setUnits($units)
            ->setVendorConfig($vendorConfig);
    }
    /**
     * Get domainName value
     * @return string
     */
    public function getDomainName()
    {
        return $this->domainName;
    }
    /**
     * Set domainName value
     * @param string $domainName
     * @return \CUCM\StructType\XGateway
     */
    public function setDomainName($domainName = null)
    {
        // validation for constraint: string
        if (!is_null($domainName) && !is_string($domainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domainName)), __LINE__);
        }
        $this->domainName = $domainName;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \CUCM\EnumType\XProduct::valueIsValid()
     * @uses \CUCM\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \CUCM\StructType\XGateway
     */
    public function setProduct($product = 'Cisco VG200')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \CUCM\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \CUCM\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \CUCM\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \CUCM\StructType\XGateway
     */
    public function setProtocol($protocol = 'MGCP')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', \CUCM\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get callManagerGroupName value
     * @return \CUCM\StructType\XFkType
     */
    public function getCallManagerGroupName()
    {
        return $this->callManagerGroupName;
    }
    /**
     * Set callManagerGroupName value
     * @param \CUCM\StructType\XFkType $callManagerGroupName
     * @return \CUCM\StructType\XGateway
     */
    public function setCallManagerGroupName(\CUCM\StructType\XFkType $callManagerGroupName = null)
    {
        $this->callManagerGroupName = $callManagerGroupName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\XGateway
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get units value
     * @return \CUCM\StructType\Units|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \CUCM\StructType\Units $units
     * @return \CUCM\StructType\XGateway
     */
    public function setUnits(\CUCM\StructType\Units $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Get vendorConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return isset($this->vendorConfig) ? $this->vendorConfig : null;
    }
    /**
     * Set vendorConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @return \CUCM\StructType\XGateway
     */
    public function setVendorConfig(\CUCM\StructType\XVendorConfig $vendorConfig = null)
    {
        if (is_null($vendorConfig) || (is_array($vendorConfig) && empty($vendorConfig))) {
            unset($this->vendorConfig);
        } else {
            $this->vendorConfig = $vendorConfig;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XGateway
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
