<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XFeatureControlPolicy StructType
 * @subpackage Structs
 */
class XFeatureControlPolicy extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 100
     * @var string
     */
    public $description;
    /**
     * The features
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Features
     */
    public $features;
    /**
     * Constructor method for XFeatureControlPolicy
     * @uses XFeatureControlPolicy::setName()
     * @uses XFeatureControlPolicy::setDescription()
     * @uses XFeatureControlPolicy::setFeatures()
     * @param string $name
     * @param string $description
     * @param \CUCM\StructType\Features $features
     */
    public function __construct($name = null, $description = null, \CUCM\StructType\Features $features = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setFeatures($features);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\XFeatureControlPolicy
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\XFeatureControlPolicy
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 100) || (is_array($description) && count($description) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get features value
     * @return \CUCM\StructType\Features|null
     */
    public function getFeatures()
    {
        return $this->features;
    }
    /**
     * Set features value
     * @param \CUCM\StructType\Features $features
     * @return \CUCM\StructType\XFeatureControlPolicy
     */
    public function setFeatures(\CUCM\StructType\Features $features = null)
    {
        $this->features = $features;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XFeatureControlPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
