<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XFallbackProfile StructType
 * @subpackage Structs
 */
class XFallbackProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The callCss
     * Meta informations extracted from the WSDL
     * - default: Calling device AAR Calling Search Space
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $callCss;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The advertisedFallbackDirectoryE164Number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $advertisedFallbackDirectoryE164Number;
    /**
     * The qosSensistivityLevel
     * Meta informations extracted from the WSDL
     * - default: 3
     * - documentation: The Fallback QOS Sensitivity should be in range 1 to 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $qosSensistivityLevel;
    /**
     * The callAnswerTimer
     * Meta informations extracted from the WSDL
     * - default: 6
     * - documentation: The Fallback Call Answer Timer should be in range 1 to 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $callAnswerTimer;
    /**
     * The directoryNumberPartition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $directoryNumberPartition;
    /**
     * The directoryNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 16
     * @var string
     */
    public $directoryNumber;
    /**
     * The numberOfDigitsForCallerIDPartialMatch
     * Meta informations extracted from the WSDL
     * - default: 5
     * - documentation: The number of digits for Caller ID partial match should be in range 4 to 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $numberOfDigitsForCallerIDPartialMatch;
    /**
     * Constructor method for XFallbackProfile
     * @uses XFallbackProfile::setName()
     * @uses XFallbackProfile::setCallCss()
     * @uses XFallbackProfile::setDescription()
     * @uses XFallbackProfile::setAdvertisedFallbackDirectoryE164Number()
     * @uses XFallbackProfile::setQosSensistivityLevel()
     * @uses XFallbackProfile::setCallAnswerTimer()
     * @uses XFallbackProfile::setDirectoryNumberPartition()
     * @uses XFallbackProfile::setDirectoryNumber()
     * @uses XFallbackProfile::setNumberOfDigitsForCallerIDPartialMatch()
     * @param string $name
     * @param string $callCss
     * @param string $description
     * @param string $advertisedFallbackDirectoryE164Number
     * @param string $qosSensistivityLevel
     * @param string $callAnswerTimer
     * @param \CUCM\StructType\XFkType $directoryNumberPartition
     * @param string $directoryNumber
     * @param string $numberOfDigitsForCallerIDPartialMatch
     */
    public function __construct($name = null, $callCss = 'Calling device AAR Calling Search Space', $description = null, $advertisedFallbackDirectoryE164Number = null, $qosSensistivityLevel = '3', $callAnswerTimer = '6', \CUCM\StructType\XFkType $directoryNumberPartition = null, $directoryNumber = null, $numberOfDigitsForCallerIDPartialMatch = '5')
    {
        $this
            ->setName($name)
            ->setCallCss($callCss)
            ->setDescription($description)
            ->setAdvertisedFallbackDirectoryE164Number($advertisedFallbackDirectoryE164Number)
            ->setQosSensistivityLevel($qosSensistivityLevel)
            ->setCallAnswerTimer($callAnswerTimer)
            ->setDirectoryNumberPartition($directoryNumberPartition)
            ->setDirectoryNumber($directoryNumber)
            ->setNumberOfDigitsForCallerIDPartialMatch($numberOfDigitsForCallerIDPartialMatch);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\XFallbackProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get callCss value
     * @return string
     */
    public function getCallCss()
    {
        return $this->callCss;
    }
    /**
     * Set callCss value
     * @uses \CUCM\EnumType\XFallBackCSSSelection::valueIsValid()
     * @uses \CUCM\EnumType\XFallBackCSSSelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callCss
     * @return \CUCM\StructType\XFallbackProfile
     */
    public function setCallCss($callCss = 'Calling device AAR Calling Search Space')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XFallBackCSSSelection::valueIsValid($callCss)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callCss, implode(', ', \CUCM\EnumType\XFallBackCSSSelection::getValidValues())), __LINE__);
        }
        $this->callCss = $callCss;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\XFallbackProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get advertisedFallbackDirectoryE164Number value
     * @return string|null
     */
    public function getAdvertisedFallbackDirectoryE164Number()
    {
        return $this->advertisedFallbackDirectoryE164Number;
    }
    /**
     * Set advertisedFallbackDirectoryE164Number value
     * @param string $advertisedFallbackDirectoryE164Number
     * @return \CUCM\StructType\XFallbackProfile
     */
    public function setAdvertisedFallbackDirectoryE164Number($advertisedFallbackDirectoryE164Number = null)
    {
        // validation for constraint: string
        if (!is_null($advertisedFallbackDirectoryE164Number) && !is_string($advertisedFallbackDirectoryE164Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($advertisedFallbackDirectoryE164Number)), __LINE__);
        }
        $this->advertisedFallbackDirectoryE164Number = $advertisedFallbackDirectoryE164Number;
        return $this;
    }
    /**
     * Get qosSensistivityLevel value
     * @return string|null
     */
    public function getQosSensistivityLevel()
    {
        return $this->qosSensistivityLevel;
    }
    /**
     * Set qosSensistivityLevel value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qosSensistivityLevel
     * @return \CUCM\StructType\XFallbackProfile
     */
    public function setQosSensistivityLevel($qosSensistivityLevel = '3')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($qosSensistivityLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qosSensistivityLevel, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->qosSensistivityLevel = $qosSensistivityLevel;
        return $this;
    }
    /**
     * Get callAnswerTimer value
     * @return string|null
     */
    public function getCallAnswerTimer()
    {
        return $this->callAnswerTimer;
    }
    /**
     * Set callAnswerTimer value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callAnswerTimer
     * @return \CUCM\StructType\XFallbackProfile
     */
    public function setCallAnswerTimer($callAnswerTimer = '6')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($callAnswerTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callAnswerTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->callAnswerTimer = $callAnswerTimer;
        return $this;
    }
    /**
     * Get directoryNumberPartition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDirectoryNumberPartition()
    {
        return isset($this->directoryNumberPartition) ? $this->directoryNumberPartition : null;
    }
    /**
     * Set directoryNumberPartition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $directoryNumberPartition
     * @return \CUCM\StructType\XFallbackProfile
     */
    public function setDirectoryNumberPartition(\CUCM\StructType\XFkType $directoryNumberPartition = null)
    {
        if (is_null($directoryNumberPartition) || (is_array($directoryNumberPartition) && empty($directoryNumberPartition))) {
            unset($this->directoryNumberPartition);
        } else {
            $this->directoryNumberPartition = $directoryNumberPartition;
        }
        return $this;
    }
    /**
     * Get directoryNumber value
     * @return string|null
     */
    public function getDirectoryNumber()
    {
        return $this->directoryNumber;
    }
    /**
     * Set directoryNumber value
     * @param string $directoryNumber
     * @return \CUCM\StructType\XFallbackProfile
     */
    public function setDirectoryNumber($directoryNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($directoryNumber) && strlen($directoryNumber) > 16) || (is_array($directoryNumber) && count($directoryNumber) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($directoryNumber) ? strlen($directoryNumber) : count($directoryNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($directoryNumber) && !is_string($directoryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directoryNumber)), __LINE__);
        }
        $this->directoryNumber = $directoryNumber;
        return $this;
    }
    /**
     * Get numberOfDigitsForCallerIDPartialMatch value
     * @return string|null
     */
    public function getNumberOfDigitsForCallerIDPartialMatch()
    {
        return $this->numberOfDigitsForCallerIDPartialMatch;
    }
    /**
     * Set numberOfDigitsForCallerIDPartialMatch value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberOfDigitsForCallerIDPartialMatch
     * @return \CUCM\StructType\XFallbackProfile
     */
    public function setNumberOfDigitsForCallerIDPartialMatch($numberOfDigitsForCallerIDPartialMatch = '5')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($numberOfDigitsForCallerIDPartialMatch)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numberOfDigitsForCallerIDPartialMatch, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->numberOfDigitsForCallerIDPartialMatch = $numberOfDigitsForCallerIDPartialMatch;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XFallbackProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
