<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDefaultDeviceProfile StructType
 * @subpackage Structs
 */
class XDefaultDeviceProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - default: User
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $protocolSide;
    /**
     * The phoneButtonTemplate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $phoneButtonTemplate;
    /**
     * The softkeyTemplate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $softkeyTemplate;
    /**
     * The privacy
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $privacy;
    /**
     * The mlppIndication
     * Meta informations extracted from the WSDL
     * - default: Off
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $mlppIndication;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $preemption;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $description;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $userLocale;
    /**
     * The singleButtonBarge
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This tag is valid only for devices that support SBB.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $singleButtonBarge;
    /**
     * The joinAcrossLines
     * Meta informations extracted from the WSDL
     * - default: Default
     * - documentation: This tag is valid only for devices that support JAL..
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $joinAcrossLines;
    /**
     * The ignorePi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $ignorePi;
    /**
     * The dndStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dndStatus;
    /**
     * The dndRingSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dndRingSetting;
    /**
     * The dndOption
     * Meta informations extracted from the WSDL
     * - default: Ringer Off
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dndOption;
    /**
     * The mlppDomainId
     * Meta informations extracted from the WSDL
     * - documentation: Use -1 to set to null
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 128
     * @var string
     */
    public $mlppDomainId;
    /**
     * The alwaysUsePrimeLine
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLine;
    /**
     * The alwaysUsePrimeLineForVoiceMessage
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $alwaysUsePrimeLineForVoiceMessage;
    /**
     * The emccCallingSearchSpace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $emccCallingSearchSpace;
    /**
     * Constructor method for XDefaultDeviceProfile
     * @uses XDefaultDeviceProfile::setName()
     * @uses XDefaultDeviceProfile::setProduct()
     * @uses XDefaultDeviceProfile::setClass()
     * @uses XDefaultDeviceProfile::setProtocol()
     * @uses XDefaultDeviceProfile::setProtocolSide()
     * @uses XDefaultDeviceProfile::setPhoneButtonTemplate()
     * @uses XDefaultDeviceProfile::setSoftkeyTemplate()
     * @uses XDefaultDeviceProfile::setPrivacy()
     * @uses XDefaultDeviceProfile::setMlppIndication()
     * @uses XDefaultDeviceProfile::setPreemption()
     * @uses XDefaultDeviceProfile::setDescription()
     * @uses XDefaultDeviceProfile::setUserHoldMohAudioSourceId()
     * @uses XDefaultDeviceProfile::setUserLocale()
     * @uses XDefaultDeviceProfile::setSingleButtonBarge()
     * @uses XDefaultDeviceProfile::setJoinAcrossLines()
     * @uses XDefaultDeviceProfile::setIgnorePi()
     * @uses XDefaultDeviceProfile::setDndStatus()
     * @uses XDefaultDeviceProfile::setDndRingSetting()
     * @uses XDefaultDeviceProfile::setDndOption()
     * @uses XDefaultDeviceProfile::setMlppDomainId()
     * @uses XDefaultDeviceProfile::setAlwaysUsePrimeLine()
     * @uses XDefaultDeviceProfile::setAlwaysUsePrimeLineForVoiceMessage()
     * @uses XDefaultDeviceProfile::setEmccCallingSearchSpace()
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param \CUCM\StructType\XFkType $phoneButtonTemplate
     * @param \CUCM\StructType\XFkType $softkeyTemplate
     * @param string $privacy
     * @param string $mlppIndication
     * @param string $preemption
     * @param string $description
     * @param string $userHoldMohAudioSourceId
     * @param string $userLocale
     * @param string $singleButtonBarge
     * @param string $joinAcrossLines
     * @param string $ignorePi
     * @param string $dndStatus
     * @param string $dndRingSetting
     * @param string $dndOption
     * @param string $mlppDomainId
     * @param string $alwaysUsePrimeLine
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @param \CUCM\StructType\XFkType $emccCallingSearchSpace
     */
    public function __construct($name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', \CUCM\StructType\XFkType $phoneButtonTemplate = null, \CUCM\StructType\XFkType $softkeyTemplate = null, $privacy = 'Default', $mlppIndication = 'Off', $preemption = 'Default', $description = null, $userHoldMohAudioSourceId = null, $userLocale = null, $singleButtonBarge = 'Default', $joinAcrossLines = 'Default', $ignorePi = null, $dndStatus = null, $dndRingSetting = null, $dndOption = 'Ringer Off', $mlppDomainId = null, $alwaysUsePrimeLine = 'Default', $alwaysUsePrimeLineForVoiceMessage = 'Default', \CUCM\StructType\XFkType $emccCallingSearchSpace = null)
    {
        $this
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setPhoneButtonTemplate($phoneButtonTemplate)
            ->setSoftkeyTemplate($softkeyTemplate)
            ->setPrivacy($privacy)
            ->setMlppIndication($mlppIndication)
            ->setPreemption($preemption)
            ->setDescription($description)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setUserLocale($userLocale)
            ->setSingleButtonBarge($singleButtonBarge)
            ->setJoinAcrossLines($joinAcrossLines)
            ->setIgnorePi($ignorePi)
            ->setDndStatus($dndStatus)
            ->setDndRingSetting($dndRingSetting)
            ->setDndOption($dndOption)
            ->setMlppDomainId($mlppDomainId)
            ->setAlwaysUsePrimeLine($alwaysUsePrimeLine)
            ->setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage)
            ->setEmccCallingSearchSpace($emccCallingSearchSpace);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \CUCM\EnumType\XProduct::valueIsValid()
     * @uses \CUCM\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \CUCM\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses \CUCM\EnumType\XClass::valueIsValid()
     * @uses \CUCM\EnumType\XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', \CUCM\EnumType\XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses \CUCM\EnumType\XDeviceProtocol::valueIsValid()
     * @uses \CUCM\EnumType\XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', \CUCM\EnumType\XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses \CUCM\EnumType\XProtocolSide::valueIsValid()
     * @uses \CUCM\EnumType\XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', \CUCM\EnumType\XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get phoneButtonTemplate value
     * @return \CUCM\StructType\XFkType
     */
    public function getPhoneButtonTemplate()
    {
        return $this->phoneButtonTemplate;
    }
    /**
     * Set phoneButtonTemplate value
     * @param \CUCM\StructType\XFkType $phoneButtonTemplate
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setPhoneButtonTemplate(\CUCM\StructType\XFkType $phoneButtonTemplate = null)
    {
        $this->phoneButtonTemplate = $phoneButtonTemplate;
        return $this;
    }
    /**
     * Get softkeyTemplate value
     * @return \CUCM\StructType\XFkType
     */
    public function getSoftkeyTemplate()
    {
        return $this->softkeyTemplate;
    }
    /**
     * Set softkeyTemplate value
     * @param \CUCM\StructType\XFkType $softkeyTemplate
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setSoftkeyTemplate(\CUCM\StructType\XFkType $softkeyTemplate = null)
    {
        $this->softkeyTemplate = $softkeyTemplate;
        return $this;
    }
    /**
     * Get privacy value
     * @return string
     */
    public function getPrivacy()
    {
        return $this->privacy;
    }
    /**
     * Set privacy value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $privacy
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setPrivacy($privacy = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($privacy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $privacy, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->privacy = $privacy;
        return $this;
    }
    /**
     * Get mlppIndication value
     * @return string
     */
    public function getMlppIndication()
    {
        return $this->mlppIndication;
    }
    /**
     * Set mlppIndication value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndication
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setMlppIndication($mlppIndication = 'Off')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($mlppIndication)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndication, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndication = $mlppIndication;
        return $this;
    }
    /**
     * Get preemption value
     * @return string
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses \CUCM\EnumType\XPreemption::valueIsValid()
     * @uses \CUCM\EnumType\XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setPreemption($preemption = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', \CUCM\EnumType\XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 255) || (is_array($description) && count($description) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return isset($this->userHoldMohAudioSourceId) ? $this->userHoldMohAudioSourceId : null;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XMOHAudioSourceId::valueIsValid()
     * @uses \CUCM\EnumType\XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', \CUCM\EnumType\XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        if (is_null($userHoldMohAudioSourceId) || (is_array($userHoldMohAudioSourceId) && empty($userHoldMohAudioSourceId))) {
            unset($this->userHoldMohAudioSourceId);
        } else {
            $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        }
        return $this;
    }
    /**
     * Get userLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLocale()
    {
        return isset($this->userLocale) ? $this->userLocale : null;
    }
    /**
     * Set userLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XUserLocale::valueIsValid()
     * @uses \CUCM\EnumType\XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', \CUCM\EnumType\XUserLocale::getValidValues())), __LINE__);
        }
        if (is_null($userLocale) || (is_array($userLocale) && empty($userLocale))) {
            unset($this->userLocale);
        } else {
            $this->userLocale = $userLocale;
        }
        return $this;
    }
    /**
     * Get singleButtonBarge value
     * @return string|null
     */
    public function getSingleButtonBarge()
    {
        return $this->singleButtonBarge;
    }
    /**
     * Set singleButtonBarge value
     * @uses \CUCM\EnumType\XBarge::valueIsValid()
     * @uses \CUCM\EnumType\XBarge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $singleButtonBarge
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setSingleButtonBarge($singleButtonBarge = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XBarge::valueIsValid($singleButtonBarge)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $singleButtonBarge, implode(', ', \CUCM\EnumType\XBarge::getValidValues())), __LINE__);
        }
        $this->singleButtonBarge = $singleButtonBarge;
        return $this;
    }
    /**
     * Get joinAcrossLines value
     * @return string|null
     */
    public function getJoinAcrossLines()
    {
        return $this->joinAcrossLines;
    }
    /**
     * Set joinAcrossLines value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $joinAcrossLines
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setJoinAcrossLines($joinAcrossLines = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($joinAcrossLines)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $joinAcrossLines, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->joinAcrossLines = $joinAcrossLines;
        return $this;
    }
    /**
     * Get ignorePi value
     * @return string|null
     */
    public function getIgnorePi()
    {
        return $this->ignorePi;
    }
    /**
     * Set ignorePi value
     * @param string $ignorePi
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setIgnorePi($ignorePi = null)
    {
        // validation for constraint: pattern
        if (is_scalar($ignorePi) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $ignorePi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($ignorePi, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ignorePi) && !is_string($ignorePi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ignorePi)), __LINE__);
        }
        $this->ignorePi = $ignorePi;
        return $this;
    }
    /**
     * Get dndStatus value
     * @return string|null
     */
    public function getDndStatus()
    {
        return $this->dndStatus;
    }
    /**
     * Set dndStatus value
     * @param string $dndStatus
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setDndStatus($dndStatus = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dndStatus) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($dndStatus, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dndStatus) && !is_string($dndStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dndStatus)), __LINE__);
        }
        $this->dndStatus = $dndStatus;
        return $this;
    }
    /**
     * Get dndRingSetting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDndRingSetting()
    {
        return isset($this->dndRingSetting) ? $this->dndRingSetting : null;
    }
    /**
     * Set dndRingSetting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XRingSetting::valueIsValid()
     * @uses \CUCM\EnumType\XRingSetting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndRingSetting
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setDndRingSetting($dndRingSetting = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XRingSetting::valueIsValid($dndRingSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndRingSetting, implode(', ', \CUCM\EnumType\XRingSetting::getValidValues())), __LINE__);
        }
        if (is_null($dndRingSetting) || (is_array($dndRingSetting) && empty($dndRingSetting))) {
            unset($this->dndRingSetting);
        } else {
            $this->dndRingSetting = $dndRingSetting;
        }
        return $this;
    }
    /**
     * Get dndOption value
     * @return string|null
     */
    public function getDndOption()
    {
        return $this->dndOption;
    }
    /**
     * Set dndOption value
     * @uses \CUCM\EnumType\XDNDOption::valueIsValid()
     * @uses \CUCM\EnumType\XDNDOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dndOption
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setDndOption($dndOption = 'Ringer Off')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDNDOption::valueIsValid($dndOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dndOption, implode(', ', \CUCM\EnumType\XDNDOption::getValidValues())), __LINE__);
        }
        $this->dndOption = $dndOption;
        return $this;
    }
    /**
     * Get mlppDomainId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMlppDomainId()
    {
        return isset($this->mlppDomainId) ? $this->mlppDomainId : null;
    }
    /**
     * Set mlppDomainId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mlppDomainId
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setMlppDomainId($mlppDomainId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mlppDomainId) && strlen($mlppDomainId) > 128) || (is_array($mlppDomainId) && count($mlppDomainId) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($mlppDomainId) ? strlen($mlppDomainId) : count($mlppDomainId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mlppDomainId) && !is_string($mlppDomainId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mlppDomainId)), __LINE__);
        }
        if (is_null($mlppDomainId) || (is_array($mlppDomainId) && empty($mlppDomainId))) {
            unset($this->mlppDomainId);
        } else {
            $this->mlppDomainId = $mlppDomainId;
        }
        return $this;
    }
    /**
     * Get alwaysUsePrimeLine value
     * @return string|null
     */
    public function getAlwaysUsePrimeLine()
    {
        return $this->alwaysUsePrimeLine;
    }
    /**
     * Set alwaysUsePrimeLine value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLine
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setAlwaysUsePrimeLine($alwaysUsePrimeLine = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($alwaysUsePrimeLine)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLine, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLine = $alwaysUsePrimeLine;
        return $this;
    }
    /**
     * Get alwaysUsePrimeLineForVoiceMessage value
     * @return string|null
     */
    public function getAlwaysUsePrimeLineForVoiceMessage()
    {
        return $this->alwaysUsePrimeLineForVoiceMessage;
    }
    /**
     * Set alwaysUsePrimeLineForVoiceMessage value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alwaysUsePrimeLineForVoiceMessage
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setAlwaysUsePrimeLineForVoiceMessage($alwaysUsePrimeLineForVoiceMessage = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($alwaysUsePrimeLineForVoiceMessage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $alwaysUsePrimeLineForVoiceMessage, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->alwaysUsePrimeLineForVoiceMessage = $alwaysUsePrimeLineForVoiceMessage;
        return $this;
    }
    /**
     * Get emccCallingSearchSpace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getEmccCallingSearchSpace()
    {
        return isset($this->emccCallingSearchSpace) ? $this->emccCallingSearchSpace : null;
    }
    /**
     * Set emccCallingSearchSpace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $emccCallingSearchSpace
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public function setEmccCallingSearchSpace(\CUCM\StructType\XFkType $emccCallingSearchSpace = null)
    {
        if (is_null($emccCallingSearchSpace) || (is_array($emccCallingSearchSpace) && empty($emccCallingSearchSpace))) {
            unset($this->emccCallingSearchSpace);
        } else {
            $this->emccCallingSearchSpace = $emccCallingSearchSpace;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XDefaultDeviceProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
