<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDdi StructType
 * @subpackage Structs
 */
class XDdi extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $dialPlanName;
    /**
     * The clause
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 1024
     * @var string
     */
    public $clause;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Members
     */
    public $members;
    /**
     * Constructor method for XDdi
     * @uses XDdi::setName()
     * @uses XDdi::setDialPlanName()
     * @uses XDdi::setClause()
     * @uses XDdi::setMembers()
     * @param string $name
     * @param \CUCM\StructType\XFkType $dialPlanName
     * @param string $clause
     * @param \CUCM\StructType\Members $members
     */
    public function __construct($name = null, \CUCM\StructType\XFkType $dialPlanName = null, $clause = null, \CUCM\StructType\Members $members = null)
    {
        $this
            ->setName($name)
            ->setDialPlanName($dialPlanName)
            ->setClause($clause)
            ->setMembers($members);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \CUCM\StructType\XDdi
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get dialPlanName value
     * @return \CUCM\StructType\XFkType
     */
    public function getDialPlanName()
    {
        return $this->dialPlanName;
    }
    /**
     * Set dialPlanName value
     * @param \CUCM\StructType\XFkType $dialPlanName
     * @return \CUCM\StructType\XDdi
     */
    public function setDialPlanName(\CUCM\StructType\XFkType $dialPlanName = null)
    {
        $this->dialPlanName = $dialPlanName;
        return $this;
    }
    /**
     * Get clause value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClause()
    {
        return isset($this->clause) ? $this->clause : null;
    }
    /**
     * Set clause value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clause
     * @return \CUCM\StructType\XDdi
     */
    public function setClause($clause = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clause) && strlen($clause) > 1024) || (is_array($clause) && count($clause) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($clause) ? strlen($clause) : count($clause)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clause) && !is_string($clause)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clause)), __LINE__);
        }
        if (is_null($clause) || (is_array($clause) && empty($clause))) {
            unset($this->clause);
        } else {
            $this->clause = $clause;
        }
        return $this;
    }
    /**
     * Get members value
     * @return \CUCM\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \CUCM\StructType\Members $members
     * @return \CUCM\StructType\XDdi
     */
    public function setMembers(\CUCM\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XDdi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
