<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCertificateRole StructType
 * @subpackage Structs
 */
class XCertificateRole extends AbstractStructBase
{
    /**
     * The roleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $roleName;
    /**
     * Constructor method for XCertificateRole
     * @uses XCertificateRole::setRoleName()
     * @param string $roleName
     */
    public function __construct($roleName = null)
    {
        $this
            ->setRoleName($roleName);
    }
    /**
     * Get roleName value
     * @return string|null
     */
    public function getRoleName()
    {
        return $this->roleName;
    }
    /**
     * Set roleName value
     * @uses \CUCM\EnumType\XTrustRole::valueIsValid()
     * @uses \CUCM\EnumType\XTrustRole::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roleName
     * @return \CUCM\StructType\XCertificateRole
     */
    public function setRoleName($roleName = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTrustRole::valueIsValid($roleName)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $roleName, implode(', ', \CUCM\EnumType\XTrustRole::getValidValues())), __LINE__);
        }
        $this->roleName = $roleName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XCertificateRole
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
