<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCallForwardNoAnswer StructType
 * @subpackage Structs
 */
class XCallForwardNoAnswer extends AbstractStructBase
{
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The forwardToVoiceMail
     * Meta informations extracted from the WSDL
     * - documentation: DB: Derived from CF*VoiceMailEnabled fields. This tag has been marked as ReadOnly for callForwardAlternateParty as it is not applicable for callForwardAlternateParty setting.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $forwardToVoiceMail;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - maxLength: 50
     * @var string
     */
    public $destination;
    /**
     * The duration
     * Meta informations extracted from the WSDL
     * - documentation: Applicable only for callForwardNoAnswer and callForwardAlternateParty,Value "-1" in the response indicates that the CM will use the default setting
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $duration;
    /**
     * Constructor method for XCallForwardNoAnswer
     * @uses XCallForwardNoAnswer::setCallingSearchSpaceName()
     * @uses XCallForwardNoAnswer::setForwardToVoiceMail()
     * @uses XCallForwardNoAnswer::setDestination()
     * @uses XCallForwardNoAnswer::setDuration()
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @param string $forwardToVoiceMail
     * @param string $destination
     * @param string $duration
     */
    public function __construct(\CUCM\StructType\XFkType $callingSearchSpaceName = null, $forwardToVoiceMail = null, $destination = null, $duration = null)
    {
        $this
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setForwardToVoiceMail($forwardToVoiceMail)
            ->setDestination($destination)
            ->setDuration($duration);
    }
    /**
     * Get callingSearchSpaceName value
     * @return \CUCM\StructType\XFkType
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param \CUCM\StructType\XFkType $callingSearchSpaceName
     * @return \CUCM\StructType\XCallForwardNoAnswer
     */
    public function setCallingSearchSpaceName(\CUCM\StructType\XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get forwardToVoiceMail value
     * @return string|null
     */
    public function getForwardToVoiceMail()
    {
        return $this->forwardToVoiceMail;
    }
    /**
     * Set forwardToVoiceMail value
     * @param string $forwardToVoiceMail
     * @return \CUCM\StructType\XCallForwardNoAnswer
     */
    public function setForwardToVoiceMail($forwardToVoiceMail = null)
    {
        // validation for constraint: pattern
        if (is_scalar($forwardToVoiceMail) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($forwardToVoiceMail, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($forwardToVoiceMail) && !is_string($forwardToVoiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forwardToVoiceMail)), __LINE__);
        }
        $this->forwardToVoiceMail = $forwardToVoiceMail;
        return $this;
    }
    /**
     * Get destination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDestination()
    {
        return isset($this->destination) ? $this->destination : null;
    }
    /**
     * Set destination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $destination
     * @return \CUCM\StructType\XCallForwardNoAnswer
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($destination) && strlen($destination) > 50) || (is_array($destination) && count($destination) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($destination) ? strlen($destination) : count($destination)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        if (is_null($destination) || (is_array($destination) && empty($destination))) {
            unset($this->destination);
        } else {
            $this->destination = $destination;
        }
        return $this;
    }
    /**
     * Get duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDuration()
    {
        return isset($this->duration) ? $this->duration : null;
    }
    /**
     * Set duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $duration
     * @return \CUCM\StructType\XCallForwardNoAnswer
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($duration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $duration, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->duration);
        } else {
            $this->duration = $duration;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\XCallForwardNoAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
