<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVpnGatewayReq StructType
 * @subpackage Structs
 */
class UpdateVpnGatewayReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The url
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 255
     * @var string
     */
    public $url;
    /**
     * The certificates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Certificates
     */
    public $certificates;
    /**
     * Constructor method for UpdateVpnGatewayReq
     * @uses UpdateVpnGatewayReq::setNewName()
     * @uses UpdateVpnGatewayReq::setDescription()
     * @uses UpdateVpnGatewayReq::setUrl()
     * @uses UpdateVpnGatewayReq::setCertificates()
     * @param string $newName
     * @param string $description
     * @param string $url
     * @param \CUCM\StructType\Certificates $certificates
     */
    public function __construct($newName = null, $description = null, $url = null, \CUCM\StructType\Certificates $certificates = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setUrl($url)
            ->setCertificates($certificates);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateVpnGatewayReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateVpnGatewayReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \CUCM\StructType\UpdateVpnGatewayReq
     */
    public function setUrl($url = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($url) && strlen($url) > 255) || (is_array($url) && count($url) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($url) ? strlen($url) : count($url)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get certificates value
     * @return \CUCM\StructType\Certificates|null
     */
    public function getCertificates()
    {
        return $this->certificates;
    }
    /**
     * Set certificates value
     * @param \CUCM\StructType\Certificates $certificates
     * @return \CUCM\StructType\UpdateVpnGatewayReq
     */
    public function setCertificates(\CUCM\StructType\Certificates $certificates = null)
    {
        $this->certificates = $certificates;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateVpnGatewayReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
