<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSrstReq StructType
 * @subpackage Structs
 */
class UpdateSrstReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - default: 2000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $port;
    /**
     * The ipAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $ipAddress;
    /**
     * The SipNetwork
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $SipNetwork;
    /**
     * The SipPort
     * Meta informations extracted from the WSDL
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $SipPort;
    /**
     * The isSecure
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isSecure;
    /**
     * Constructor method for UpdateSrstReq
     * @uses UpdateSrstReq::setNewName()
     * @uses UpdateSrstReq::setPort()
     * @uses UpdateSrstReq::setIpAddress()
     * @uses UpdateSrstReq::setSipNetwork()
     * @uses UpdateSrstReq::setSipPort()
     * @uses UpdateSrstReq::setIsSecure()
     * @param string $newName
     * @param string $port
     * @param string $ipAddress
     * @param string $sipNetwork
     * @param string $sipPort
     * @param string $isSecure
     */
    public function __construct($newName = null, $port = '2000', $ipAddress = null, $sipNetwork = null, $sipPort = '5060', $isSecure = null)
    {
        $this
            ->setNewName($newName)
            ->setPort($port)
            ->setIpAddress($ipAddress)
            ->setSipNetwork($sipNetwork)
            ->setSipPort($sipPort)
            ->setIsSecure($isSecure);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateSrstReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $port
     * @return \CUCM\StructType\UpdateSrstReq
     */
    public function setPort($port = '2000')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($port)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $port, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get ipAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }
    /**
     * Set ipAddress value
     * @param string $ipAddress
     * @return \CUCM\StructType\UpdateSrstReq
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->ipAddress = $ipAddress;
        return $this;
    }
    /**
     * Get SipNetwork value
     * @return string|null
     */
    public function getSipNetwork()
    {
        return $this->SipNetwork;
    }
    /**
     * Set SipNetwork value
     * @param string $sipNetwork
     * @return \CUCM\StructType\UpdateSrstReq
     */
    public function setSipNetwork($sipNetwork = null)
    {
        // validation for constraint: string
        if (!is_null($sipNetwork) && !is_string($sipNetwork)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sipNetwork)), __LINE__);
        }
        $this->SipNetwork = $sipNetwork;
        return $this;
    }
    /**
     * Get SipPort value
     * @return string|null
     */
    public function getSipPort()
    {
        return $this->SipPort;
    }
    /**
     * Set SipPort value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sipPort
     * @return \CUCM\StructType\UpdateSrstReq
     */
    public function setSipPort($sipPort = '5060')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($sipPort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sipPort, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->SipPort = $sipPort;
        return $this;
    }
    /**
     * Get isSecure value
     * @return string|null
     */
    public function getIsSecure()
    {
        return $this->isSecure;
    }
    /**
     * Set isSecure value
     * @param string $isSecure
     * @return \CUCM\StructType\UpdateSrstReq
     */
    public function setIsSecure($isSecure = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isSecure) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isSecure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isSecure, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isSecure) && !is_string($isSecure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isSecure)), __LINE__);
        }
        $this->isSecure = $isSecure;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateSrstReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
