<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateSipDialRulesReq StructType
 * @subpackage Structs
 */
class UpdateSipDialRulesReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $description;
    /**
     * The removePatterns
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RemovePatterns
     */
    public $removePatterns;
    /**
     * The addPatterns
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AddPatterns
     */
    public $addPatterns;
    /**
     * The patterns
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Patterns
     */
    public $patterns;
    /**
     * The removePlars
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RemovePlars
     */
    public $removePlars;
    /**
     * The addPlars
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AddPlars
     */
    public $addPlars;
    /**
     * The plars
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Plars
     */
    public $plars;
    /**
     * Constructor method for UpdateSipDialRulesReq
     * @uses UpdateSipDialRulesReq::setNewName()
     * @uses UpdateSipDialRulesReq::setDescription()
     * @uses UpdateSipDialRulesReq::setRemovePatterns()
     * @uses UpdateSipDialRulesReq::setAddPatterns()
     * @uses UpdateSipDialRulesReq::setPatterns()
     * @uses UpdateSipDialRulesReq::setRemovePlars()
     * @uses UpdateSipDialRulesReq::setAddPlars()
     * @uses UpdateSipDialRulesReq::setPlars()
     * @param string $newName
     * @param string $description
     * @param \CUCM\StructType\RemovePatterns $removePatterns
     * @param \CUCM\StructType\AddPatterns $addPatterns
     * @param \CUCM\StructType\Patterns $patterns
     * @param \CUCM\StructType\RemovePlars $removePlars
     * @param \CUCM\StructType\AddPlars $addPlars
     * @param \CUCM\StructType\Plars $plars
     */
    public function __construct($newName = null, $description = null, \CUCM\StructType\RemovePatterns $removePatterns = null, \CUCM\StructType\AddPatterns $addPatterns = null, \CUCM\StructType\Patterns $patterns = null, \CUCM\StructType\RemovePlars $removePlars = null, \CUCM\StructType\AddPlars $addPlars = null, \CUCM\StructType\Plars $plars = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setRemovePatterns($removePatterns)
            ->setAddPatterns($addPatterns)
            ->setPatterns($patterns)
            ->setRemovePlars($removePlars)
            ->setAddPlars($addPlars)
            ->setPlars($plars);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateSipDialRulesReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : null;
    }
    /**
     * Set description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \CUCM\StructType\UpdateSipDialRulesReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->description);
        } else {
            $this->description = $description;
        }
        return $this;
    }
    /**
     * Get removePatterns value
     * @return \CUCM\StructType\RemovePatterns|null
     */
    public function getRemovePatterns()
    {
        return $this->removePatterns;
    }
    /**
     * Set removePatterns value
     * @param \CUCM\StructType\RemovePatterns $removePatterns
     * @return \CUCM\StructType\UpdateSipDialRulesReq
     */
    public function setRemovePatterns(\CUCM\StructType\RemovePatterns $removePatterns = null)
    {
        $this->removePatterns = $removePatterns;
        return $this;
    }
    /**
     * Get addPatterns value
     * @return \CUCM\StructType\AddPatterns|null
     */
    public function getAddPatterns()
    {
        return $this->addPatterns;
    }
    /**
     * Set addPatterns value
     * @param \CUCM\StructType\AddPatterns $addPatterns
     * @return \CUCM\StructType\UpdateSipDialRulesReq
     */
    public function setAddPatterns(\CUCM\StructType\AddPatterns $addPatterns = null)
    {
        $this->addPatterns = $addPatterns;
        return $this;
    }
    /**
     * Get patterns value
     * @return \CUCM\StructType\Patterns|null
     */
    public function getPatterns()
    {
        return $this->patterns;
    }
    /**
     * Set patterns value
     * @param \CUCM\StructType\Patterns $patterns
     * @return \CUCM\StructType\UpdateSipDialRulesReq
     */
    public function setPatterns(\CUCM\StructType\Patterns $patterns = null)
    {
        $this->patterns = $patterns;
        return $this;
    }
    /**
     * Get removePlars value
     * @return \CUCM\StructType\RemovePlars|null
     */
    public function getRemovePlars()
    {
        return $this->removePlars;
    }
    /**
     * Set removePlars value
     * @param \CUCM\StructType\RemovePlars $removePlars
     * @return \CUCM\StructType\UpdateSipDialRulesReq
     */
    public function setRemovePlars(\CUCM\StructType\RemovePlars $removePlars = null)
    {
        $this->removePlars = $removePlars;
        return $this;
    }
    /**
     * Get addPlars value
     * @return \CUCM\StructType\AddPlars|null
     */
    public function getAddPlars()
    {
        return $this->addPlars;
    }
    /**
     * Set addPlars value
     * @param \CUCM\StructType\AddPlars $addPlars
     * @return \CUCM\StructType\UpdateSipDialRulesReq
     */
    public function setAddPlars(\CUCM\StructType\AddPlars $addPlars = null)
    {
        $this->addPlars = $addPlars;
        return $this;
    }
    /**
     * Get plars value
     * @return \CUCM\StructType\Plars|null
     */
    public function getPlars()
    {
        return $this->plars;
    }
    /**
     * Set plars value
     * @param \CUCM\StructType\Plars $plars
     * @return \CUCM\StructType\UpdateSipDialRulesReq
     */
    public function setPlars(\CUCM\StructType\Plars $plars = null)
    {
        $this->plars = $plars;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateSipDialRulesReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
