<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateRegionReq StructType
 * @subpackage Structs
 */
class UpdateRegionReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The relatedRegions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RelatedRegions
     */
    public $relatedRegions;
    /**
     * Constructor method for UpdateRegionReq
     * @uses UpdateRegionReq::setNewName()
     * @uses UpdateRegionReq::setRelatedRegions()
     * @param string $newName
     * @param \CUCM\StructType\RelatedRegions $relatedRegions
     */
    public function __construct($newName = null, \CUCM\StructType\RelatedRegions $relatedRegions = null)
    {
        $this
            ->setNewName($newName)
            ->setRelatedRegions($relatedRegions);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateRegionReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get relatedRegions value
     * @return \CUCM\StructType\RelatedRegions|null
     */
    public function getRelatedRegions()
    {
        return $this->relatedRegions;
    }
    /**
     * Set relatedRegions value
     * @param \CUCM\StructType\RelatedRegions $relatedRegions
     * @return \CUCM\StructType\UpdateRegionReq
     */
    public function setRelatedRegions(\CUCM\StructType\RelatedRegions $relatedRegions = null)
    {
        $this->relatedRegions = $relatedRegions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateRegionReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
