<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLocationReq StructType
 * @subpackage Structs
 */
class UpdateLocationReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The kbits
     * Meta informations extracted from the WSDL
     * - documentation: Audio Bandwidth to be provided
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $kbits;
    /**
     * The videoKbits
     * Meta informations extracted from the WSDL
     * - default: 384
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $videoKbits;
    /**
     * The relatedLocations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RelatedLocations
     */
    public $relatedLocations;
    /**
     * Constructor method for UpdateLocationReq
     * @uses UpdateLocationReq::setNewName()
     * @uses UpdateLocationReq::setKbits()
     * @uses UpdateLocationReq::setVideoKbits()
     * @uses UpdateLocationReq::setRelatedLocations()
     * @param string $newName
     * @param string $kbits
     * @param string $videoKbits
     * @param \CUCM\StructType\RelatedLocations $relatedLocations
     */
    public function __construct($newName = null, $kbits = null, $videoKbits = '384', \CUCM\StructType\RelatedLocations $relatedLocations = null)
    {
        $this
            ->setNewName($newName)
            ->setKbits($kbits)
            ->setVideoKbits($videoKbits)
            ->setRelatedLocations($relatedLocations);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateLocationReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get kbits value
     * @return string|null
     */
    public function getKbits()
    {
        return $this->kbits;
    }
    /**
     * Set kbits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kbits
     * @return \CUCM\StructType\UpdateLocationReq
     */
    public function setKbits($kbits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($kbits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $kbits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->kbits = $kbits;
        return $this;
    }
    /**
     * Get videoKbits value
     * @return string|null
     */
    public function getVideoKbits()
    {
        return $this->videoKbits;
    }
    /**
     * Set videoKbits value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $videoKbits
     * @return \CUCM\StructType\UpdateLocationReq
     */
    public function setVideoKbits($videoKbits = '384')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($videoKbits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $videoKbits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->videoKbits = $videoKbits;
        return $this;
    }
    /**
     * Get relatedLocations value
     * @return \CUCM\StructType\RelatedLocations|null
     */
    public function getRelatedLocations()
    {
        return $this->relatedLocations;
    }
    /**
     * Set relatedLocations value
     * @param \CUCM\StructType\RelatedLocations $relatedLocations
     * @return \CUCM\StructType\UpdateLocationReq
     */
    public function setRelatedLocations(\CUCM\StructType\RelatedLocations $relatedLocations = null)
    {
        $this->relatedLocations = $relatedLocations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateLocationReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
