<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateLineGroupReq StructType
 * @subpackage Structs
 */
class UpdateLineGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The distributionAlgorithm
     * Meta informations extracted from the WSDL
     * - default: Longest Idle Time
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $distributionAlgorithm;
    /**
     * The rnaReversionTimeOut
     * Meta informations extracted from the WSDL
     * - default: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $rnaReversionTimeOut;
    /**
     * The huntAlgorithmNoAnswer
     * Meta informations extracted from the WSDL
     * - default: Try next member; then, try next group in Hunt List
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $huntAlgorithmNoAnswer;
    /**
     * The huntAlgorithmBusy
     * Meta informations extracted from the WSDL
     * - default: Try next member; then, try next group in Hunt List
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $huntAlgorithmBusy;
    /**
     * The huntAlgorithmNotAvailable
     * Meta informations extracted from the WSDL
     * - default: Try next member; then, try next group in Hunt List
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $huntAlgorithmNotAvailable;
    /**
     * The removeMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RemoveMembers
     */
    public $removeMembers;
    /**
     * The addMembers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AddMembers
     */
    public $addMembers;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\Members
     */
    public $members;
    /**
     * Constructor method for UpdateLineGroupReq
     * @uses UpdateLineGroupReq::setNewName()
     * @uses UpdateLineGroupReq::setDistributionAlgorithm()
     * @uses UpdateLineGroupReq::setRnaReversionTimeOut()
     * @uses UpdateLineGroupReq::setHuntAlgorithmNoAnswer()
     * @uses UpdateLineGroupReq::setHuntAlgorithmBusy()
     * @uses UpdateLineGroupReq::setHuntAlgorithmNotAvailable()
     * @uses UpdateLineGroupReq::setRemoveMembers()
     * @uses UpdateLineGroupReq::setAddMembers()
     * @uses UpdateLineGroupReq::setMembers()
     * @param string $newName
     * @param string $distributionAlgorithm
     * @param string $rnaReversionTimeOut
     * @param string $huntAlgorithmNoAnswer
     * @param string $huntAlgorithmBusy
     * @param string $huntAlgorithmNotAvailable
     * @param \CUCM\StructType\RemoveMembers $removeMembers
     * @param \CUCM\StructType\AddMembers $addMembers
     * @param \CUCM\StructType\Members $members
     */
    public function __construct($newName = null, $distributionAlgorithm = 'Longest Idle Time', $rnaReversionTimeOut = '10', $huntAlgorithmNoAnswer = 'Try next member; then, try next group in Hunt List', $huntAlgorithmBusy = 'Try next member; then, try next group in Hunt List', $huntAlgorithmNotAvailable = 'Try next member; then, try next group in Hunt List', \CUCM\StructType\RemoveMembers $removeMembers = null, \CUCM\StructType\AddMembers $addMembers = null, \CUCM\StructType\Members $members = null)
    {
        $this
            ->setNewName($newName)
            ->setDistributionAlgorithm($distributionAlgorithm)
            ->setRnaReversionTimeOut($rnaReversionTimeOut)
            ->setHuntAlgorithmNoAnswer($huntAlgorithmNoAnswer)
            ->setHuntAlgorithmBusy($huntAlgorithmBusy)
            ->setHuntAlgorithmNotAvailable($huntAlgorithmNotAvailable)
            ->setRemoveMembers($removeMembers)
            ->setAddMembers($addMembers)
            ->setMembers($members);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateLineGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get distributionAlgorithm value
     * @return string|null
     */
    public function getDistributionAlgorithm()
    {
        return $this->distributionAlgorithm;
    }
    /**
     * Set distributionAlgorithm value
     * @uses \CUCM\EnumType\XDistributeAlgorithm::valueIsValid()
     * @uses \CUCM\EnumType\XDistributeAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $distributionAlgorithm
     * @return \CUCM\StructType\UpdateLineGroupReq
     */
    public function setDistributionAlgorithm($distributionAlgorithm = 'Longest Idle Time')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XDistributeAlgorithm::valueIsValid($distributionAlgorithm)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $distributionAlgorithm, implode(', ', \CUCM\EnumType\XDistributeAlgorithm::getValidValues())), __LINE__);
        }
        $this->distributionAlgorithm = $distributionAlgorithm;
        return $this;
    }
    /**
     * Get rnaReversionTimeOut value
     * @return string|null
     */
    public function getRnaReversionTimeOut()
    {
        return $this->rnaReversionTimeOut;
    }
    /**
     * Set rnaReversionTimeOut value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rnaReversionTimeOut
     * @return \CUCM\StructType\UpdateLineGroupReq
     */
    public function setRnaReversionTimeOut($rnaReversionTimeOut = '10')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($rnaReversionTimeOut)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rnaReversionTimeOut, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->rnaReversionTimeOut = $rnaReversionTimeOut;
        return $this;
    }
    /**
     * Get huntAlgorithmNoAnswer value
     * @return string|null
     */
    public function getHuntAlgorithmNoAnswer()
    {
        return $this->huntAlgorithmNoAnswer;
    }
    /**
     * Set huntAlgorithmNoAnswer value
     * @uses \CUCM\EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \CUCM\EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmNoAnswer
     * @return \CUCM\StructType\UpdateLineGroupReq
     */
    public function setHuntAlgorithmNoAnswer($huntAlgorithmNoAnswer = 'Try next member; then, try next group in Hunt List')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmNoAnswer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huntAlgorithmNoAnswer, implode(', ', \CUCM\EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmNoAnswer = $huntAlgorithmNoAnswer;
        return $this;
    }
    /**
     * Get huntAlgorithmBusy value
     * @return string|null
     */
    public function getHuntAlgorithmBusy()
    {
        return $this->huntAlgorithmBusy;
    }
    /**
     * Set huntAlgorithmBusy value
     * @uses \CUCM\EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \CUCM\EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmBusy
     * @return \CUCM\StructType\UpdateLineGroupReq
     */
    public function setHuntAlgorithmBusy($huntAlgorithmBusy = 'Try next member; then, try next group in Hunt List')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmBusy)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huntAlgorithmBusy, implode(', ', \CUCM\EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmBusy = $huntAlgorithmBusy;
        return $this;
    }
    /**
     * Get huntAlgorithmNotAvailable value
     * @return string|null
     */
    public function getHuntAlgorithmNotAvailable()
    {
        return $this->huntAlgorithmNotAvailable;
    }
    /**
     * Set huntAlgorithmNotAvailable value
     * @uses \CUCM\EnumType\XHuntAlgorithm::valueIsValid()
     * @uses \CUCM\EnumType\XHuntAlgorithm::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $huntAlgorithmNotAvailable
     * @return \CUCM\StructType\UpdateLineGroupReq
     */
    public function setHuntAlgorithmNotAvailable($huntAlgorithmNotAvailable = 'Try next member; then, try next group in Hunt List')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XHuntAlgorithm::valueIsValid($huntAlgorithmNotAvailable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $huntAlgorithmNotAvailable, implode(', ', \CUCM\EnumType\XHuntAlgorithm::getValidValues())), __LINE__);
        }
        $this->huntAlgorithmNotAvailable = $huntAlgorithmNotAvailable;
        return $this;
    }
    /**
     * Get removeMembers value
     * @return \CUCM\StructType\RemoveMembers|null
     */
    public function getRemoveMembers()
    {
        return $this->removeMembers;
    }
    /**
     * Set removeMembers value
     * @param \CUCM\StructType\RemoveMembers $removeMembers
     * @return \CUCM\StructType\UpdateLineGroupReq
     */
    public function setRemoveMembers(\CUCM\StructType\RemoveMembers $removeMembers = null)
    {
        $this->removeMembers = $removeMembers;
        return $this;
    }
    /**
     * Get addMembers value
     * @return \CUCM\StructType\AddMembers|null
     */
    public function getAddMembers()
    {
        return $this->addMembers;
    }
    /**
     * Set addMembers value
     * @param \CUCM\StructType\AddMembers $addMembers
     * @return \CUCM\StructType\UpdateLineGroupReq
     */
    public function setAddMembers(\CUCM\StructType\AddMembers $addMembers = null)
    {
        $this->addMembers = $addMembers;
        return $this;
    }
    /**
     * Get members value
     * @return \CUCM\StructType\Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \CUCM\StructType\Members $members
     * @return \CUCM\StructType\UpdateLineGroupReq
     */
    public function setMembers(\CUCM\StructType\Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateLineGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
