<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateImeRouteFilterElementReq StructType
 * @subpackage Structs
 */
class UpdateImeRouteFilterElementReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 50
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The elementType
     * Meta informations extracted from the WSDL
     * - default: Domain
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $elementType;
    /**
     * The imeRouteFilterGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $imeRouteFilterGroupName;
    /**
     * Constructor method for UpdateImeRouteFilterElementReq
     * @uses UpdateImeRouteFilterElementReq::setNewName()
     * @uses UpdateImeRouteFilterElementReq::setDescription()
     * @uses UpdateImeRouteFilterElementReq::setElementType()
     * @uses UpdateImeRouteFilterElementReq::setImeRouteFilterGroupName()
     * @param string $newName
     * @param string $description
     * @param string $elementType
     * @param \CUCM\StructType\XFkType $imeRouteFilterGroupName
     */
    public function __construct($newName = null, $description = null, $elementType = 'Domain', \CUCM\StructType\XFkType $imeRouteFilterGroupName = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setElementType($elementType)
            ->setImeRouteFilterGroupName($imeRouteFilterGroupName);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateImeRouteFilterElementReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 50) || (is_array($newName) && count($newName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateImeRouteFilterElementReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get elementType value
     * @return string|null
     */
    public function getElementType()
    {
        return $this->elementType;
    }
    /**
     * Set elementType value
     * @uses \CUCM\EnumType\XViprFilterElement::valueIsValid()
     * @uses \CUCM\EnumType\XViprFilterElement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $elementType
     * @return \CUCM\StructType\UpdateImeRouteFilterElementReq
     */
    public function setElementType($elementType = 'Domain')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XViprFilterElement::valueIsValid($elementType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $elementType, implode(', ', \CUCM\EnumType\XViprFilterElement::getValidValues())), __LINE__);
        }
        $this->elementType = $elementType;
        return $this;
    }
    /**
     * Get imeRouteFilterGroupName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getImeRouteFilterGroupName()
    {
        return $this->imeRouteFilterGroupName;
    }
    /**
     * Set imeRouteFilterGroupName value
     * @param \CUCM\StructType\XFkType $imeRouteFilterGroupName
     * @return \CUCM\StructType\UpdateImeRouteFilterElementReq
     */
    public function setImeRouteFilterGroupName(\CUCM\StructType\XFkType $imeRouteFilterGroupName = null)
    {
        $this->imeRouteFilterGroupName = $imeRouteFilterGroupName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateImeRouteFilterElementReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
