<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateFallbackFeatureConfigReq StructType
 * @subpackage Structs
 */
class UpdateFallbackFeatureConfigReq extends AbstractStructBase
{
    /**
     * The enableFallbackForImeCalls
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableFallbackForImeCalls;
    /**
     * The qosSensistivityLevel
     * Meta informations extracted from the WSDL
     * - documentation: Valid Values are from 0 to 5
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $qosSensistivityLevel;
    /**
     * The dtmfCorrelationDigits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dtmfCorrelationDigits;
    /**
     * The dtmfCollectionTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dtmfCollectionTimer;
    /**
     * The callAnswerTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callAnswerTimer;
    /**
     * The clearImeCallDelayTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $clearImeCallDelayTimer;
    /**
     * The dtmfInterDigitDelayTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dtmfInterDigitDelayTimer;
    /**
     * The postConnectFallbackDelayTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $postConnectFallbackDelayTimer;
    /**
     * The fallbackSplitDelayTimer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fallbackSplitDelayTimer;
    /**
     * The callCss
     * Meta informations extracted from the WSDL
     * - documentation: Valid Values are 0 and 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $callCss;
    /**
     * Constructor method for UpdateFallbackFeatureConfigReq
     * @uses UpdateFallbackFeatureConfigReq::setEnableFallbackForImeCalls()
     * @uses UpdateFallbackFeatureConfigReq::setQosSensistivityLevel()
     * @uses UpdateFallbackFeatureConfigReq::setDtmfCorrelationDigits()
     * @uses UpdateFallbackFeatureConfigReq::setDtmfCollectionTimer()
     * @uses UpdateFallbackFeatureConfigReq::setCallAnswerTimer()
     * @uses UpdateFallbackFeatureConfigReq::setClearImeCallDelayTimer()
     * @uses UpdateFallbackFeatureConfigReq::setDtmfInterDigitDelayTimer()
     * @uses UpdateFallbackFeatureConfigReq::setPostConnectFallbackDelayTimer()
     * @uses UpdateFallbackFeatureConfigReq::setFallbackSplitDelayTimer()
     * @uses UpdateFallbackFeatureConfigReq::setCallCss()
     * @param string $enableFallbackForImeCalls
     * @param string $qosSensistivityLevel
     * @param string $dtmfCorrelationDigits
     * @param string $dtmfCollectionTimer
     * @param string $callAnswerTimer
     * @param string $clearImeCallDelayTimer
     * @param string $dtmfInterDigitDelayTimer
     * @param string $postConnectFallbackDelayTimer
     * @param string $fallbackSplitDelayTimer
     * @param string $callCss
     */
    public function __construct($enableFallbackForImeCalls = null, $qosSensistivityLevel = null, $dtmfCorrelationDigits = null, $dtmfCollectionTimer = null, $callAnswerTimer = null, $clearImeCallDelayTimer = null, $dtmfInterDigitDelayTimer = null, $postConnectFallbackDelayTimer = null, $fallbackSplitDelayTimer = null, $callCss = null)
    {
        $this
            ->setEnableFallbackForImeCalls($enableFallbackForImeCalls)
            ->setQosSensistivityLevel($qosSensistivityLevel)
            ->setDtmfCorrelationDigits($dtmfCorrelationDigits)
            ->setDtmfCollectionTimer($dtmfCollectionTimer)
            ->setCallAnswerTimer($callAnswerTimer)
            ->setClearImeCallDelayTimer($clearImeCallDelayTimer)
            ->setDtmfInterDigitDelayTimer($dtmfInterDigitDelayTimer)
            ->setPostConnectFallbackDelayTimer($postConnectFallbackDelayTimer)
            ->setFallbackSplitDelayTimer($fallbackSplitDelayTimer)
            ->setCallCss($callCss);
    }
    /**
     * Get enableFallbackForImeCalls value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnableFallbackForImeCalls()
    {
        return isset($this->enableFallbackForImeCalls) ? $this->enableFallbackForImeCalls : null;
    }
    /**
     * Set enableFallbackForImeCalls value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enableFallbackForImeCalls
     * @return \CUCM\StructType\UpdateFallbackFeatureConfigReq
     */
    public function setEnableFallbackForImeCalls($enableFallbackForImeCalls = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enableFallbackForImeCalls) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableFallbackForImeCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableFallbackForImeCalls, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableFallbackForImeCalls) && !is_string($enableFallbackForImeCalls)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableFallbackForImeCalls)), __LINE__);
        }
        if (is_null($enableFallbackForImeCalls) || (is_array($enableFallbackForImeCalls) && empty($enableFallbackForImeCalls))) {
            unset($this->enableFallbackForImeCalls);
        } else {
            $this->enableFallbackForImeCalls = $enableFallbackForImeCalls;
        }
        return $this;
    }
    /**
     * Get qosSensistivityLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQosSensistivityLevel()
    {
        return isset($this->qosSensistivityLevel) ? $this->qosSensistivityLevel : null;
    }
    /**
     * Set qosSensistivityLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qosSensistivityLevel
     * @return \CUCM\StructType\UpdateFallbackFeatureConfigReq
     */
    public function setQosSensistivityLevel($qosSensistivityLevel = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($qosSensistivityLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qosSensistivityLevel, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($qosSensistivityLevel) || (is_array($qosSensistivityLevel) && empty($qosSensistivityLevel))) {
            unset($this->qosSensistivityLevel);
        } else {
            $this->qosSensistivityLevel = $qosSensistivityLevel;
        }
        return $this;
    }
    /**
     * Get dtmfCorrelationDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDtmfCorrelationDigits()
    {
        return isset($this->dtmfCorrelationDigits) ? $this->dtmfCorrelationDigits : null;
    }
    /**
     * Set dtmfCorrelationDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfCorrelationDigits
     * @return \CUCM\StructType\UpdateFallbackFeatureConfigReq
     */
    public function setDtmfCorrelationDigits($dtmfCorrelationDigits = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($dtmfCorrelationDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dtmfCorrelationDigits, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($dtmfCorrelationDigits) || (is_array($dtmfCorrelationDigits) && empty($dtmfCorrelationDigits))) {
            unset($this->dtmfCorrelationDigits);
        } else {
            $this->dtmfCorrelationDigits = $dtmfCorrelationDigits;
        }
        return $this;
    }
    /**
     * Get dtmfCollectionTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDtmfCollectionTimer()
    {
        return isset($this->dtmfCollectionTimer) ? $this->dtmfCollectionTimer : null;
    }
    /**
     * Set dtmfCollectionTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfCollectionTimer
     * @return \CUCM\StructType\UpdateFallbackFeatureConfigReq
     */
    public function setDtmfCollectionTimer($dtmfCollectionTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($dtmfCollectionTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dtmfCollectionTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($dtmfCollectionTimer) || (is_array($dtmfCollectionTimer) && empty($dtmfCollectionTimer))) {
            unset($this->dtmfCollectionTimer);
        } else {
            $this->dtmfCollectionTimer = $dtmfCollectionTimer;
        }
        return $this;
    }
    /**
     * Get callAnswerTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallAnswerTimer()
    {
        return isset($this->callAnswerTimer) ? $this->callAnswerTimer : null;
    }
    /**
     * Set callAnswerTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callAnswerTimer
     * @return \CUCM\StructType\UpdateFallbackFeatureConfigReq
     */
    public function setCallAnswerTimer($callAnswerTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($callAnswerTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callAnswerTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callAnswerTimer) || (is_array($callAnswerTimer) && empty($callAnswerTimer))) {
            unset($this->callAnswerTimer);
        } else {
            $this->callAnswerTimer = $callAnswerTimer;
        }
        return $this;
    }
    /**
     * Get clearImeCallDelayTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClearImeCallDelayTimer()
    {
        return isset($this->clearImeCallDelayTimer) ? $this->clearImeCallDelayTimer : null;
    }
    /**
     * Set clearImeCallDelayTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clearImeCallDelayTimer
     * @return \CUCM\StructType\UpdateFallbackFeatureConfigReq
     */
    public function setClearImeCallDelayTimer($clearImeCallDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($clearImeCallDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $clearImeCallDelayTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($clearImeCallDelayTimer) || (is_array($clearImeCallDelayTimer) && empty($clearImeCallDelayTimer))) {
            unset($this->clearImeCallDelayTimer);
        } else {
            $this->clearImeCallDelayTimer = $clearImeCallDelayTimer;
        }
        return $this;
    }
    /**
     * Get dtmfInterDigitDelayTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDtmfInterDigitDelayTimer()
    {
        return isset($this->dtmfInterDigitDelayTimer) ? $this->dtmfInterDigitDelayTimer : null;
    }
    /**
     * Set dtmfInterDigitDelayTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dtmfInterDigitDelayTimer
     * @return \CUCM\StructType\UpdateFallbackFeatureConfigReq
     */
    public function setDtmfInterDigitDelayTimer($dtmfInterDigitDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($dtmfInterDigitDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dtmfInterDigitDelayTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($dtmfInterDigitDelayTimer) || (is_array($dtmfInterDigitDelayTimer) && empty($dtmfInterDigitDelayTimer))) {
            unset($this->dtmfInterDigitDelayTimer);
        } else {
            $this->dtmfInterDigitDelayTimer = $dtmfInterDigitDelayTimer;
        }
        return $this;
    }
    /**
     * Get postConnectFallbackDelayTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostConnectFallbackDelayTimer()
    {
        return isset($this->postConnectFallbackDelayTimer) ? $this->postConnectFallbackDelayTimer : null;
    }
    /**
     * Set postConnectFallbackDelayTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $postConnectFallbackDelayTimer
     * @return \CUCM\StructType\UpdateFallbackFeatureConfigReq
     */
    public function setPostConnectFallbackDelayTimer($postConnectFallbackDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($postConnectFallbackDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $postConnectFallbackDelayTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($postConnectFallbackDelayTimer) || (is_array($postConnectFallbackDelayTimer) && empty($postConnectFallbackDelayTimer))) {
            unset($this->postConnectFallbackDelayTimer);
        } else {
            $this->postConnectFallbackDelayTimer = $postConnectFallbackDelayTimer;
        }
        return $this;
    }
    /**
     * Get fallbackSplitDelayTimer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFallbackSplitDelayTimer()
    {
        return isset($this->fallbackSplitDelayTimer) ? $this->fallbackSplitDelayTimer : null;
    }
    /**
     * Set fallbackSplitDelayTimer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fallbackSplitDelayTimer
     * @return \CUCM\StructType\UpdateFallbackFeatureConfigReq
     */
    public function setFallbackSplitDelayTimer($fallbackSplitDelayTimer = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($fallbackSplitDelayTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fallbackSplitDelayTimer, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($fallbackSplitDelayTimer) || (is_array($fallbackSplitDelayTimer) && empty($fallbackSplitDelayTimer))) {
            unset($this->fallbackSplitDelayTimer);
        } else {
            $this->fallbackSplitDelayTimer = $fallbackSplitDelayTimer;
        }
        return $this;
    }
    /**
     * Get callCss value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCallCss()
    {
        return isset($this->callCss) ? $this->callCss : null;
    }
    /**
     * Set callCss value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callCss
     * @return \CUCM\StructType\UpdateFallbackFeatureConfigReq
     */
    public function setCallCss($callCss = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($callCss)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callCss, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        if (is_null($callCss) || (is_array($callCss) && empty($callCss))) {
            unset($this->callCss);
        } else {
            $this->callCss = $callCss;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateFallbackFeatureConfigReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
