<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDirectedCallParkReq StructType
 * @subpackage Structs
 */
class UpdateDirectedCallParkReq extends APIRequest
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $routePartitionName;
    /**
     * The newPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The newRoutePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $newRoutePartitionName;
    /**
     * The retrievalPrefix
     * Meta informations extracted from the WSDL
     * - documentation: The prefix used for park-code retrieval. User will dial prefix plus park code to retrieve a parked call.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $retrievalPrefix;
    /**
     * The reversionPattern
     * Meta informations extracted from the WSDL
     * - documentation: The pattern used to revert the call when the parked call is not retrieved within retrieval timer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $reversionPattern;
    /**
     * The revertCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $revertCssName;
    /**
     * Constructor method for UpdateDirectedCallParkReq
     * @uses UpdateDirectedCallParkReq::setPattern()
     * @uses UpdateDirectedCallParkReq::setUuid()
     * @uses UpdateDirectedCallParkReq::setRoutePartitionName()
     * @uses UpdateDirectedCallParkReq::setNewPattern()
     * @uses UpdateDirectedCallParkReq::setDescription()
     * @uses UpdateDirectedCallParkReq::setNewRoutePartitionName()
     * @uses UpdateDirectedCallParkReq::setRetrievalPrefix()
     * @uses UpdateDirectedCallParkReq::setReversionPattern()
     * @uses UpdateDirectedCallParkReq::setRevertCssName()
     * @param string $pattern
     * @param string $uuid
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @param string $newPattern
     * @param string $description
     * @param \CUCM\StructType\XFkType $newRoutePartitionName
     * @param string $retrievalPrefix
     * @param string $reversionPattern
     * @param \CUCM\StructType\XFkType $revertCssName
     */
    public function __construct($pattern = null, $uuid = null, \CUCM\StructType\XFkType $routePartitionName = null, $newPattern = null, $description = null, \CUCM\StructType\XFkType $newRoutePartitionName = null, $retrievalPrefix = null, $reversionPattern = null, \CUCM\StructType\XFkType $revertCssName = null)
    {
        $this
            ->setPattern($pattern)
            ->setUuid($uuid)
            ->setRoutePartitionName($routePartitionName)
            ->setNewPattern($newPattern)
            ->setDescription($description)
            ->setNewRoutePartitionName($newRoutePartitionName)
            ->setRetrievalPrefix($retrievalPrefix)
            ->setReversionPattern($reversionPattern)
            ->setRevertCssName($revertCssName);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return \CUCM\StructType\UpdateDirectedCallParkReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \CUCM\StructType\UpdateDirectedCallParkReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\\{........-....-....-....-............\\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get routePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRoutePartitionName()
    {
        return isset($this->routePartitionName) ? $this->routePartitionName : null;
    }
    /**
     * Set routePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $routePartitionName
     * @return \CUCM\StructType\UpdateDirectedCallParkReq
     */
    public function setRoutePartitionName(\CUCM\StructType\XFkType $routePartitionName = null)
    {
        if (is_null($routePartitionName) || (is_array($routePartitionName) && empty($routePartitionName))) {
            unset($this->routePartitionName);
        } else {
            $this->routePartitionName = $routePartitionName;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return \CUCM\StructType\UpdateDirectedCallParkReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateDirectedCallParkReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get newRoutePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getNewRoutePartitionName()
    {
        return isset($this->newRoutePartitionName) ? $this->newRoutePartitionName : null;
    }
    /**
     * Set newRoutePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $newRoutePartitionName
     * @return \CUCM\StructType\UpdateDirectedCallParkReq
     */
    public function setNewRoutePartitionName(\CUCM\StructType\XFkType $newRoutePartitionName = null)
    {
        if (is_null($newRoutePartitionName) || (is_array($newRoutePartitionName) && empty($newRoutePartitionName))) {
            unset($this->newRoutePartitionName);
        } else {
            $this->newRoutePartitionName = $newRoutePartitionName;
        }
        return $this;
    }
    /**
     * Get retrievalPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRetrievalPrefix()
    {
        return isset($this->retrievalPrefix) ? $this->retrievalPrefix : null;
    }
    /**
     * Set retrievalPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $retrievalPrefix
     * @return \CUCM\StructType\UpdateDirectedCallParkReq
     */
    public function setRetrievalPrefix($retrievalPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($retrievalPrefix) && !is_string($retrievalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retrievalPrefix)), __LINE__);
        }
        if (is_null($retrievalPrefix) || (is_array($retrievalPrefix) && empty($retrievalPrefix))) {
            unset($this->retrievalPrefix);
        } else {
            $this->retrievalPrefix = $retrievalPrefix;
        }
        return $this;
    }
    /**
     * Get reversionPattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReversionPattern()
    {
        return isset($this->reversionPattern) ? $this->reversionPattern : null;
    }
    /**
     * Set reversionPattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reversionPattern
     * @return \CUCM\StructType\UpdateDirectedCallParkReq
     */
    public function setReversionPattern($reversionPattern = null)
    {
        // validation for constraint: string
        if (!is_null($reversionPattern) && !is_string($reversionPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reversionPattern)), __LINE__);
        }
        if (is_null($reversionPattern) || (is_array($reversionPattern) && empty($reversionPattern))) {
            unset($this->reversionPattern);
        } else {
            $this->reversionPattern = $reversionPattern;
        }
        return $this;
    }
    /**
     * Get revertCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getRevertCssName()
    {
        return isset($this->revertCssName) ? $this->revertCssName : null;
    }
    /**
     * Set revertCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $revertCssName
     * @return \CUCM\StructType\UpdateDirectedCallParkReq
     */
    public function setRevertCssName(\CUCM\StructType\XFkType $revertCssName = null)
    {
        if (is_null($revertCssName) || (is_array($revertCssName) && empty($revertCssName))) {
            unset($this->revertCssName);
        } else {
            $this->revertCssName = $revertCssName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateDirectedCallParkReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
