<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDateTimeGroupReq StructType
 * @subpackage Structs
 */
class UpdateDateTimeGroupReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newName;
    /**
     * The timeZone
     * Meta informations extracted from the WSDL
     * - default: Europe/London
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeZone;
    /**
     * The separator
     * Meta informations extracted from the WSDL
     * - documentation: It can be one among / (slash), . (dot), - (dash)
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $separator;
    /**
     * The dateformat
     * Meta informations extracted from the WSDL
     * - documentation: It can be one among D/M/Y,M/D/Y,Y/M/D
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $dateformat;
    /**
     * The timeFormat
     * Meta informations extracted from the WSDL
     * - documentation: It can be one among 12-hour,24-hour
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeFormat;
    /**
     * The removePhoneNtpReferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\RemovePhoneNtpReferences
     */
    public $removePhoneNtpReferences;
    /**
     * The addPhoneNtpReferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\AddPhoneNtpReferences
     */
    public $addPhoneNtpReferences;
    /**
     * The phoneNtpReferences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\PhoneNtpReferences
     */
    public $phoneNtpReferences;
    /**
     * Constructor method for UpdateDateTimeGroupReq
     * @uses UpdateDateTimeGroupReq::setNewName()
     * @uses UpdateDateTimeGroupReq::setTimeZone()
     * @uses UpdateDateTimeGroupReq::setSeparator()
     * @uses UpdateDateTimeGroupReq::setDateformat()
     * @uses UpdateDateTimeGroupReq::setTimeFormat()
     * @uses UpdateDateTimeGroupReq::setRemovePhoneNtpReferences()
     * @uses UpdateDateTimeGroupReq::setAddPhoneNtpReferences()
     * @uses UpdateDateTimeGroupReq::setPhoneNtpReferences()
     * @param string $newName
     * @param string $timeZone
     * @param string $separator
     * @param string $dateformat
     * @param string $timeFormat
     * @param \CUCM\StructType\RemovePhoneNtpReferences $removePhoneNtpReferences
     * @param \CUCM\StructType\AddPhoneNtpReferences $addPhoneNtpReferences
     * @param \CUCM\StructType\PhoneNtpReferences $phoneNtpReferences
     */
    public function __construct($newName = null, $timeZone = 'Europe/London', $separator = null, $dateformat = null, $timeFormat = null, \CUCM\StructType\RemovePhoneNtpReferences $removePhoneNtpReferences = null, \CUCM\StructType\AddPhoneNtpReferences $addPhoneNtpReferences = null, \CUCM\StructType\PhoneNtpReferences $phoneNtpReferences = null)
    {
        $this
            ->setNewName($newName)
            ->setTimeZone($timeZone)
            ->setSeparator($separator)
            ->setDateformat($dateformat)
            ->setTimeFormat($timeFormat)
            ->setRemovePhoneNtpReferences($removePhoneNtpReferences)
            ->setAddPhoneNtpReferences($addPhoneNtpReferences)
            ->setPhoneNtpReferences($phoneNtpReferences);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateDateTimeGroupReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses \CUCM\EnumType\XTimeZone::valueIsValid()
     * @uses \CUCM\EnumType\XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return \CUCM\StructType\UpdateDateTimeGroupReq
     */
    public function setTimeZone($timeZone = 'Europe/London')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeZone, implode(', ', \CUCM\EnumType\XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get separator value
     * @return string|null
     */
    public function getSeparator()
    {
        return $this->separator;
    }
    /**
     * Set separator value
     * @param string $separator
     * @return \CUCM\StructType\UpdateDateTimeGroupReq
     */
    public function setSeparator($separator = null)
    {
        // validation for constraint: string
        if (!is_null($separator) && !is_string($separator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($separator)), __LINE__);
        }
        $this->separator = $separator;
        return $this;
    }
    /**
     * Get dateformat value
     * @return string|null
     */
    public function getDateformat()
    {
        return $this->dateformat;
    }
    /**
     * Set dateformat value
     * @param string $dateformat
     * @return \CUCM\StructType\UpdateDateTimeGroupReq
     */
    public function setDateformat($dateformat = null)
    {
        // validation for constraint: string
        if (!is_null($dateformat) && !is_string($dateformat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateformat)), __LINE__);
        }
        $this->dateformat = $dateformat;
        return $this;
    }
    /**
     * Get timeFormat value
     * @return string|null
     */
    public function getTimeFormat()
    {
        return $this->timeFormat;
    }
    /**
     * Set timeFormat value
     * @param string $timeFormat
     * @return \CUCM\StructType\UpdateDateTimeGroupReq
     */
    public function setTimeFormat($timeFormat = null)
    {
        // validation for constraint: string
        if (!is_null($timeFormat) && !is_string($timeFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeFormat)), __LINE__);
        }
        $this->timeFormat = $timeFormat;
        return $this;
    }
    /**
     * Get removePhoneNtpReferences value
     * @return \CUCM\StructType\RemovePhoneNtpReferences|null
     */
    public function getRemovePhoneNtpReferences()
    {
        return $this->removePhoneNtpReferences;
    }
    /**
     * Set removePhoneNtpReferences value
     * @param \CUCM\StructType\RemovePhoneNtpReferences $removePhoneNtpReferences
     * @return \CUCM\StructType\UpdateDateTimeGroupReq
     */
    public function setRemovePhoneNtpReferences(\CUCM\StructType\RemovePhoneNtpReferences $removePhoneNtpReferences = null)
    {
        $this->removePhoneNtpReferences = $removePhoneNtpReferences;
        return $this;
    }
    /**
     * Get addPhoneNtpReferences value
     * @return \CUCM\StructType\AddPhoneNtpReferences|null
     */
    public function getAddPhoneNtpReferences()
    {
        return $this->addPhoneNtpReferences;
    }
    /**
     * Set addPhoneNtpReferences value
     * @param \CUCM\StructType\AddPhoneNtpReferences $addPhoneNtpReferences
     * @return \CUCM\StructType\UpdateDateTimeGroupReq
     */
    public function setAddPhoneNtpReferences(\CUCM\StructType\AddPhoneNtpReferences $addPhoneNtpReferences = null)
    {
        $this->addPhoneNtpReferences = $addPhoneNtpReferences;
        return $this;
    }
    /**
     * Get phoneNtpReferences value
     * @return \CUCM\StructType\PhoneNtpReferences|null
     */
    public function getPhoneNtpReferences()
    {
        return $this->phoneNtpReferences;
    }
    /**
     * Set phoneNtpReferences value
     * @param \CUCM\StructType\PhoneNtpReferences $phoneNtpReferences
     * @return \CUCM\StructType\UpdateDateTimeGroupReq
     */
    public function setPhoneNtpReferences(\CUCM\StructType\PhoneNtpReferences $phoneNtpReferences = null)
    {
        $this->phoneNtpReferences = $phoneNtpReferences;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateDateTimeGroupReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
