<?php

namespace CUCM\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateConferenceBridgeReq StructType
 * @subpackage Structs
 */
class UpdateConferenceBridgeReq extends NameAndGUIDRequest
{
    /**
     * The newName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $newName;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $product;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - default: Hub_None
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var \CUCM\StructType\XFkType
     */
    public $locationName;
    /**
     * The loadInformation
     * Meta informations extracted from the WSDL
     * - documentation: This tag is used only by Cisco Conference Bridge Hardware.For devices with load information, if any special load information is specified, the special attribute is set to TRUE. Otherwise, the load information is the default for the
     * product.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XLoadInformation
     */
    public $loadInformation;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - documentation: This tag is used only by Cisco Video Conference Bridge(IPVC-35xx),Cisco Conference Bridge (WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \CUCM\StructType\XVendorConfig
     */
    public $vendorConfig;
    /**
     * The maximumCapacity
     * Meta informations extracted from the WSDL
     * - documentation: This tag is mandatory for Cisco Conference Bridge(WS-SVC-CMM) and Cisco Media Server(WS-SVC-CMM-MS). Valid values for this tag are 32,64,96,128.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $maximumCapacity;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - default: Default
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The securityProfileName
     * Meta informations extracted from the WSDL
     * - documentation: Valid only for Cisco IOS Enhanced Conference Bridge
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \CUCM\StructType\XFkType
     */
    public $securityProfileName;
    /**
     * Constructor method for UpdateConferenceBridgeReq
     * @uses UpdateConferenceBridgeReq::setNewName()
     * @uses UpdateConferenceBridgeReq::setDescription()
     * @uses UpdateConferenceBridgeReq::setProduct()
     * @uses UpdateConferenceBridgeReq::setDevicePoolName()
     * @uses UpdateConferenceBridgeReq::setCommonDeviceConfigName()
     * @uses UpdateConferenceBridgeReq::setLocationName()
     * @uses UpdateConferenceBridgeReq::setLoadInformation()
     * @uses UpdateConferenceBridgeReq::setVendorConfig()
     * @uses UpdateConferenceBridgeReq::setMaximumCapacity()
     * @uses UpdateConferenceBridgeReq::setUseTrustedRelayPoint()
     * @uses UpdateConferenceBridgeReq::setSecurityProfileName()
     * @param string $newName
     * @param string $description
     * @param string $product
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @param \CUCM\StructType\XFkType $locationName
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @param string $maximumCapacity
     * @param string $useTrustedRelayPoint
     * @param \CUCM\StructType\XFkType $securityProfileName
     */
    public function __construct($newName = null, $description = null, $product = null, \CUCM\StructType\XFkType $devicePoolName = null, \CUCM\StructType\XFkType $commonDeviceConfigName = null, \CUCM\StructType\XFkType $locationName = 'Hub_None', \CUCM\StructType\XLoadInformation $loadInformation = null, \CUCM\StructType\XVendorConfig $vendorConfig = null, $maximumCapacity = null, $useTrustedRelayPoint = 'Default', \CUCM\StructType\XFkType $securityProfileName = null)
    {
        $this
            ->setNewName($newName)
            ->setDescription($description)
            ->setProduct($product)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setLocationName($locationName)
            ->setLoadInformation($loadInformation)
            ->setVendorConfig($vendorConfig)
            ->setMaximumCapacity($maximumCapacity)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setSecurityProfileName($securityProfileName);
    }
    /**
     * Get newName value
     * @return string|null
     */
    public function getNewName()
    {
        return $this->newName;
    }
    /**
     * Set newName value
     * @param string $newName
     * @return \CUCM\StructType\UpdateConferenceBridgeReq
     */
    public function setNewName($newName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($newName) && strlen($newName) > 128) || (is_array($newName) && count($newName) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($newName) ? strlen($newName) : count($newName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($newName) && !is_string($newName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newName)), __LINE__);
        }
        $this->newName = $newName;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \CUCM\StructType\UpdateConferenceBridgeReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses \CUCM\EnumType\XProduct::valueIsValid()
     * @uses \CUCM\EnumType\XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \CUCM\StructType\UpdateConferenceBridgeReq
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', \CUCM\EnumType\XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get devicePoolName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getDevicePoolName()
    {
        return isset($this->devicePoolName) ? $this->devicePoolName : null;
    }
    /**
     * Set devicePoolName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $devicePoolName
     * @return \CUCM\StructType\UpdateConferenceBridgeReq
     */
    public function setDevicePoolName(\CUCM\StructType\XFkType $devicePoolName = null)
    {
        if (is_null($devicePoolName) || (is_array($devicePoolName) && empty($devicePoolName))) {
            unset($this->devicePoolName);
        } else {
            $this->devicePoolName = $devicePoolName;
        }
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getCommonDeviceConfigName()
    {
        return isset($this->commonDeviceConfigName) ? $this->commonDeviceConfigName : null;
    }
    /**
     * Set commonDeviceConfigName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $commonDeviceConfigName
     * @return \CUCM\StructType\UpdateConferenceBridgeReq
     */
    public function setCommonDeviceConfigName(\CUCM\StructType\XFkType $commonDeviceConfigName = null)
    {
        if (is_null($commonDeviceConfigName) || (is_array($commonDeviceConfigName) && empty($commonDeviceConfigName))) {
            unset($this->commonDeviceConfigName);
        } else {
            $this->commonDeviceConfigName = $commonDeviceConfigName;
        }
        return $this;
    }
    /**
     * Get locationName value
     * @return \CUCM\StructType\XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \CUCM\StructType\XFkType $locationName
     * @return \CUCM\StructType\UpdateConferenceBridgeReq
     */
    public function setLocationName(\CUCM\StructType\XFkType $locationName = 'Hub_None')
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get loadInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XLoadInformation|null
     */
    public function getLoadInformation()
    {
        return isset($this->loadInformation) ? $this->loadInformation : null;
    }
    /**
     * Set loadInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XLoadInformation $loadInformation
     * @return \CUCM\StructType\UpdateConferenceBridgeReq
     */
    public function setLoadInformation(\CUCM\StructType\XLoadInformation $loadInformation = null)
    {
        if (is_null($loadInformation) || (is_array($loadInformation) && empty($loadInformation))) {
            unset($this->loadInformation);
        } else {
            $this->loadInformation = $loadInformation;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return \CUCM\StructType\XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param \CUCM\StructType\XVendorConfig $vendorConfig
     * @return \CUCM\StructType\UpdateConferenceBridgeReq
     */
    public function setVendorConfig(\CUCM\StructType\XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get maximumCapacity value
     * @return string|null
     */
    public function getMaximumCapacity()
    {
        return $this->maximumCapacity;
    }
    /**
     * Set maximumCapacity value
     * @uses \CUCM\EnumType\XInteger::valueIsValid()
     * @uses \CUCM\EnumType\XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maximumCapacity
     * @return \CUCM\StructType\UpdateConferenceBridgeReq
     */
    public function setMaximumCapacity($maximumCapacity = null)
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XInteger::valueIsValid($maximumCapacity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maximumCapacity, implode(', ', \CUCM\EnumType\XInteger::getValidValues())), __LINE__);
        }
        $this->maximumCapacity = $maximumCapacity;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @uses \CUCM\EnumType\XStatus::valueIsValid()
     * @uses \CUCM\EnumType\XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useTrustedRelayPoint
     * @return \CUCM\StructType\UpdateConferenceBridgeReq
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = 'Default')
    {
        // validation for constraint: enumeration
        if (!\CUCM\EnumType\XStatus::valueIsValid($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useTrustedRelayPoint, implode(', ', \CUCM\EnumType\XStatus::getValidValues())), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get securityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CUCM\StructType\XFkType|null
     */
    public function getSecurityProfileName()
    {
        return isset($this->securityProfileName) ? $this->securityProfileName : null;
    }
    /**
     * Set securityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CUCM\StructType\XFkType $securityProfileName
     * @return \CUCM\StructType\UpdateConferenceBridgeReq
     */
    public function setSecurityProfileName(\CUCM\StructType\XFkType $securityProfileName = null)
    {
        if (is_null($securityProfileName) || (is_array($securityProfileName) && empty($securityProfileName))) {
            unset($this->securityProfileName);
        } else {
            $this->securityProfileName = $securityProfileName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \CUCM\StructType\UpdateConferenceBridgeReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
